/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.slm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicy;

public class PutSnapshotLifecycleAction
extends ActionType<Response> {
    public static final PutSnapshotLifecycleAction INSTANCE = new PutSnapshotLifecycleAction();
    public static final String NAME = "cluster:admin/slm/put";

    protected PutSnapshotLifecycleAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AcknowledgedResponse
    implements ToXContentObject {
        public Response(boolean acknowledged) {
            super(acknowledged);
        }

        public Response(StreamInput streamInput) throws IOException {
            this(streamInput.readBoolean());
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private String lifecycleId;
        private SnapshotLifecyclePolicy lifecycle;

        public Request(String lifecycleId, SnapshotLifecyclePolicy lifecycle) {
            this.lifecycleId = lifecycleId;
            this.lifecycle = lifecycle;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.lifecycleId = in.readString();
            this.lifecycle = new SnapshotLifecyclePolicy(in);
        }

        public Request() {
        }

        public String getLifecycleId() {
            return this.lifecycleId;
        }

        public SnapshotLifecyclePolicy getLifecycle() {
            return this.lifecycle;
        }

        public static Request parseRequest(String lifecycleId, XContentParser parser) {
            return new Request(lifecycleId, SnapshotLifecyclePolicy.parse(parser, lifecycleId));
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.lifecycleId);
            this.lifecycle.writeTo(out);
        }

        @Override
        public ActionRequestValidationException validate() {
            return this.lifecycle.validate();
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(this.lifecycleId, this.lifecycle);
            builder.endObject();
            return builder;
        }

        public int hashCode() {
            return Objects.hash(this.lifecycleId, this.lifecycle);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Request other = (Request)obj;
            return this.lifecycleId.equals(other.lifecycleId) && this.lifecycle.equals(other.lifecycle);
        }

        @Override
        public String toString() {
            return Strings.toString(this);
        }
    }
}

