/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.io.IOException;
import java.util.Base64;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.security.authc.support.AuthenticationContextSerializer;
import org.elasticsearch.xpack.core.security.user.InternalUserSerializationHelper;
import org.elasticsearch.xpack.core.security.user.User;

public class Authentication
implements ToXContentObject {
    public static final Version VERSION_API_KEY_ROLES_AS_BYTES = Version.V_7_9_0;
    private final User user;
    private final RealmRef authenticatedBy;
    private final RealmRef lookedUpBy;
    private final Version version;
    private final AuthenticationType type;
    private final Map<String, Object> metadata;

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy) {
        this(user, authenticatedBy, lookedUpBy, Version.CURRENT);
    }

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy, Version version) {
        this(user, authenticatedBy, lookedUpBy, version, AuthenticationType.REALM, Collections.emptyMap());
    }

    public Authentication(User user, RealmRef authenticatedBy, RealmRef lookedUpBy, Version version, AuthenticationType type, Map<String, Object> metadata) {
        this.user = Objects.requireNonNull(user);
        this.authenticatedBy = Objects.requireNonNull(authenticatedBy);
        this.lookedUpBy = lookedUpBy;
        this.version = version;
        this.type = type;
        this.metadata = metadata;
    }

    public Authentication(StreamInput in) throws IOException {
        this.user = InternalUserSerializationHelper.readFrom(in);
        this.authenticatedBy = new RealmRef(in);
        this.lookedUpBy = in.readBoolean() ? new RealmRef(in) : null;
        this.version = in.getVersion();
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            this.type = AuthenticationType.values()[in.readVInt()];
            this.metadata = in.readMap();
        } else {
            this.type = AuthenticationType.REALM;
            this.metadata = Collections.emptyMap();
        }
    }

    public User getUser() {
        return this.user;
    }

    public RealmRef getAuthenticatedBy() {
        return this.authenticatedBy;
    }

    public RealmRef getLookedUpBy() {
        return this.lookedUpBy;
    }

    public RealmRef getSourceRealm() {
        return this.lookedUpBy == null ? this.authenticatedBy : this.lookedUpBy;
    }

    public Version getVersion() {
        return this.version;
    }

    public AuthenticationType getAuthenticationType() {
        return this.type;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public boolean isServiceAccount() {
        return "_service_account".equals(this.getAuthenticatedBy().getType()) && null == this.getLookedUpBy();
    }

    public void writeToContext(ThreadContext ctx) throws IOException, IllegalArgumentException {
        new AuthenticationContextSerializer().writeToContext(this, ctx);
    }

    public String encode() throws IOException {
        BytesStreamOutput output = new BytesStreamOutput();
        output.setVersion(this.version);
        Version.writeVersion(this.version, output);
        this.writeTo(output);
        return Base64.getEncoder().encodeToString(BytesReference.toBytes(output.bytes()));
    }

    public void writeTo(StreamOutput out) throws IOException {
        InternalUserSerializationHelper.writeTo(this.user, out);
        this.authenticatedBy.writeTo(out);
        if (this.lookedUpBy != null) {
            out.writeBoolean(true);
            this.lookedUpBy.writeTo(out);
        } else {
            out.writeBoolean(false);
        }
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeVInt(this.type.ordinal());
            out.writeMap(this.metadata);
        }
    }

    public boolean canAccessResourcesOf(Authentication other) {
        if (AuthenticationType.API_KEY == this.getAuthenticationType() && AuthenticationType.API_KEY == other.getAuthenticationType()) {
            boolean sameKeyId = this.getMetadata().get("_security_api_key_id").equals(other.getMetadata().get("_security_api_key_id"));
            if (sameKeyId) assert (this.getUser().principal().equals(other.getUser().principal())) : "The same API key ID cannot be attributed to two different usernames";
            return sameKeyId;
        }
        if (this.getAuthenticationType().equals((Object)other.getAuthenticationType()) || AuthenticationType.REALM == this.getAuthenticationType() && AuthenticationType.TOKEN == other.getAuthenticationType() || AuthenticationType.TOKEN == this.getAuthenticationType() && AuthenticationType.REALM == other.getAuthenticationType()) {
            if (!this.getUser().principal().equals(other.getUser().principal())) {
                return false;
            }
            RealmRef thisRealm = this.getSourceRealm();
            RealmRef otherRealm = other.getSourceRealm();
            if ("file".equals(thisRealm.getType()) || "native".equals(thisRealm.getType())) {
                return thisRealm.getType().equals(otherRealm.getType());
            }
            return thisRealm.getName().equals(otherRealm.getName()) && thisRealm.getType().equals(otherRealm.getType());
        }
        assert (EnumSet.of(AuthenticationType.REALM, AuthenticationType.API_KEY, AuthenticationType.TOKEN, AuthenticationType.ANONYMOUS, AuthenticationType.INTERNAL).containsAll(EnumSet.of(this.getAuthenticationType(), other.getAuthenticationType()))) : "cross AuthenticationType comparison for canAccessResourcesOf is not applicable for: " + EnumSet.of(this.getAuthenticationType(), other.getAuthenticationType());
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authentication that = (Authentication)o;
        return this.user.equals(that.user) && this.authenticatedBy.equals(that.authenticatedBy) && Objects.equals(this.lookedUpBy, that.lookedUpBy) && this.version.equals(that.version) && this.type == that.type && this.metadata.equals(that.metadata);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.user, this.authenticatedBy, this.lookedUpBy, this.version, this.type, this.metadata});
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        this.toXContentFragment(builder);
        return builder.endObject();
    }

    public void toXContentFragment(XContentBuilder builder) throws IOException {
        builder.field(User.Fields.USERNAME.getPreferredName(), this.user.principal());
        builder.array(User.Fields.ROLES.getPreferredName(), this.user.roles());
        builder.field(User.Fields.FULL_NAME.getPreferredName(), this.user.fullName());
        builder.field(User.Fields.EMAIL.getPreferredName(), this.user.email());
        if (this.isServiceAccount()) {
            String tokenName = (String)this.getMetadata().get("_token_name");
            assert (tokenName != null) : "token name cannot be null";
            String tokenSource = (String)this.getMetadata().get("_token_source");
            assert (tokenSource != null) : "token source cannot be null";
            builder.field(User.Fields.TOKEN.getPreferredName(), org.elasticsearch.core.Map.of("name", tokenName, "type", "_service_account_" + tokenSource));
        }
        builder.field(User.Fields.METADATA.getPreferredName(), this.user.metadata());
        builder.field(User.Fields.ENABLED.getPreferredName(), this.user.enabled());
        builder.startObject(User.Fields.AUTHENTICATION_REALM.getPreferredName());
        builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getAuthenticatedBy().getName());
        builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getAuthenticatedBy().getType());
        builder.endObject();
        builder.startObject(User.Fields.LOOKUP_REALM.getPreferredName());
        if (this.getLookedUpBy() != null) {
            builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getLookedUpBy().getName());
            builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getLookedUpBy().getType());
        } else {
            builder.field(User.Fields.REALM_NAME.getPreferredName(), this.getAuthenticatedBy().getName());
            builder.field(User.Fields.REALM_TYPE.getPreferredName(), this.getAuthenticatedBy().getType());
        }
        builder.endObject();
        builder.field(User.Fields.AUTHENTICATION_TYPE.getPreferredName(), this.getAuthenticationType().name().toLowerCase(Locale.ROOT));
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("Authentication[").append(this.user).append(",type=").append((Object)this.type).append(",by=").append(this.authenticatedBy);
        if (this.lookedUpBy != null) {
            builder.append(",lookup=").append(this.lookedUpBy);
        }
        builder.append("]");
        return builder.toString();
    }

    public static class RealmRef {
        private final String nodeName;
        private final String name;
        private final String type;

        public RealmRef(String name, String type, String nodeName) {
            this.nodeName = nodeName;
            this.name = name;
            this.type = type;
        }

        public RealmRef(StreamInput in) throws IOException {
            this.nodeName = in.readString();
            this.name = in.readString();
            this.type = in.readString();
        }

        void writeTo(StreamOutput out) throws IOException {
            out.writeString(this.nodeName);
            out.writeString(this.name);
            out.writeString(this.type);
        }

        public String getNodeName() {
            return this.nodeName;
        }

        public String getName() {
            return this.name;
        }

        public String getType() {
            return this.type;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RealmRef realmRef = (RealmRef)o;
            if (!this.nodeName.equals(realmRef.nodeName)) {
                return false;
            }
            if (!this.name.equals(realmRef.name)) {
                return false;
            }
            return this.type.equals(realmRef.type);
        }

        public int hashCode() {
            int result = this.nodeName.hashCode();
            result = 31 * result + this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public String toString() {
            return "{Realm[" + this.type + "." + this.name + "] on Node[" + this.nodeName + "]}";
        }
    }

    public static enum AuthenticationType {
        REALM,
        API_KEY,
        TOKEN,
        ANONYMOUS,
        INTERNAL;

    }
}

