/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.List;
import org.elasticsearch.xpack.core.security.action.service.TokenInfo;

public class GetServiceAccountCredentialsResponse
extends ActionResponse
implements ToXContentObject {
    private final String principal;
    private final String nodeName;
    private final java.util.List<TokenInfo> tokenInfos;

    public GetServiceAccountCredentialsResponse(String principal, String nodeName, Collection<TokenInfo> tokenInfos) {
        this.principal = principal;
        this.nodeName = nodeName;
        this.tokenInfos = tokenInfos == null ? List.of() : List.copyOf(tokenInfos.stream().sorted().collect(Collectors.toList()));
    }

    public GetServiceAccountCredentialsResponse(StreamInput in) throws IOException {
        super(in);
        this.principal = in.readString();
        this.nodeName = in.readString();
        this.tokenInfos = in.readList(TokenInfo::new);
    }

    public String getPrincipal() {
        return this.principal;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public Collection<TokenInfo> getTokenInfos() {
        return this.tokenInfos;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.principal);
        out.writeString(this.nodeName);
        out.writeList(this.tokenInfos);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        Map tokenInfosBySource = this.tokenInfos.stream().collect(Collectors.groupingBy(TokenInfo::getSource, Collectors.toList()));
        builder.startObject().field("service_account", this.principal).field("node_name", this.nodeName).field("count", this.tokenInfos.size()).field("tokens").startObject();
        for (TokenInfo info : tokenInfosBySource.getOrDefault((Object)TokenInfo.TokenSource.INDEX, List.of())) {
            info.toXContent(builder, params);
        }
        builder.endObject().field("file_tokens").startObject();
        for (TokenInfo info : tokenInfosBySource.getOrDefault((Object)TokenInfo.TokenSource.FILE, List.of())) {
            info.toXContent(builder, params);
        }
        builder.endObject().endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetServiceAccountCredentialsResponse that = (GetServiceAccountCredentialsResponse)o;
        return Objects.equals(this.principal, that.principal) && Objects.equals(this.nodeName, that.nodeName) && Objects.equals(this.tokenInfos, that.tokenInfos);
    }

    public int hashCode() {
        return Objects.hash(this.principal, this.nodeName, this.tokenInfos);
    }
}

