/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.role;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;
import org.elasticsearch.xpack.core.security.authz.privilege.ApplicationPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ClusterPrivilegeResolver;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivilege;
import org.elasticsearch.xpack.core.security.authz.privilege.ConfigurableClusterPrivileges;
import org.elasticsearch.xpack.core.security.authz.privilege.IndexPrivilege;
import org.elasticsearch.xpack.core.security.support.MetadataUtils;

public class PutRoleRequest
extends ActionRequest
implements WriteRequest<PutRoleRequest> {
    private String name;
    private String[] clusterPrivileges = Strings.EMPTY_ARRAY;
    private ConfigurableClusterPrivilege[] configurableClusterPrivileges = ConfigurableClusterPrivileges.EMPTY_ARRAY;
    private List<RoleDescriptor.IndicesPrivileges> indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>();
    private List<RoleDescriptor.ApplicationResourcePrivileges> applicationPrivileges = new ArrayList<RoleDescriptor.ApplicationResourcePrivileges>();
    private String[] runAs = Strings.EMPTY_ARRAY;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.IMMEDIATE;
    private Map<String, Object> metadata;

    public PutRoleRequest(StreamInput in) throws IOException {
        super(in);
        this.name = in.readString();
        this.clusterPrivileges = in.readStringArray();
        int indicesSize = in.readVInt();
        this.indicesPrivileges = new ArrayList<RoleDescriptor.IndicesPrivileges>(indicesSize);
        for (int i = 0; i < indicesSize; ++i) {
            this.indicesPrivileges.add(new RoleDescriptor.IndicesPrivileges(in));
        }
        if (in.getVersion().onOrAfter(Version.V_6_4_0)) {
            this.applicationPrivileges = in.readList(RoleDescriptor.ApplicationResourcePrivileges::new);
            this.configurableClusterPrivileges = ConfigurableClusterPrivileges.readArray(in);
        }
        this.runAs = in.readStringArray();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
        this.metadata = in.readMap();
    }

    public PutRoleRequest() {
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.name == null) {
            validationException = ValidateActions.addValidationError("role name is missing", validationException);
        }
        if (this.clusterPrivileges != null) {
            for (String cp : this.clusterPrivileges) {
                try {
                    ClusterPrivilegeResolver.resolve(cp);
                }
                catch (IllegalArgumentException ile) {
                    validationException = ValidateActions.addValidationError(ile.getMessage(), validationException);
                }
            }
        }
        if (this.indicesPrivileges != null) {
            for (RoleDescriptor.IndicesPrivileges idp : this.indicesPrivileges) {
                try {
                    IndexPrivilege.get(Sets.newHashSet(idp.getPrivileges()));
                }
                catch (IllegalArgumentException ile) {
                    validationException = ValidateActions.addValidationError(ile.getMessage(), validationException);
                }
            }
        }
        if (this.applicationPrivileges != null) {
            for (RoleDescriptor.ApplicationResourcePrivileges privilege : this.applicationPrivileges) {
                try {
                    ApplicationPrivilege.validateApplicationNameOrWildcard(privilege.getApplication());
                }
                catch (IllegalArgumentException e) {
                    validationException = ValidateActions.addValidationError(e.getMessage(), validationException);
                }
                for (String name : privilege.getPrivileges()) {
                    try {
                        ApplicationPrivilege.validatePrivilegeOrActionName(name);
                    }
                    catch (IllegalArgumentException e) {
                        validationException = ValidateActions.addValidationError(e.getMessage(), validationException);
                    }
                }
            }
        }
        if (this.metadata != null && MetadataUtils.containsReservedMetadata(this.metadata)) {
            validationException = ValidateActions.addValidationError("metadata keys may not start with [_]", validationException);
        }
        return validationException;
    }

    public void name(String name) {
        this.name = name;
    }

    public void cluster(String ... clusterPrivileges) {
        this.clusterPrivileges = clusterPrivileges;
    }

    public void conditionalCluster(ConfigurableClusterPrivilege ... configurableClusterPrivileges) {
        this.configurableClusterPrivileges = configurableClusterPrivileges;
    }

    public void addIndex(RoleDescriptor.IndicesPrivileges ... privileges) {
        this.indicesPrivileges.addAll(Arrays.asList(privileges));
    }

    public void addIndex(String[] indices, String[] privileges, String[] grantedFields, String[] deniedFields, @Nullable BytesReference query, boolean allowRestrictedIndices) {
        this.indicesPrivileges.add(RoleDescriptor.IndicesPrivileges.builder().indices(indices).privileges(privileges).grantedFields(grantedFields).deniedFields(deniedFields).query(query).allowRestrictedIndices(allowRestrictedIndices).build());
    }

    public void addApplicationPrivileges(RoleDescriptor.ApplicationResourcePrivileges ... privileges) {
        this.applicationPrivileges.addAll(Arrays.asList(privileges));
    }

    public void runAs(String ... usernames) {
        this.runAs = usernames;
    }

    @Override
    public PutRoleRequest setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = refreshPolicy;
        return this;
    }

    @Override
    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void metadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public String name() {
        return this.name;
    }

    public String[] cluster() {
        return this.clusterPrivileges;
    }

    public RoleDescriptor.IndicesPrivileges[] indices() {
        return this.indicesPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[this.indicesPrivileges.size()]);
    }

    public List<RoleDescriptor.ApplicationResourcePrivileges> applicationPrivileges() {
        return Collections.unmodifiableList(this.applicationPrivileges);
    }

    public ConfigurableClusterPrivilege[] conditionalClusterPrivileges() {
        return this.configurableClusterPrivileges;
    }

    public String[] runAs() {
        return this.runAs;
    }

    public Map<String, Object> metadata() {
        return this.metadata;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.name);
        out.writeStringArray(this.clusterPrivileges);
        out.writeVInt(this.indicesPrivileges.size());
        for (RoleDescriptor.IndicesPrivileges index : this.indicesPrivileges) {
            index.writeTo(out);
        }
        if (out.getVersion().onOrAfter(Version.V_6_4_0)) {
            out.writeList(this.applicationPrivileges);
            ConfigurableClusterPrivileges.writeArray(out, this.configurableClusterPrivileges);
        }
        out.writeStringArray(this.runAs);
        this.refreshPolicy.writeTo(out);
        out.writeMap(this.metadata);
    }

    public RoleDescriptor roleDescriptor() {
        return new RoleDescriptor(this.name, this.clusterPrivileges, this.indicesPrivileges.toArray(new RoleDescriptor.IndicesPrivileges[this.indicesPrivileges.size()]), this.applicationPrivileges.toArray(new RoleDescriptor.ApplicationResourcePrivileges[this.applicationPrivileges.size()]), this.configurableClusterPrivileges, this.runAs, this.metadata, Collections.emptyMap());
    }
}

