/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.tasks.TaskId;

public class Blocked
implements ToXContentObject,
Writeable {
    public static final ParseField REASON = new ParseField("reason", new String[0]);
    public static final ParseField TASK_ID = new ParseField("task_id", new String[0]);
    public static final ConstructingObjectParser<Blocked, Void> LENIENT_PARSER = Blocked.createParser(true);
    public static final ConstructingObjectParser<Blocked, Void> STRICT_PARSER = Blocked.createParser(false);
    private final Reason reason;
    @Nullable
    private final TaskId taskId;

    private static ConstructingObjectParser<Blocked, Void> createParser(boolean ignoreUnknownFields) {
        ConstructingObjectParser<Blocked, Void> parser = new ConstructingObjectParser<Blocked, Void>("blocked", ignoreUnknownFields, a -> new Blocked((Reason)((Object)((Object)a[0])), (TaskId)a[1]));
        parser.declareString(ConstructingObjectParser.constructorArg(), Reason::fromString, REASON);
        parser.declareString(ConstructingObjectParser.optionalConstructorArg(), TaskId::new, TASK_ID);
        return parser;
    }

    public Blocked(Reason reason, @Nullable TaskId taskId) {
        this.reason = Objects.requireNonNull(reason);
        this.taskId = taskId;
    }

    public Blocked(StreamInput in) throws IOException {
        this.reason = in.readEnum(Reason.class);
        this.taskId = in.readOptionalWriteable(TaskId::readFromStream);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeEnum(this.reason);
        out.writeOptionalWriteable(this.taskId);
    }

    public Reason getReason() {
        return this.reason;
    }

    @Nullable
    public TaskId getTaskId() {
        return this.taskId;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(REASON.getPreferredName(), (Object)this.reason);
        if (this.taskId != null) {
            builder.field(TASK_ID.getPreferredName(), this.taskId.toString());
        }
        builder.endObject();
        return builder;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.reason, this.taskId});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Blocked that = (Blocked)o;
        return Objects.equals((Object)this.reason, (Object)that.reason) && Objects.equals(this.taskId, that.taskId);
    }

    public static Blocked none() {
        return new Blocked(Reason.NONE, null);
    }

    public static enum Reason {
        NONE,
        DELETE,
        RESET,
        REVERT;


        public static Reason fromString(String value) {
            return Reason.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

