/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.tasks.BaseTasksRequest;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.xpack.core.ml.MlTasks;
import org.elasticsearch.xpack.core.ml.action.StartDatafeedAction;

public class GetDatafeedRunningStateAction
extends ActionType<Response> {
    public static final GetDatafeedRunningStateAction INSTANCE = new GetDatafeedRunningStateAction();
    public static final String NAME = "cluster:internal/xpack/ml/datafeed/running_state";

    private GetDatafeedRunningStateAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends BaseTasksResponse {
        private final Map<String, RunningState> datafeedRunningState;

        public static Response fromResponses(List<Response> responses) {
            return new Response(responses.stream().flatMap(r -> r.datafeedRunningState.entrySet().stream()).filter(entry -> entry.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue)));
        }

        public static Response fromTaskAndState(String datafeedId, RunningState runningState) {
            return new Response(MapBuilder.newMapBuilder().put(datafeedId, runningState).map());
        }

        public Response(StreamInput in) throws IOException {
            super(in);
            this.datafeedRunningState = in.readMap(StreamInput::readString, RunningState::new);
        }

        public Response(Map<String, RunningState> runtimeStateMap) {
            super(null, null);
            this.datafeedRunningState = runtimeStateMap;
        }

        public Optional<RunningState> getRunningState(String datafeedId) {
            return Optional.ofNullable(this.datafeedRunningState.get(datafeedId));
        }

        public Map<String, RunningState> getDatafeedRunningState() {
            return this.datafeedRunningState;
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeMap(this.datafeedRunningState, StreamOutput::writeString, (o, w) -> w.writeTo(o));
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)o;
            return Objects.equals(this.datafeedRunningState, response.datafeedRunningState);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.datafeedRunningState);
        }

        public static class RunningState
        implements Writeable,
        ToXContentObject {
            private final boolean realTimeConfigured;
            private final boolean realTimeRunning;

            public RunningState(boolean realTimeConfigured, boolean realTimeRunning) {
                this.realTimeConfigured = realTimeConfigured;
                this.realTimeRunning = realTimeRunning;
            }

            public RunningState(StreamInput in) throws IOException {
                this.realTimeConfigured = in.readBoolean();
                this.realTimeRunning = in.readBoolean();
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                RunningState that = (RunningState)o;
                return this.realTimeConfigured == that.realTimeConfigured && this.realTimeRunning == that.realTimeRunning;
            }

            public int hashCode() {
                return Objects.hash(this.realTimeConfigured, this.realTimeRunning);
            }

            @Override
            public void writeTo(StreamOutput out) throws IOException {
                out.writeBoolean(this.realTimeConfigured);
                out.writeBoolean(this.realTimeRunning);
            }

            @Override
            public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
                builder.startObject();
                builder.field("real_time_configured", this.realTimeConfigured);
                builder.field("real_time_running", this.realTimeRunning);
                builder.endObject();
                return builder;
            }
        }
    }

    public static class Request
    extends BaseTasksRequest<Request> {
        private final Set<String> datafeedTaskIds;

        public Request(List<String> datafeedIds) {
            this.datafeedTaskIds = datafeedIds.stream().map(MlTasks::datafeedTaskId).collect(Collectors.toSet());
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeedTaskIds = in.readSet(StreamInput::readString);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringCollection(this.datafeedTaskIds);
        }

        public Set<String> getDatafeedTaskIds() {
            return this.datafeedTaskIds;
        }

        @Override
        public boolean match(Task task) {
            return task instanceof StartDatafeedAction.DatafeedTaskMatcher && this.datafeedTaskIds.contains(task.getDescription());
        }
    }
}

