/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.Index;
import org.elasticsearch.xpack.core.ilm.BranchingStep;
import org.elasticsearch.xpack.core.ilm.CheckNotDataStreamWriteIndexStep;
import org.elasticsearch.xpack.core.ilm.CheckShrinkReadyStep;
import org.elasticsearch.xpack.core.ilm.CleanupShrinkIndexStep;
import org.elasticsearch.xpack.core.ilm.ClusterStateWaitUntilThresholdStep;
import org.elasticsearch.xpack.core.ilm.CopyExecutionStateStep;
import org.elasticsearch.xpack.core.ilm.DeleteStep;
import org.elasticsearch.xpack.core.ilm.GenerateUniqueIndexNameStep;
import org.elasticsearch.xpack.core.ilm.LifecycleAction;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.ReadOnlyStep;
import org.elasticsearch.xpack.core.ilm.ReplaceDataStreamBackingIndexStep;
import org.elasticsearch.xpack.core.ilm.SetSingleNodeAllocateStep;
import org.elasticsearch.xpack.core.ilm.ShrinkIndexNameSupplier;
import org.elasticsearch.xpack.core.ilm.ShrinkSetAliasStep;
import org.elasticsearch.xpack.core.ilm.ShrinkStep;
import org.elasticsearch.xpack.core.ilm.ShrunkShardsAllocatedStep;
import org.elasticsearch.xpack.core.ilm.ShrunkenIndexCheckStep;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.WaitForNoFollowersStep;

public class ShrinkAction
implements LifecycleAction {
    private static final Logger logger = LogManager.getLogger(ShrinkAction.class);
    public static final String NAME = "shrink";
    public static final ParseField NUMBER_OF_SHARDS_FIELD = new ParseField("number_of_shards", new String[0]);
    private static final ParseField MAX_PRIMARY_SHARD_SIZE = new ParseField("max_primary_shard_size", new String[0]);
    public static final String CONDITIONAL_SKIP_SHRINK_STEP = "branch-check-prerequisites";
    public static final String CONDITIONAL_DATASTREAM_CHECK_KEY = "branch-on-datastream-check";
    private static final ConstructingObjectParser<ShrinkAction, Void> PARSER = new ConstructingObjectParser("shrink", a -> new ShrinkAction((Integer)a[0], (ByteSizeValue)a[1]));
    private Integer numberOfShards;
    private ByteSizeValue maxPrimaryShardSize;

    public static ShrinkAction parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public ShrinkAction(@Nullable Integer numberOfShards, @Nullable ByteSizeValue maxPrimaryShardSize) {
        if (numberOfShards != null && maxPrimaryShardSize != null) {
            throw new IllegalArgumentException("Cannot set both [number_of_shards] and [max_primary_shard_size]");
        }
        if (numberOfShards == null && maxPrimaryShardSize == null) {
            throw new IllegalArgumentException("Either [number_of_shards] or [max_primary_shard_size] must be set");
        }
        if (maxPrimaryShardSize != null) {
            if (maxPrimaryShardSize.getBytes() <= 0L) {
                throw new IllegalArgumentException("[max_primary_shard_size] must be greater than 0");
            }
            this.maxPrimaryShardSize = maxPrimaryShardSize;
        } else {
            if (numberOfShards <= 0) {
                throw new IllegalArgumentException("[" + NUMBER_OF_SHARDS_FIELD.getPreferredName() + "] must be greater than 0");
            }
            this.numberOfShards = numberOfShards;
        }
    }

    public ShrinkAction(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_7_12_0)) {
            if (in.readBoolean()) {
                this.numberOfShards = in.readVInt();
                this.maxPrimaryShardSize = null;
            } else {
                this.numberOfShards = null;
                this.maxPrimaryShardSize = new ByteSizeValue(in);
            }
        } else {
            this.numberOfShards = in.readVInt();
            this.maxPrimaryShardSize = null;
        }
    }

    Integer getNumberOfShards() {
        return this.numberOfShards;
    }

    ByteSizeValue getMaxPrimaryShardSize() {
        return this.maxPrimaryShardSize;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_7_12_0)) {
            boolean hasNumberOfShards = this.numberOfShards != null;
            out.writeBoolean(hasNumberOfShards);
            if (hasNumberOfShards) {
                out.writeVInt(this.numberOfShards);
            } else {
                this.maxPrimaryShardSize.writeTo(out);
            }
        } else {
            out.writeVInt(this.numberOfShards);
        }
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.numberOfShards != null) {
            builder.field(NUMBER_OF_SHARDS_FIELD.getPreferredName(), this.numberOfShards);
        }
        if (this.maxPrimaryShardSize != null) {
            builder.field(MAX_PRIMARY_SHARD_SIZE.getPreferredName(), this.maxPrimaryShardSize);
        }
        builder.endObject();
        return builder;
    }

    @Override
    public boolean isSafeAction() {
        return false;
    }

    @Override
    public List<Step> toSteps(Client client, String phase, Step.StepKey nextStepKey) {
        Step.StepKey preShrinkBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_SKIP_SHRINK_STEP);
        Step.StepKey checkNotWriteIndex = new Step.StepKey(phase, NAME, "check-not-write-index");
        Step.StepKey waitForNoFollowerStepKey = new Step.StepKey(phase, NAME, "wait-for-shard-history-leases");
        Step.StepKey readOnlyKey = new Step.StepKey(phase, NAME, "readonly");
        Step.StepKey cleanupShrinkIndexKey = new Step.StepKey(phase, NAME, "cleanup-shrink-index");
        Step.StepKey generateShrinkIndexNameKey = new Step.StepKey(phase, NAME, "generate-index-name");
        Step.StepKey setSingleNodeKey = new Step.StepKey(phase, NAME, "set-single-node-allocation");
        Step.StepKey allocationRoutedKey = new Step.StepKey(phase, NAME, "check-shrink-allocation");
        Step.StepKey shrinkKey = new Step.StepKey(phase, NAME, NAME);
        Step.StepKey enoughShardsKey = new Step.StepKey(phase, NAME, "shrunk-shards-allocated");
        Step.StepKey copyMetadataKey = new Step.StepKey(phase, NAME, "copy-execution-state");
        Step.StepKey dataStreamCheckBranchingKey = new Step.StepKey(phase, NAME, CONDITIONAL_DATASTREAM_CHECK_KEY);
        Step.StepKey aliasKey = new Step.StepKey(phase, NAME, "aliases");
        Step.StepKey isShrunkIndexKey = new Step.StepKey(phase, NAME, "is-shrunken-index");
        Step.StepKey replaceDataStreamIndexKey = new Step.StepKey(phase, NAME, "replace-datastream-backing-index");
        Step.StepKey deleteIndexKey = new Step.StepKey(phase, NAME, "delete");
        BranchingStep conditionalSkipShrinkStep = new BranchingStep(preShrinkBranchingKey, checkNotWriteIndex, nextStepKey, (index, clusterState) -> {
            IndexMetadata indexMetadata = clusterState.getMetadata().index((Index)index);
            if (this.numberOfShards != null && indexMetadata.getNumberOfShards() == this.numberOfShards.intValue()) {
                return true;
            }
            if (indexMetadata.getSettings().get("index.store.snapshot.index_name") != null) {
                logger.warn("[{}] action is configured for index [{}] in policy [{}] which is mounted as searchable snapshot. Skipping this action", (Object)NAME, (Object)indexMetadata.getIndex().getName(), (Object)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings()));
                return true;
            }
            return false;
        });
        CheckNotDataStreamWriteIndexStep checkNotWriteIndexStep = new CheckNotDataStreamWriteIndexStep(checkNotWriteIndex, waitForNoFollowerStepKey);
        WaitForNoFollowersStep waitForNoFollowersStep = new WaitForNoFollowersStep(waitForNoFollowerStepKey, readOnlyKey, client);
        ReadOnlyStep readOnlyStep = new ReadOnlyStep(readOnlyKey, cleanupShrinkIndexKey, client);
        CleanupShrinkIndexStep cleanupShrinkIndexStep = new CleanupShrinkIndexStep(cleanupShrinkIndexKey, generateShrinkIndexNameKey, client);
        GenerateUniqueIndexNameStep generateUniqueIndexNameStep = new GenerateUniqueIndexNameStep(generateShrinkIndexNameKey, setSingleNodeKey, "shrink-", (generatedIndexName, lifecycleStateBuilder) -> lifecycleStateBuilder.setShrinkIndexName((String)generatedIndexName));
        SetSingleNodeAllocateStep setSingleNodeStep = new SetSingleNodeAllocateStep(setSingleNodeKey, allocationRoutedKey, client);
        ClusterStateWaitUntilThresholdStep checkShrinkReadyStep = new ClusterStateWaitUntilThresholdStep(new CheckShrinkReadyStep(allocationRoutedKey, shrinkKey), setSingleNodeKey);
        ShrinkStep shrink = new ShrinkStep(shrinkKey, enoughShardsKey, client, this.numberOfShards, this.maxPrimaryShardSize);
        ClusterStateWaitUntilThresholdStep allocated = new ClusterStateWaitUntilThresholdStep(new ShrunkShardsAllocatedStep(enoughShardsKey, copyMetadataKey), cleanupShrinkIndexKey);
        CopyExecutionStateStep copyMetadata = new CopyExecutionStateStep(copyMetadataKey, dataStreamCheckBranchingKey, ShrinkIndexNameSupplier::getShrinkIndexName, isShrunkIndexKey);
        BranchingStep isDataStreamBranchingStep = new BranchingStep(dataStreamCheckBranchingKey, aliasKey, replaceDataStreamIndexKey, (index, clusterState) -> {
            IndexAbstraction indexAbstraction = (IndexAbstraction)clusterState.metadata().getIndicesLookup().get(index.getName());
            assert (indexAbstraction != null) : "invalid cluster metadata. index [" + index.getName() + "] was not found";
            return indexAbstraction.getParentDataStream() != null;
        });
        ShrinkSetAliasStep aliasSwapAndDelete = new ShrinkSetAliasStep(aliasKey, isShrunkIndexKey, client);
        ReplaceDataStreamBackingIndexStep replaceDataStreamBackingIndex = new ReplaceDataStreamBackingIndexStep(replaceDataStreamIndexKey, deleteIndexKey, ShrinkIndexNameSupplier::getShrinkIndexName);
        DeleteStep deleteSourceIndexStep = new DeleteStep(deleteIndexKey, isShrunkIndexKey, client);
        ShrunkenIndexCheckStep waitOnShrinkTakeover = new ShrunkenIndexCheckStep(isShrunkIndexKey, nextStepKey);
        return Arrays.asList(conditionalSkipShrinkStep, checkNotWriteIndexStep, waitForNoFollowersStep, readOnlyStep, cleanupShrinkIndexStep, generateUniqueIndexNameStep, setSingleNodeStep, checkShrinkReadyStep, shrink, allocated, copyMetadata, isDataStreamBranchingStep, aliasSwapAndDelete, waitOnShrinkTakeover, replaceDataStreamBackingIndex, deleteSourceIndexStep);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShrinkAction that = (ShrinkAction)o;
        return Objects.equals(this.numberOfShards, that.numberOfShards) && Objects.equals(this.maxPrimaryShardSize, that.maxPrimaryShardSize);
    }

    public int hashCode() {
        return Objects.hash(this.numberOfShards, this.maxPrimaryShardSize);
    }

    public String toString() {
        return Strings.toString(this);
    }

    static {
        PARSER.declareInt(ConstructingObjectParser.optionalConstructorArg(), NUMBER_OF_SHARDS_FIELD);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> ByteSizeValue.parseBytesSizeValue(p.text(), MAX_PRIMARY_SHARD_SIZE.getPreferredName()), MAX_PRIMARY_SHARD_SIZE, ObjectParser.ValueType.STRING);
    }
}

