/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.sort;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.fielddata.AbstractBinaryDocValues;
import org.elasticsearch.index.fielddata.FieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.NumericDoubleValues;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.index.fielddata.SortedNumericDoubleValues;
import org.elasticsearch.index.fielddata.fieldcomparator.BytesRefFieldComparatorSource;
import org.elasticsearch.index.fielddata.fieldcomparator.DoubleValuesComparatorSource;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardException;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.script.NumberSortScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.StringSortScript;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.MultiValueMode;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.FieldSortBuilder;
import org.elasticsearch.search.sort.NestedSortBuilder;
import org.elasticsearch.search.sort.SortBuilder;
import org.elasticsearch.search.sort.SortFieldAndFormat;
import org.elasticsearch.search.sort.SortMode;
import org.elasticsearch.search.sort.SortOrder;

public class ScriptSortBuilder
extends SortBuilder<ScriptSortBuilder> {
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(ScriptSortBuilder.class);
    public static final String NAME = "_script";
    public static final ParseField TYPE_FIELD = new ParseField("type", new String[0]);
    public static final ParseField SCRIPT_FIELD = new ParseField("script", new String[0]);
    public static final ParseField SORTMODE_FIELD = new ParseField("mode", new String[0]);
    private final Script script;
    private final ScriptSortType type;
    private SortMode sortMode;
    private QueryBuilder nestedFilter;
    private String nestedPath;
    private NestedSortBuilder nestedSort;
    private static final ConstructingObjectParser<ScriptSortBuilder, Void> PARSER = new ConstructingObjectParser("_script", a -> new ScriptSortBuilder((Script)a[0], (ScriptSortType)a[1]));

    public ScriptSortBuilder(Script script, ScriptSortType type) {
        Objects.requireNonNull(script, "script cannot be null");
        Objects.requireNonNull(type, "type cannot be null");
        this.script = script;
        this.type = type;
    }

    ScriptSortBuilder(ScriptSortBuilder original) {
        this.script = original.script;
        this.type = original.type;
        this.order = original.order;
        this.sortMode = original.sortMode;
        this.nestedFilter = original.nestedFilter;
        this.nestedPath = original.nestedPath;
        this.nestedSort = original.nestedSort;
    }

    public ScriptSortBuilder(StreamInput in) throws IOException {
        this.script = new Script(in);
        this.type = ScriptSortType.readFromStream(in);
        this.order = SortOrder.readFromStream(in);
        this.sortMode = in.readOptionalWriteable(SortMode::readFromStream);
        this.nestedPath = in.readOptionalString();
        this.nestedFilter = in.readOptionalNamedWriteable(QueryBuilder.class);
        if (in.getVersion().onOrAfter(Version.V_6_1_0)) {
            this.nestedSort = in.readOptionalWriteable(NestedSortBuilder::new);
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.script.writeTo(out);
        this.type.writeTo(out);
        this.order.writeTo(out);
        out.writeOptionalWriteable(this.sortMode);
        out.writeOptionalString(this.nestedPath);
        out.writeOptionalNamedWriteable(this.nestedFilter);
        if (out.getVersion().onOrAfter(Version.V_6_1_0)) {
            out.writeOptionalWriteable(this.nestedSort);
        }
    }

    public Script script() {
        return this.script;
    }

    public ScriptSortType type() {
        return this.type;
    }

    public ScriptSortBuilder sortMode(SortMode sortMode) {
        Objects.requireNonNull(sortMode, "sort mode cannot be null.");
        if (ScriptSortType.STRING.equals(this.type) && (sortMode == SortMode.SUM || sortMode == SortMode.AVG || sortMode == SortMode.MEDIAN)) {
            throw new IllegalArgumentException("script sort of type [string] doesn't support mode [" + sortMode + "]");
        }
        this.sortMode = sortMode;
        return this;
    }

    public SortMode sortMode() {
        return this.sortMode;
    }

    @Deprecated
    public ScriptSortBuilder setNestedFilter(QueryBuilder nestedFilter) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedFilter = nestedFilter;
        return this;
    }

    @Deprecated
    public QueryBuilder getNestedFilter() {
        return this.nestedFilter;
    }

    @Deprecated
    public ScriptSortBuilder setNestedPath(String nestedPath) {
        if (this.nestedSort != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedPath = nestedPath;
        return this;
    }

    @Deprecated
    public String getNestedPath() {
        return this.nestedPath;
    }

    public NestedSortBuilder getNestedSort() {
        return this.nestedSort;
    }

    public ScriptSortBuilder setNestedSort(NestedSortBuilder nestedSort) {
        if (this.nestedFilter != null || this.nestedPath != null) {
            throw new IllegalArgumentException("Setting both nested_path/nested_filter and nested not allowed");
        }
        this.nestedSort = nestedSort;
        return this;
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params builderParams) throws IOException {
        builder.startObject();
        builder.startObject(NAME);
        builder.field(SCRIPT_FIELD.getPreferredName(), this.script);
        builder.field(TYPE_FIELD.getPreferredName(), this.type);
        builder.field(ORDER_FIELD.getPreferredName(), this.order);
        if (this.sortMode != null) {
            builder.field(SORTMODE_FIELD.getPreferredName(), this.sortMode);
        }
        if (this.nestedPath != null) {
            builder.field(NESTED_PATH_FIELD.getPreferredName(), this.nestedPath);
        }
        if (this.nestedFilter != null) {
            builder.field(NESTED_FILTER_FIELD.getPreferredName(), this.nestedFilter, builderParams);
        }
        if (this.nestedSort != null) {
            builder.field(NestedSortBuilder.NESTED_FIELD.getPreferredName(), this.nestedSort);
        }
        builder.endObject();
        builder.endObject();
        return builder;
    }

    public static ScriptSortBuilder fromXContent(XContentParser parser, String elementName) {
        return PARSER.apply(parser, null);
    }

    @Override
    public SortFieldAndFormat build(SearchExecutionContext context) throws IOException {
        return new SortFieldAndFormat(new SortField(NAME, this.fieldComparatorSource(context), this.order == SortOrder.DESC), DocValueFormat.RAW);
    }

    @Override
    public BucketedSort buildBucketedSort(SearchExecutionContext context, BigArrays bigArrays, int bucketSize, BucketedSort.ExtraData extra) throws IOException {
        return this.fieldComparatorSource(context).newBucketedSort(bigArrays, this.order, DocValueFormat.RAW, bucketSize, extra);
    }

    private IndexFieldData.XFieldComparatorSource fieldComparatorSource(SearchExecutionContext context) throws IOException {
        IndexFieldData.XFieldComparatorSource.Nested nested;
        MultiValueMode valueMode = null;
        if (this.sortMode != null) {
            valueMode = MultiValueMode.fromString(this.sortMode.toString());
        }
        if (valueMode == null) {
            MultiValueMode multiValueMode = valueMode = this.order == SortOrder.DESC ? MultiValueMode.MAX : MultiValueMode.MIN;
        }
        if (this.nestedSort != null) {
            if (context.indexVersionCreated().before(Version.V_6_5_0) && this.nestedSort.getMaxChildren() != Integer.MAX_VALUE) {
                throw new QueryShardException(context, "max_children is only supported on v6.5.0 or higher", new Object[0]);
            }
            FieldSortBuilder.validateMaxChildrenExistOnlyInTopLevelNestedSort(context, this.nestedSort);
            nested = ScriptSortBuilder.resolveNested(context, this.nestedSort);
        } else {
            nested = ScriptSortBuilder.resolveNested(context, this.nestedPath, this.nestedFilter);
        }
        switch (this.type) {
            case STRING: {
                StringSortScript.Factory factory = context.compile(this.script, StringSortScript.CONTEXT);
                final StringSortScript.LeafFactory searchScript = factory.newFactory(this.script.getParams(), context.lookup());
                return new BytesRefFieldComparatorSource(null, null, valueMode, nested){
                    StringSortScript leafScript;

                    @Override
                    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
                        this.leafScript = searchScript.newInstance(context);
                        AbstractBinaryDocValues values = new AbstractBinaryDocValues(){
                            final BytesRefBuilder spare = new BytesRefBuilder();

                            @Override
                            public boolean advanceExact(int doc) throws IOException {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            @Override
                            public BytesRef binaryValue() {
                                this.spare.copyChars(leafScript.execute());
                                return this.spare.get();
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(Scorable scorer) {
                        this.leafScript.setScorer(scorer);
                    }

                    @Override
                    public BucketedSort newBucketedSort(BigArrays bigArrays, SortOrder sortOrder, DocValueFormat format, int bucketSize, BucketedSort.ExtraData extra) {
                        throw new IllegalArgumentException("error building sort for [_script]: script sorting only supported on [numeric] scripts but was [" + ScriptSortBuilder.this.type + "]");
                    }
                };
            }
            case NUMBER: {
                NumberSortScript.Factory numberSortFactory = context.compile(this.script, NumberSortScript.CONTEXT);
                final NumberSortScript.LeafFactory numberSortScript = numberSortFactory.newFactory(this.script.getParams(), context.lookup());
                return new DoubleValuesComparatorSource(null, Double.MAX_VALUE, valueMode, nested){
                    NumberSortScript leafScript;

                    @Override
                    protected SortedNumericDoubleValues getValues(LeafReaderContext context) throws IOException {
                        this.leafScript = numberSortScript.newInstance(context);
                        NumericDoubleValues values = new NumericDoubleValues(){

                            @Override
                            public boolean advanceExact(int doc) throws IOException {
                                leafScript.setDocument(doc);
                                return true;
                            }

                            @Override
                            public double doubleValue() {
                                return leafScript.execute();
                            }
                        };
                        return FieldData.singleton(values);
                    }

                    @Override
                    protected void setScorer(Scorable scorer) {
                        this.leafScript.setScorer(scorer);
                    }
                };
            }
        }
        throw new QueryShardException(context, "custom script sort type [" + this.type + "] not supported", new Object[0]);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ScriptSortBuilder other = (ScriptSortBuilder)object;
        return Objects.equals(this.script, other.script) && Objects.equals(this.type, other.type) && Objects.equals(this.order, other.order) && Objects.equals(this.sortMode, other.sortMode) && Objects.equals(this.nestedFilter, other.nestedFilter) && Objects.equals(this.nestedPath, other.nestedPath) && Objects.equals(this.nestedSort, other.nestedSort);
    }

    public int hashCode() {
        return Objects.hash(this.script, this.type, this.order, this.sortMode, this.nestedFilter, this.nestedPath, this.nestedSort);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public ScriptSortBuilder rewrite(QueryRewriteContext ctx) throws IOException {
        if (this.nestedFilter == null && this.nestedSort == null) {
            return this;
        }
        if (this.nestedFilter != null) {
            QueryBuilder rewrite = this.nestedFilter.rewrite(ctx);
            if (this.nestedFilter == rewrite) {
                return this;
            }
            return new ScriptSortBuilder(this).setNestedFilter(rewrite);
        }
        NestedSortBuilder rewrite = this.nestedSort.rewrite(ctx);
        if (this.nestedSort == rewrite) {
            return this;
        }
        return new ScriptSortBuilder(this).setNestedSort(rewrite);
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, context) -> Script.parse(parser), Script.SCRIPT_PARSE_FIELD, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.constructorArg(), p -> ScriptSortType.fromString(p.text()), TYPE_FIELD, ObjectParser.ValueType.STRING);
        PARSER.declareString((b, v) -> b.order(SortOrder.fromString(v)), ORDER_FIELD);
        PARSER.declareString((b, v) -> b.sortMode(SortMode.fromString(v)), SORTMODE_FIELD);
        PARSER.declareString((fieldSortBuilder, nestedPath) -> {
            deprecationLogger.deprecate(DeprecationCategory.API, "script_nested_path", "[nested_path] has been deprecated in favor of the [nested] parameter", new Object[0]);
            fieldSortBuilder.setNestedPath((String)nestedPath);
        }, NESTED_PATH_FIELD);
        PARSER.declareObject(ScriptSortBuilder::setNestedFilter, (p, c) -> {
            deprecationLogger.deprecate(DeprecationCategory.API, "script_nested_filter", "[nested_filter] has been deprecated in favour for the [nested] parameter", new Object[0]);
            return SortBuilder.parseNestedFilter(p);
        }, NESTED_FILTER_FIELD);
        PARSER.declareObject(ScriptSortBuilder::setNestedSort, (p, c) -> NestedSortBuilder.fromXContent(p), NestedSortBuilder.NESTED_FIELD);
    }

    public static enum ScriptSortType implements Writeable
    {
        STRING,
        NUMBER;


        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeEnum(this);
        }

        static ScriptSortType readFromStream(StreamInput in) throws IOException {
            return in.readEnum(ScriptSortType.class);
        }

        public static ScriptSortType fromString(String str) {
            Objects.requireNonNull(str, "input string is null");
            switch (str.toLowerCase(Locale.ROOT)) {
                case "string": {
                    return STRING;
                }
                case "number": {
                    return NUMBER;
                }
            }
            throw new IllegalArgumentException("Unknown ScriptSortType [" + str + "]");
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

