/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.metrics;

import java.io.IOException;
import org.elasticsearch.common.geo.GeoBoundingBox;
import org.elasticsearch.common.geo.GeoPoint;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.search.aggregations.ParsedAggregation;
import org.elasticsearch.search.aggregations.metrics.GeoBounds;

public class ParsedGeoBounds
extends ParsedAggregation
implements GeoBounds {
    @Nullable
    private GeoBoundingBox geoBoundingBox;
    private static final ObjectParser<ParsedGeoBounds, Void> PARSER = new ObjectParser(ParsedGeoBounds.class.getSimpleName(), true, ParsedGeoBounds::new);
    private static final ConstructingObjectParser<Tuple<GeoPoint, GeoPoint>, Void> BOUNDS_PARSER = new ConstructingObjectParser(ParsedGeoBounds.class.getSimpleName() + "_BOUNDS", true, args -> new Tuple<GeoPoint, GeoPoint>((GeoPoint)args[0], (GeoPoint)args[1]));
    private static final ObjectParser<GeoPoint, Void> GEO_POINT_PARSER = new ObjectParser(ParsedGeoBounds.class.getSimpleName() + "_POINT", true, GeoPoint::new);

    @Override
    public String getType() {
        return "geo_bounds";
    }

    @Override
    public XContentBuilder doXContentBody(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.geoBoundingBox != null) {
            builder.startObject(GeoBoundingBox.BOUNDS_FIELD.getPreferredName());
            this.geoBoundingBox.toXContentFragment(builder, true);
            builder.endObject();
        }
        return builder;
    }

    @Override
    @Nullable
    public GeoPoint topLeft() {
        return this.geoBoundingBox != null ? this.geoBoundingBox.topLeft() : null;
    }

    @Override
    @Nullable
    public GeoPoint bottomRight() {
        return this.geoBoundingBox != null ? this.geoBoundingBox.bottomRight() : null;
    }

    public static ParsedGeoBounds fromXContent(XContentParser parser, String name) {
        ParsedGeoBounds geoBounds = PARSER.apply(parser, null);
        geoBounds.setName(name);
        return geoBounds;
    }

    static {
        ParsedGeoBounds.declareAggregationFields(PARSER);
        PARSER.declareObject((agg, bbox) -> {
            agg.geoBoundingBox = new GeoBoundingBox((GeoPoint)bbox.v1(), (GeoPoint)bbox.v2());
        }, BOUNDS_PARSER, GeoBoundingBox.BOUNDS_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), GEO_POINT_PARSER, GeoBoundingBox.TOP_LEFT_FIELD);
        BOUNDS_PARSER.declareObject(ConstructingObjectParser.constructorArg(), GEO_POINT_PARSER, GeoBoundingBox.BOTTOM_RIGHT_FIELD);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLat, GeoBoundingBox.LAT_FIELD);
        GEO_POINT_PARSER.declareDouble(GeoPoint::resetLon, GeoBoundingBox.LON_FIELD);
    }
}

