/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.terms;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.LongPredicate;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.PriorityQueue;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.index.query.TermQueryBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AdaptingAggregator;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.BucketOrder;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalOrder;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.filter.FilterByFilterAggregator;
import org.elasticsearch.search.aggregations.bucket.filter.InternalFilters;
import org.elasticsearch.search.aggregations.bucket.terms.GlobalOrdinalsStringTermsAggregator;
import org.elasticsearch.search.aggregations.bucket.terms.StringTerms;
import org.elasticsearch.search.aggregations.bucket.terms.TermsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;

public class StringTermsAggregatorFromFilters
extends AdaptingAggregator {
    private final boolean showTermDocCountError;
    private final DocValueFormat format;
    private final BucketOrder order;
    private final TermsAggregator.BucketCountThresholds bucketCountThresholds;
    private final TermsEnum terms;

    static StringTermsAggregatorFromFilters adaptIntoFiltersOrNull(String name, final AggregatorFactories factories, AggregationContext context, final Aggregator parent, final boolean showTermDocCountError, CardinalityUpperBound cardinality, Map<String, Object> metadata, final ValuesSourceConfig valuesSourceConfig, final BucketOrder order, final TermsAggregator.BucketCountThresholds bucketCountThresholds, LongPredicate acceptedOrds, SortedSetDocValues values) throws IOException {
        if (!valuesSourceConfig.alignesWithSearchIndex()) {
            return null;
        }
        final TermsEnum terms = values.termsEnum();
        FilterByFilterAggregator.AdapterBuilder<StringTermsAggregatorFromFilters> filterByFilterBuilder = new FilterByFilterAggregator.AdapterBuilder<StringTermsAggregatorFromFilters>(name, false, null, context, parent, cardinality, metadata){

            @Override
            protected StringTermsAggregatorFromFilters adapt(CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> delegate) throws IOException {
                return new StringTermsAggregatorFromFilters(parent, factories, delegate, showTermDocCountError, valuesSourceConfig.format(), order, bucketCountThresholds, terms);
            }
        };
        String field = valuesSourceConfig.fieldContext().field();
        for (long ord = 0L; ord < values.getValueCount(); ++ord) {
            if (!acceptedOrds.test(ord)) continue;
            terms.seekExact(ord);
            TermQueryBuilder builder = new TermQueryBuilder(field, valuesSourceConfig.format().format(terms.term()));
            filterByFilterBuilder.add(Long.toString(ord), context.buildQuery(builder));
        }
        return (StringTermsAggregatorFromFilters)filterByFilterBuilder.build();
    }

    public StringTermsAggregatorFromFilters(Aggregator parent, AggregatorFactories subAggregators, CheckedFunction<AggregatorFactories, FilterByFilterAggregator, IOException> delegate, boolean showTermDocCountError, DocValueFormat format, BucketOrder order, TermsAggregator.BucketCountThresholds bucketCountThresholds, TermsEnum terms) throws IOException {
        super(parent, subAggregators, delegate);
        this.showTermDocCountError = showTermDocCountError;
        this.format = format;
        this.order = order;
        this.bucketCountThresholds = bucketCountThresholds;
        this.terms = terms;
    }

    @Override
    protected InternalAggregation adapt(InternalAggregation delegateResult) throws IOException {
        ArrayList<StringTerms.Bucket> buckets;
        InternalFilters filters = (InternalFilters)delegateResult;
        long otherDocsCount = 0L;
        BucketOrder reduceOrder = InternalOrder.isKeyOrder(this.order) ? this.order : InternalOrder.key(true);
        long minDocCount = this.bucketCountThresholds.getShardMinDocCount();
        if (minDocCount == 0L && this.bucketCountThresholds.getMinDocCount() > 0L) {
            minDocCount = 1L;
        }
        if (filters.getBuckets().size() > this.bucketCountThresholds.getShardSize()) {
            PriorityQueue<GlobalOrdinalsStringTermsAggregator.OrdBucket> queue = new PriorityQueue<GlobalOrdinalsStringTermsAggregator.OrdBucket>(this.bucketCountThresholds.getShardSize()){
                private final Comparator<MultiBucketsAggregation.Bucket> comparator;
                {
                    this.comparator = StringTermsAggregatorFromFilters.this.order.comparator();
                }

                @Override
                protected boolean lessThan(GlobalOrdinalsStringTermsAggregator.OrdBucket a, GlobalOrdinalsStringTermsAggregator.OrdBucket b) {
                    return this.comparator.compare(a, b) > 0;
                }
            };
            GlobalOrdinalsStringTermsAggregator.OrdBucket spare = null;
            for (InternalFilters.InternalBucket internalBucket : filters.getBuckets()) {
                if (internalBucket.getDocCount() < minDocCount) continue;
                if (spare == null) {
                    spare = new GlobalOrdinalsStringTermsAggregator.OrdBucket(this.showTermDocCountError, this.format);
                } else {
                    otherDocsCount += spare.docCount;
                }
                spare.globalOrd = Long.parseLong(internalBucket.getKey());
                spare.docCount = internalBucket.getDocCount();
                spare.aggregations = internalBucket.getAggregations();
                spare = queue.insertWithOverflow(spare);
            }
            if (spare != null) {
                otherDocsCount += spare.docCount;
            }
            buckets = new ArrayList(queue.size());
            if (!InternalOrder.isKeyOrder(this.order)) {
                for (GlobalOrdinalsStringTermsAggregator.OrdBucket ordBucket : queue) {
                    buckets.add(this.buildBucket(ordBucket));
                }
                Collections.sort(buckets, reduceOrder.comparator());
            } else {
                while (queue.size() > 0) {
                    buckets.add(this.buildBucket((GlobalOrdinalsStringTermsAggregator.OrdBucket)queue.pop()));
                }
                Collections.reverse(buckets);
            }
        } else {
            buckets = new ArrayList<StringTerms.Bucket>(filters.getBuckets().size());
            for (InternalFilters.InternalBucket b : filters.getBuckets()) {
                if (b.getDocCount() < minDocCount) continue;
                buckets.add(this.buildBucket(b));
            }
            Collections.sort(buckets, reduceOrder.comparator());
        }
        return new StringTerms(filters.getName(), reduceOrder, this.order, this.bucketCountThresholds.getRequiredSize(), this.bucketCountThresholds.getMinDocCount(), filters.getMetadata(), this.format, this.bucketCountThresholds.getShardSize(), this.showTermDocCountError, otherDocsCount, (List<StringTerms.Bucket>)buckets, 0L);
    }

    private StringTerms.Bucket buildBucket(GlobalOrdinalsStringTermsAggregator.OrdBucket b) throws IOException {
        this.terms.seekExact(b.globalOrd);
        return new StringTerms.Bucket(BytesRef.deepCopyOf(this.terms.term()), b.getDocCount(), b.aggregations, this.showTermDocCountError, 0L, this.format);
    }

    private StringTerms.Bucket buildBucket(InternalFilters.InternalBucket b) throws IOException {
        this.terms.seekExact(Long.parseLong(b.getKey()));
        return new StringTerms.Bucket(BytesRef.deepCopyOf(this.terms.term()), b.getDocCount(), b.getAggregations(), this.showTermDocCountError, 0L, this.format);
    }
}

