/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.nested;

import com.carrotsearch.hppc.LongArrayList;
import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.ReaderUtil;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorable;
import org.apache.lucene.search.ScoreMode;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.join.BitSetProducer;
import org.apache.lucene.util.BitSet;
import org.elasticsearch.common.lucene.search.Queries;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.CardinalityUpperBound;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.LeafBucketCollectorBase;
import org.elasticsearch.search.aggregations.bucket.BucketsAggregator;
import org.elasticsearch.search.aggregations.bucket.SingleBucketAggregator;
import org.elasticsearch.search.aggregations.bucket.nested.InternalNested;
import org.elasticsearch.search.aggregations.support.AggregationContext;

public class NestedAggregator
extends BucketsAggregator
implements SingleBucketAggregator {
    static final ParseField PATH_FIELD = new ParseField("path", new String[0]);
    private final BitSetProducer parentFilter;
    private final Query childFilter;
    private final boolean collectsFromSingleBucket;
    private BufferingNestedLeafBucketCollector bufferingNestedLeafBucketCollector;

    NestedAggregator(String name, AggregatorFactories factories, ObjectMapper parentObjectMapper, ObjectMapper childObjectMapper, AggregationContext context, Aggregator parent, CardinalityUpperBound cardinality, Map<String, Object> metadata) throws IOException {
        super(name, factories, context, parent, cardinality, metadata);
        Query parentFilter = parentObjectMapper != null ? parentObjectMapper.nestedTypeFilter() : Queries.newNonNestedFilter(context.indexVersionCreated());
        this.parentFilter = context.bitsetFilterCache().getBitSetProducer(parentFilter);
        this.childFilter = childObjectMapper.nestedTypeFilter();
        this.collectsFromSingleBucket = cardinality.map(estimate -> estimate < 2);
    }

    @Override
    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, final LeafBucketCollector sub) throws IOException {
        DocIdSetIterator childDocs;
        IndexReaderContext topLevelContext = ReaderUtil.getTopLevelContext(ctx);
        IndexSearcher searcher = new IndexSearcher(topLevelContext);
        searcher.setQueryCache(null);
        Weight weight = searcher.createWeight(searcher.rewrite(this.childFilter), ScoreMode.COMPLETE_NO_SCORES, 1.0f);
        Scorer childDocsScorer = weight.scorer(ctx);
        final BitSet parentDocs = this.parentFilter.getBitSet(ctx);
        DocIdSetIterator docIdSetIterator = childDocs = childDocsScorer != null ? childDocsScorer.iterator() : null;
        if (this.collectsFromSingleBucket) {
            return new LeafBucketCollectorBase(sub, null){

                @Override
                public void collect(int parentDoc, long bucket) throws IOException {
                    if (parentDoc == 0 || parentDocs == null || childDocs == null) {
                        return;
                    }
                    int prevParentDoc = parentDocs.prevSetBit(parentDoc - 1);
                    int childDocId = childDocs.docID();
                    if (childDocId <= prevParentDoc) {
                        childDocId = childDocs.advance(prevParentDoc + 1);
                    }
                    while (childDocId < parentDoc) {
                        NestedAggregator.this.collectBucket(sub, childDocId, bucket);
                        childDocId = childDocs.nextDoc();
                    }
                }
            };
        }
        this.bufferingNestedLeafBucketCollector = new BufferingNestedLeafBucketCollector(sub, parentDocs, childDocs);
        return this.bufferingNestedLeafBucketCollector;
    }

    @Override
    protected void preGetSubLeafCollectors(LeafReaderContext ctx) throws IOException {
        super.preGetSubLeafCollectors(ctx);
        this.processBufferedDocs();
    }

    @Override
    protected void doPostCollection() throws IOException {
        this.processBufferedDocs();
    }

    private void processBufferedDocs() throws IOException {
        if (this.bufferingNestedLeafBucketCollector != null) {
            this.bufferingNestedLeafBucketCollector.processBufferedChildBuckets();
        }
    }

    @Override
    public InternalAggregation[] buildAggregations(long[] owningBucketOrds) throws IOException {
        return this.buildAggregationsForSingleBucket(owningBucketOrds, (owningBucketOrd, subAggregationResults) -> new InternalNested(this.name, this.bucketDocCount(owningBucketOrd), subAggregationResults, this.metadata()));
    }

    @Override
    public InternalAggregation buildEmptyAggregation() {
        return new InternalNested(this.name, 0L, this.buildEmptySubAggregations(), this.metadata());
    }

    class BufferingNestedLeafBucketCollector
    extends LeafBucketCollectorBase {
        final BitSet parentDocs;
        final LeafBucketCollector sub;
        final DocIdSetIterator childDocs;
        final LongArrayList bucketBuffer;
        Scorable scorer;
        int currentParentDoc;
        final CachedScorable cachedScorer;

        BufferingNestedLeafBucketCollector(LeafBucketCollector sub, BitSet parentDocs, DocIdSetIterator childDocs) {
            super(sub, null);
            this.bucketBuffer = new LongArrayList();
            this.currentParentDoc = -1;
            this.cachedScorer = new CachedScorable();
            this.sub = sub;
            this.parentDocs = parentDocs;
            this.childDocs = childDocs;
        }

        @Override
        public void setScorer(Scorable scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(this.cachedScorer);
        }

        @Override
        public void collect(int parentDoc, long bucket) throws IOException {
            if (parentDoc == 0 || this.parentDocs == null || this.childDocs == null) {
                return;
            }
            if (this.currentParentDoc != parentDoc) {
                this.processBufferedChildBuckets();
                if (NestedAggregator.this.scoreMode().needsScores()) {
                    this.cachedScorer.score = this.scorer.score();
                }
                this.currentParentDoc = parentDoc;
            }
            this.bucketBuffer.add(bucket);
        }

        void processBufferedChildBuckets() throws IOException {
            if (this.bucketBuffer.isEmpty()) {
                return;
            }
            int prevParentDoc = this.parentDocs.prevSetBit(this.currentParentDoc - 1);
            int childDocId = this.childDocs.docID();
            if (childDocId <= prevParentDoc) {
                childDocId = this.childDocs.advance(prevParentDoc + 1);
            }
            while (childDocId < this.currentParentDoc) {
                this.cachedScorer.doc = childDocId;
                long[] buffer = this.bucketBuffer.buffer;
                int size = this.bucketBuffer.size();
                for (int i = 0; i < size; ++i) {
                    NestedAggregator.this.collectBucket(this.sub, childDocId, buffer[i]);
                }
                childDocId = this.childDocs.nextDoc();
            }
            this.bucketBuffer.clear();
        }
    }

    private static class CachedScorable
    extends Scorable {
        int doc;
        float score;

        private CachedScorable() {
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public int docID() {
            return this.doc;
        }
    }
}

