/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.bucket.histogram;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.ParsedMultiBucketAggregation;
import org.elasticsearch.search.aggregations.bucket.histogram.Histogram;

public class ParsedHistogram
extends ParsedMultiBucketAggregation<ParsedBucket>
implements Histogram {
    private static final ObjectParser<ParsedHistogram, Void> PARSER = new ObjectParser(ParsedHistogram.class.getSimpleName(), true, ParsedHistogram::new);

    @Override
    public String getType() {
        return "histogram";
    }

    @Override
    public List<? extends Histogram.Bucket> getBuckets() {
        return this.buckets;
    }

    public static ParsedHistogram fromXContent(XContentParser parser, String name) throws IOException {
        ParsedHistogram aggregation = PARSER.parse(parser, null);
        aggregation.setName(name);
        return aggregation;
    }

    static {
        ParsedHistogram.declareMultiBucketAggregationFields(PARSER, parser -> ParsedBucket.fromXContent(parser, false), parser -> ParsedBucket.fromXContent(parser, true));
    }

    static class ParsedBucket
    extends ParsedMultiBucketAggregation.ParsedBucket
    implements Histogram.Bucket {
        private Double key;

        ParsedBucket() {
        }

        @Override
        public Object getKey() {
            return this.key;
        }

        @Override
        public String getKeyAsString() {
            String keyAsString = super.getKeyAsString();
            if (keyAsString != null) {
                return keyAsString;
            }
            if (this.key != null) {
                return Double.toString(this.key);
            }
            return null;
        }

        static ParsedBucket fromXContent(XContentParser parser, boolean keyed) throws IOException {
            return ParsedBucket.parseXContent(parser, keyed, ParsedBucket::new, (p, bucket) -> {
                bucket.key = p.doubleValue();
            });
        }
    }
}

