/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.search;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.TextSearchInfo;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.search.SearchModule;

public final class QueryParserHelper {
    private QueryParserHelper() {
    }

    public static Map<String, Float> parseFieldsAndWeights(List<String> fields) {
        HashMap<String, Float> fieldsAndWeights = new HashMap<String, Float>();
        for (String field : fields) {
            String fieldName;
            int boostIndex = field.indexOf(94);
            float boost = 1.0f;
            if (boostIndex != -1) {
                fieldName = field.substring(0, boostIndex);
                boost = Float.parseFloat(field.substring(boostIndex + 1));
            } else {
                fieldName = field;
            }
            if (fieldsAndWeights.containsKey(field)) {
                boost *= ((Float)fieldsAndWeights.get(field)).floatValue();
            }
            fieldsAndWeights.put(fieldName, Float.valueOf(boost));
        }
        return fieldsAndWeights;
    }

    public static Map<String, Float> resolveMappingFields(SearchExecutionContext context, Map<String, Float> fieldsAndWeights) {
        return QueryParserHelper.resolveMappingFields(context, fieldsAndWeights, null);
    }

    static Map<String, Float> resolveMappingFields(SearchExecutionContext context, Map<String, Float> fieldsAndWeights, String fieldSuffix) {
        HashMap<String, Float> resolvedFields = new HashMap<String, Float>();
        for (Map.Entry<String, Float> fieldEntry : fieldsAndWeights.entrySet()) {
            boolean allField = Regex.isMatchAllPattern(fieldEntry.getKey());
            boolean multiField = Regex.isSimpleMatchPattern(fieldEntry.getKey());
            float weight = fieldEntry.getValue() == null ? 1.0f : fieldEntry.getValue().floatValue();
            Map<String, Float> fieldMap = QueryParserHelper.resolveMappingField(context, fieldEntry.getKey(), weight, !multiField, !allField, fieldSuffix);
            for (Map.Entry<String, Float> field : fieldMap.entrySet()) {
                float boost = field.getValue().floatValue();
                if (resolvedFields.containsKey(field.getKey())) {
                    boost *= ((Float)resolvedFields.get(field.getKey())).floatValue();
                }
                resolvedFields.put(field.getKey(), Float.valueOf(boost));
            }
        }
        QueryParserHelper.checkForTooManyFields(resolvedFields.size(), context, null);
        return resolvedFields;
    }

    static Map<String, Float> resolveMappingField(SearchExecutionContext context, String fieldOrPattern, float weight, boolean acceptAllTypes, boolean acceptMetadataField, String fieldSuffix) {
        Set<String> allFields = context.getMatchingFieldNames(fieldOrPattern);
        HashMap<String, Float> fields = new HashMap<String, Float>();
        for (String fieldName : allFields) {
            if (fieldSuffix != null && context.isFieldMapped(fieldName + fieldSuffix)) {
                fieldName = fieldName + fieldSuffix;
            }
            MappedFieldType fieldType = context.getFieldType(fieldName);
            if (!acceptMetadataField && fieldType.name().startsWith("_") || !acceptAllTypes && fieldType.getTextSearchInfo() == TextSearchInfo.NONE) continue;
            String resolvedFieldName = fieldType.name();
            if (allFields.contains(resolvedFieldName)) {
                fieldName = resolvedFieldName;
            }
            float w = fields.getOrDefault(fieldName, Float.valueOf(1.0f)).floatValue();
            fields.put(fieldName, Float.valueOf(w * weight));
        }
        return fields;
    }

    static void checkForTooManyFields(int numberOfFields, SearchExecutionContext context, @Nullable String inputPattern) {
        Integer limit = SearchModule.INDICES_MAX_CLAUSE_COUNT_SETTING.get(context.getIndexSettings().getSettings());
        if (numberOfFields > limit) {
            StringBuilder errorMsg = new StringBuilder("field expansion ");
            if (inputPattern != null) {
                errorMsg.append("for [" + inputPattern + "] ");
            }
            errorMsg.append("matches too many fields, limit: " + limit + ", got: " + numberOfFields);
            throw new IllegalArgumentException(errorMsg.toString());
        }
    }

    public static boolean hasAllFieldsWildcard(Collection<String> fields) {
        return fields.stream().anyMatch(Regex::isMatchAllPattern);
    }
}

