/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.admin.indices.upgrade.post.UpgradeSettingsClusterStateUpdateRequest;
import org.elasticsearch.action.support.ContextPreservingActionListener;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;
import org.elasticsearch.threadpool.ThreadPool;

public class MetadataUpdateSettingsService {
    private static final Logger logger = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;
    private final ThreadPool threadPool;

    @Inject
    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator, ThreadPool threadPool) {
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
    }

    public void updateSettings(final UpdateSettingsClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        final Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings.filter(s -> !Regex.isSimpleMatchPattern(s)), false, true);
        for (String key : normalizedSettings.keySet()) {
            boolean isWildcard;
            Setting<?> setting = this.indexScopedSettings.get(key);
            boolean bl = isWildcard = setting == null && Regex.isSimpleMatchPattern(key);
            assert (setting != null || isWildcard && !normalizedSettings.hasValue(key)) : "unknown setting: " + key + " isWildcard: " + isWildcard + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (isWildcard || setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key);
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        final boolean preserveExisting = request.isPreserveExisting();
        this.clusterService.submitStateUpdateTask("update-settings " + Arrays.toString(request.indices()), new AckedClusterStateUpdateTask(Priority.URGENT, request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            public ClusterState execute(ClusterState currentState) {
                Settings finalSettings;
                Settings.Builder indexSettings;
                Settings.Builder updates;
                IndexMetadata indexMetadata;
                RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                HashSet<Index> openIndices = new HashSet<Index>();
                HashSet<Index> closeIndices = new HashSet<Index>();
                String[] actualIndices = new String[request.indices().length];
                for (int i = 0; i < request.indices().length; ++i) {
                    Index index = request.indices()[i];
                    actualIndices[i] = index.getName();
                    IndexMetadata metadata = currentState.metadata().getIndexSafe(index);
                    if (metadata.getState() == IndexMetadata.State.OPEN) {
                        openIndices.add(index);
                        continue;
                    }
                    closeIndices.add(index);
                }
                if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
                    throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
                }
                if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
                    int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
                    if (!preserveExisting) {
                        MetadataUpdateSettingsService.this.shardLimitValidator.validateShardLimitOnReplicaUpdate(currentState, request.indices(), updatedNumberOfReplicas);
                        routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, actualIndices);
                        logger.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, (Object)actualIndices);
                    }
                }
                if (!openIndices.isEmpty()) {
                    for (Index index : openIndices) {
                        indexMetadata = metadataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetadata.getSettings());
                        if (!MetadataUpdateSettingsService.this.indexScopedSettings.updateDynamicSettings(openSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                            indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = indexSettings.build();
                        MetadataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetadataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (!closeIndices.isEmpty()) {
                    for (Index index : closeIndices) {
                        indexMetadata = metadataBuilder.getSafe(index);
                        updates = Settings.builder();
                        indexSettings = Settings.builder().put(indexMetadata.getSettings());
                        if (!MetadataUpdateSettingsService.this.indexScopedSettings.updateSettings(closedSettings, indexSettings, updates, index.getName())) continue;
                        if (preserveExisting) {
                            indexSettings.put(indexMetadata.getSettings());
                        }
                        if (!IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(indexSettings)) {
                            indexSettings.put("index.number_of_replicas", IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(Settings.EMPTY));
                        }
                        finalSettings = indexSettings.build();
                        MetadataUpdateSettingsService.this.indexScopedSettings.validate(finalSettings.filter(k -> !MetadataUpdateSettingsService.this.indexScopedSettings.isPrivateSetting((String)k)), true);
                        metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings));
                    }
                }
                if (IndexSettings.INDEX_TRANSLOG_RETENTION_AGE_SETTING.exists(normalizedSettings) || IndexSettings.INDEX_TRANSLOG_RETENTION_SIZE_SETTING.exists(normalizedSettings)) {
                    for (String index : actualIndices) {
                        MetadataCreateIndexService.validateTranslogRetentionSettings(metadataBuilder.get(index).getSettings());
                    }
                }
                boolean changed = false;
                for (String index : actualIndices) {
                    if (IndexSettings.same(currentState.metadata().index(index).getSettings(), metadataBuilder.get(index).getSettings())) continue;
                    changed = true;
                    IndexMetadata.Builder builder = IndexMetadata.builder(metadataBuilder.get(index));
                    builder.settingsVersion(1L + builder.settingsVersion());
                    metadataBuilder.put(builder);
                }
                ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
                for (IndexMetadata.APIBlock block : IndexMetadata.APIBlock.values()) {
                    changed |= MetadataUpdateSettingsService.maybeUpdateClusterBlock(actualIndices, blocks, block.block, block.setting, openSettings);
                }
                if (!changed) {
                    return currentState;
                }
                ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
                updatedState = MetadataUpdateSettingsService.this.allocationService.reroute(updatedState, "settings update");
                try {
                    IndexMetadata updatedMetadata;
                    IndexMetadata currentMetadata;
                    for (Index index : openIndices) {
                        currentMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                    }
                    for (Index index : closeIndices) {
                        currentMetadata = currentState.getMetadata().getIndexSafe(index);
                        updatedMetadata = updatedState.metadata().getIndexSafe(index);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(currentMetadata, updatedMetadata);
                        MetadataUpdateSettingsService.this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
                    }
                }
                catch (IOException ex) {
                    throw ExceptionsHelper.convertToElastic(ex);
                }
                return updatedState;
            }
        });
    }

    private static boolean maybeUpdateClusterBlock(String[] actualIndices, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        boolean changed = false;
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (String index : actualIndices) {
                if (updateBlock) {
                    if (blocks.hasIndexBlock(index, block)) continue;
                    blocks.addIndexBlock(index, block);
                    changed = true;
                    continue;
                }
                if (!blocks.hasIndexBlock(index, block)) continue;
                blocks.removeIndexBlock(index, block);
                changed = true;
            }
        }
        return changed;
    }

    public void upgradeIndexSettings(final UpgradeSettingsClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("update-index-compatibility-versions", new AckedClusterStateUpdateTask(Priority.URGENT, request, ContextPreservingActionListener.wrapPreservingContext(listener, this.threadPool.getThreadContext())){

            @Override
            public ClusterState execute(ClusterState currentState) {
                Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
                for (Map.Entry<String, Tuple<Version, String>> entry : request.versions().entrySet()) {
                    String index = entry.getKey();
                    IndexMetadata indexMetadata = metadataBuilder.get(index);
                    if (indexMetadata == null || Version.CURRENT.equals(indexMetadata.getCreationVersion())) continue;
                    metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", entry.getValue().v1())).settingsVersion(1L + indexMetadata.getSettingsVersion()));
                }
                return ClusterState.builder(currentState).metadata(metadataBuilder).build();
            }
        });
    }
}

