/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Function;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesClusterStateUpdateRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.AliasAction;
import org.elasticsearch.cluster.metadata.AliasValidator;
import org.elasticsearch.cluster.metadata.DataStream;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.MetadataDeleteIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.mapper.MapperService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;

public class MetadataIndexAliasesService {
    private final ClusterService clusterService;
    private final IndicesService indicesService;
    private final AliasValidator aliasValidator;
    private final MetadataDeleteIndexService deleteIndexService;
    private final NamedXContentRegistry xContentRegistry;

    @Inject
    public MetadataIndexAliasesService(ClusterService clusterService, IndicesService indicesService, AliasValidator aliasValidator, MetadataDeleteIndexService deleteIndexService, NamedXContentRegistry xContentRegistry) {
        this.clusterService = clusterService;
        this.indicesService = indicesService;
        this.aliasValidator = aliasValidator;
        this.deleteIndexService = deleteIndexService;
        this.xContentRegistry = xContentRegistry;
    }

    public void indicesAliases(final IndicesAliasesClusterStateUpdateRequest request, ActionListener<AcknowledgedResponse> listener) {
        this.clusterService.submitStateUpdateTask("index-aliases", new AckedClusterStateUpdateTask(Priority.URGENT, request, listener){

            @Override
            public ClusterState execute(ClusterState currentState) {
                return MetadataIndexAliasesService.this.applyAliasActions(currentState, request.actions());
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState applyAliasActions(ClusterState currentState, Iterable<AliasAction> actions) {
        ArrayList indicesToClose = new ArrayList();
        HashMap indices = new HashMap();
        try {
            ClusterState updatedState;
            boolean changed = false;
            HashSet<Index> indicesToDelete = new HashSet<Index>();
            for (AliasAction action : actions) {
                if (!action.removeIndex()) continue;
                IndexMetadata index = currentState.metadata().getIndices().get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                indicesToDelete.add(index.getIndex());
                changed = true;
            }
            if (changed) {
                currentState = this.deleteIndexService.deleteIndices(currentState, indicesToDelete);
            }
            Metadata.Builder metadata = Metadata.builder(currentState.metadata());
            HashSet<String> maybeModifiedIndices = new HashSet<String>();
            for (AliasAction action : actions) {
                if (action.removeIndex()) continue;
                Function<String, String> lookup = name -> {
                    IndexMetadata imd = metadata.get((String)name);
                    if (imd != null) {
                        return imd.getIndex().getName();
                    }
                    DataStream dataStream = metadata.dataStream((String)name);
                    if (dataStream != null) {
                        return dataStream.getName();
                    }
                    return null;
                };
                DataStream dataStream = metadata.dataStream(action.getIndex());
                if (dataStream != null) {
                    AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, filter, writeIndex) -> this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, lookup);
                    if (!action.apply(newAliasValidator, metadata, null)) continue;
                    changed = true;
                    continue;
                }
                IndexMetadata index = metadata.get(action.getIndex());
                if (index == null) {
                    throw new IndexNotFoundException(action.getIndex());
                }
                this.validateAliasTargetIsNotDSBackingIndex(currentState, action);
                AliasAction.NewAliasValidator newAliasValidator = (alias, indexRouting, filter, writeIndex) -> {
                    this.aliasValidator.validateAlias(alias, action.getIndex(), indexRouting, lookup);
                    if (Strings.hasLength(filter)) {
                        IndicesClusterStateService.AllocatedIndex<IndexShard> indexService = (IndexService)indices.get(index.getIndex().getName());
                        if (indexService == null) {
                            indexService = this.indicesService.indexService(index.getIndex());
                            if (indexService == null) {
                                try {
                                    indexService = this.indicesService.createIndex(index, Collections.emptyList(), false);
                                    indicesToClose.add(index.getIndex());
                                }
                                catch (IOException e) {
                                    throw new ElasticsearchException("Failed to create temporary index for parsing the alias", (Throwable)e, new Object[0]);
                                }
                                ((IndexService)indexService).mapperService().merge(index, MapperService.MergeReason.MAPPING_RECOVERY);
                            }
                            indices.put(action.getIndex(), indexService);
                        }
                        this.aliasValidator.validateAliasFilter(alias, filter, ((IndexService)indexService).newSearchExecutionContext(0, 0, null, () -> System.currentTimeMillis(), null, Collections.emptyMap()), this.xContentRegistry);
                    }
                };
                if (!action.apply(newAliasValidator, metadata, index)) continue;
                changed = true;
                maybeModifiedIndices.add(index.getIndex().getName());
            }
            for (String maybeModifiedIndex : maybeModifiedIndices) {
                IndexMetadata currentIndexMetadata = currentState.metadata().index(maybeModifiedIndex);
                IndexMetadata newIndexMetadata = metadata.get(maybeModifiedIndex);
                if (currentIndexMetadata.getAliases().equals(newIndexMetadata.getAliases())) continue;
                assert (currentIndexMetadata.getAliasesVersion() == newIndexMetadata.getAliasesVersion());
                metadata.put(new IndexMetadata.Builder(newIndexMetadata).aliasesVersion(1L + currentIndexMetadata.getAliasesVersion()));
            }
            if (changed && !(updatedState = ClusterState.builder(currentState).metadata(metadata).build()).metadata().equalsAliases(currentState.metadata())) {
                ClusterState clusterState = updatedState;
                return clusterState;
            }
            ClusterState clusterState = currentState;
            return clusterState;
        }
        finally {
            for (Index index : indicesToClose) {
                this.indicesService.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "created for alias processing");
            }
        }
    }

    private void validateAliasTargetIsNotDSBackingIndex(ClusterState currentState, AliasAction action) {
        IndexAbstraction indexAbstraction = (IndexAbstraction)currentState.metadata().getIndicesLookup().get(action.getIndex());
        assert (indexAbstraction != null) : "invalid cluster metadata. index [" + action.getIndex() + "] was not found";
        if (indexAbstraction.getParentDataStream() != null) {
            throw new IllegalArgumentException("The provided index [" + action.getIndex() + "] is a backing index belonging to data stream [" + indexAbstraction.getParentDataStream().getName() + "]. Data streams and their backing indices don't support alias operations.");
        }
    }
}

