/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskConfig;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.LocalClusterUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.coordination.ApplyCommitRequest;
import org.elasticsearch.cluster.coordination.ClusterBootstrapService;
import org.elasticsearch.cluster.coordination.ClusterFormationFailureHelper;
import org.elasticsearch.cluster.coordination.ClusterStatePublisher;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.coordination.CoordinationState;
import org.elasticsearch.cluster.coordination.CoordinationStateRejectedException;
import org.elasticsearch.cluster.coordination.DiscoveryUpgradeService;
import org.elasticsearch.cluster.coordination.ElectionSchedulerFactory;
import org.elasticsearch.cluster.coordination.ElectionStrategy;
import org.elasticsearch.cluster.coordination.FailedToCommitClusterStateException;
import org.elasticsearch.cluster.coordination.FollowersChecker;
import org.elasticsearch.cluster.coordination.Join;
import org.elasticsearch.cluster.coordination.JoinHelper;
import org.elasticsearch.cluster.coordination.JoinRequest;
import org.elasticsearch.cluster.coordination.JoinTaskExecutor;
import org.elasticsearch.cluster.coordination.LagDetector;
import org.elasticsearch.cluster.coordination.LeaderChecker;
import org.elasticsearch.cluster.coordination.NoMasterBlockService;
import org.elasticsearch.cluster.coordination.NodeRemovalClusterStateTaskExecutor;
import org.elasticsearch.cluster.coordination.PreVoteCollector;
import org.elasticsearch.cluster.coordination.PreVoteResponse;
import org.elasticsearch.cluster.coordination.Publication;
import org.elasticsearch.cluster.coordination.PublicationTransportHandler;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishResponse;
import org.elasticsearch.cluster.coordination.PublishWithJoinResponse;
import org.elasticsearch.cluster.coordination.Reconfigurator;
import org.elasticsearch.cluster.coordination.StartJoinRequest;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.RerouteService;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterApplier;
import org.elasticsearch.cluster.service.MasterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.ListenableFuture;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.core.Booleans;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoveryModule;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.discovery.HandshakingTransportAddressConnector;
import org.elasticsearch.discovery.PeerFinder;
import org.elasticsearch.discovery.SeedHostsProvider;
import org.elasticsearch.discovery.SeedHostsResolver;
import org.elasticsearch.discovery.zen.PendingClusterStateStats;
import org.elasticsearch.gateway.ClusterStateUpdaters;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.monitor.NodeHealthService;
import org.elasticsearch.monitor.StatusInfo;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class Coordinator
extends AbstractLifecycleComponent
implements Discovery {
    public static final long ZEN1_BWC_TERM = 0L;
    private static final Logger logger = LogManager.getLogger(Coordinator.class);
    public static final Setting<TimeValue> PUBLISH_INFO_TIMEOUT_SETTING = Setting.timeSetting("cluster.publish.info_timeout", TimeValue.timeValueMillis(10000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    public static final Setting<TimeValue> PUBLISH_TIMEOUT_SETTING = Setting.timeSetting("cluster.publish.timeout", TimeValue.timeValueMillis(30000L), TimeValue.timeValueMillis(1L), Setting.Property.NodeScope);
    private final Settings settings;
    private final boolean singleNodeDiscovery;
    private final ElectionStrategy electionStrategy;
    private final TransportService transportService;
    private final MasterService masterService;
    private final AllocationService allocationService;
    private final JoinHelper joinHelper;
    private final NodeRemovalClusterStateTaskExecutor nodeRemovalExecutor;
    private final Supplier<CoordinationState.PersistedState> persistedStateSupplier;
    private final NoMasterBlockService noMasterBlockService;
    final Object mutex = new Object();
    private final SetOnce<CoordinationState> coordinationState = new SetOnce();
    private volatile ClusterState applierState;
    private final PeerFinder peerFinder;
    private final PreVoteCollector preVoteCollector;
    private final Random random;
    private final ElectionSchedulerFactory electionSchedulerFactory;
    private final SeedHostsResolver configuredHostsResolver;
    private final TimeValue publishTimeout;
    private final TimeValue publishInfoTimeout;
    private final PublicationTransportHandler publicationHandler;
    private final LeaderChecker leaderChecker;
    private final FollowersChecker followersChecker;
    private final ClusterApplier clusterApplier;
    private final Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators;
    @Nullable
    private Releasable electionScheduler;
    @Nullable
    private Releasable prevotingRound;
    private long maxTermSeen;
    private final Reconfigurator reconfigurator;
    private final ClusterBootstrapService clusterBootstrapService;
    private final DiscoveryUpgradeService discoveryUpgradeService;
    private final LagDetector lagDetector;
    private final ClusterFormationFailureHelper clusterFormationFailureHelper;
    private Mode mode;
    private Optional<DiscoveryNode> lastKnownLeader;
    private Optional<Join> lastJoin;
    private JoinHelper.JoinAccumulator joinAccumulator;
    private Optional<CoordinatorPublication> currentPublication = Optional.empty();
    private final NodeHealthService nodeHealthService;
    private AtomicBoolean reconfigurationTaskScheduled = new AtomicBoolean();

    public Coordinator(String nodeName, Settings settings, ClusterSettings clusterSettings, TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, AllocationService allocationService, MasterService masterService, Supplier<CoordinationState.PersistedState> persistedStateSupplier, SeedHostsProvider seedHostsProvider, ClusterApplier clusterApplier, Collection<BiConsumer<DiscoveryNode, ClusterState>> onJoinValidators, Random random, RerouteService rerouteService, ElectionStrategy electionStrategy, NodeHealthService nodeHealthService) {
        this.settings = settings;
        this.transportService = transportService;
        this.masterService = masterService;
        this.allocationService = allocationService;
        this.onJoinValidators = JoinTaskExecutor.addBuiltInJoinValidators(onJoinValidators);
        this.singleNodeDiscovery = DiscoveryModule.isSingleNodeDiscovery(settings);
        this.electionStrategy = electionStrategy;
        this.joinHelper = new JoinHelper(settings, allocationService, masterService, transportService, this::getCurrentTerm, this::getStateForMasterService, this::handleJoinRequest, this::joinLeaderInTerm, this.onJoinValidators, rerouteService, nodeHealthService);
        this.persistedStateSupplier = persistedStateSupplier;
        this.noMasterBlockService = new NoMasterBlockService(settings, clusterSettings);
        this.lastKnownLeader = Optional.empty();
        this.lastJoin = Optional.empty();
        this.joinAccumulator = new JoinHelper.InitialJoinAccumulator();
        this.publishTimeout = PUBLISH_TIMEOUT_SETTING.get(settings);
        this.publishInfoTimeout = PUBLISH_INFO_TIMEOUT_SETTING.get(settings);
        this.random = random;
        this.electionSchedulerFactory = new ElectionSchedulerFactory(settings, random, transportService.getThreadPool());
        this.preVoteCollector = new PreVoteCollector(transportService, this::startElection, this::updateMaxTermSeen, electionStrategy, nodeHealthService);
        this.configuredHostsResolver = new SeedHostsResolver(nodeName, settings, transportService, seedHostsProvider);
        this.peerFinder = new CoordinatorPeerFinder(settings, transportService, new HandshakingTransportAddressConnector(settings, transportService), this.configuredHostsResolver);
        this.publicationHandler = new PublicationTransportHandler(transportService, namedWriteableRegistry, this::handlePublishRequest, this::handleApplyCommit);
        this.leaderChecker = new LeaderChecker(settings, transportService, this::onLeaderFailure, nodeHealthService);
        this.followersChecker = new FollowersChecker(settings, transportService, this::onFollowerCheckRequest, this::removeNode, nodeHealthService);
        this.nodeRemovalExecutor = new NodeRemovalClusterStateTaskExecutor(allocationService, logger);
        this.clusterApplier = clusterApplier;
        masterService.setClusterStateSupplier(this::getStateForMasterService);
        this.reconfigurator = new Reconfigurator(settings, clusterSettings);
        this.clusterBootstrapService = new ClusterBootstrapService(settings, transportService, this::getFoundPeers, this::isInitialConfigurationSet, this::setInitialConfiguration);
        this.discoveryUpgradeService = new DiscoveryUpgradeService(settings, transportService, this::isInitialConfigurationSet, this.joinHelper, this.peerFinder::getFoundPeers, this::setInitialConfiguration);
        this.lagDetector = new LagDetector(settings, transportService.getThreadPool(), n -> this.removeNode((DiscoveryNode)n, "lagging"), transportService::getLocalNode);
        this.clusterFormationFailureHelper = new ClusterFormationFailureHelper(settings, this::getClusterFormationState, transportService.getThreadPool(), this.joinHelper::logLastFailedJoinAttempt);
        this.nodeHealthService = nodeHealthService;
    }

    private ClusterFormationFailureHelper.ClusterFormationState getClusterFormationState() {
        return new ClusterFormationFailureHelper.ClusterFormationState(this.settings, this.getStateForMasterService(), this.peerFinder.getLastResolvedAddresses(), Stream.concat(Stream.of(this.getLocalNode()), StreamSupport.stream(this.peerFinder.getFoundPeers().spliterator(), false)).collect(Collectors.toList()), this.getCurrentTerm(), this.electionStrategy, this.nodeHealthService.getHealth());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onLeaderFailure(Exception e) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode != Mode.CANDIDATE) {
                assert (this.lastKnownLeader.isPresent());
                logger.info(new ParameterizedMessage("master node [{}] failed, restarting discovery", (Object)this.lastKnownLeader.get()), (Throwable)e);
            }
            this.becomeCandidate("onLeaderFailure");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeNode(DiscoveryNode discoveryNode, String reason) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode == Mode.LEADER) {
                this.masterService.submitStateUpdateTask("node-left", new NodeRemovalClusterStateTaskExecutor.Task(discoveryNode, reason), ClusterStateTaskConfig.build(Priority.IMMEDIATE), this.nodeRemovalExecutor, this.nodeRemovalExecutor);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onFollowerCheckRequest(FollowersChecker.FollowerCheckRequest followerCheckRequest) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensureTermAtLeast(followerCheckRequest.getSender(), followerCheckRequest.getTerm());
            if (this.getCurrentTerm() != followerCheckRequest.getTerm()) {
                logger.trace("onFollowerCheckRequest: current term is [{}], rejecting {}", (Object)this.getCurrentTerm(), (Object)followerCheckRequest);
                throw new CoordinationStateRejectedException("onFollowerCheckRequest: current term is [" + this.getCurrentTerm() + "], rejecting " + followerCheckRequest, new Object[0]);
            }
            if (this.getLastAcceptedState().term() < this.getCurrentTerm()) {
                this.becomeFollower("onFollowerCheckRequest", followerCheckRequest.getSender());
            } else if (this.mode == Mode.FOLLOWER) {
                logger.trace("onFollowerCheckRequest: responding successfully to {}", (Object)followerCheckRequest);
            } else if (this.joinHelper.isJoinPending()) {
                logger.trace("onFollowerCheckRequest: rejoining master, responding successfully to {}", (Object)followerCheckRequest);
            } else {
                logger.trace("onFollowerCheckRequest: received check from faulty master, rejecting {}", (Object)followerCheckRequest);
                throw new CoordinationStateRejectedException("onFollowerCheckRequest: received check from faulty master, rejecting " + followerCheckRequest, new Object[0]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleApplyCommit(ApplyCommitRequest applyCommitRequest, final ActionListener<Void> applyListener) {
        Object object = this.mutex;
        synchronized (object) {
            logger.trace("handleApplyCommit: applying commit {}", (Object)applyCommitRequest);
            this.coordinationState.get().handleCommit(applyCommitRequest);
            ClusterState committedState = ClusterStateUpdaters.hideStateIfNotRecovered(this.coordinationState.get().getLastAcceptedState());
            ClusterState clusterState = this.applierState = this.mode == Mode.CANDIDATE ? this.clusterStateWithNoMasterBlock(committedState) : committedState;
            if (applyCommitRequest.getSourceNode().equals(this.getLocalNode())) {
                applyListener.onResponse(null);
            } else {
                this.clusterApplier.onNewClusterState(applyCommitRequest.toString(), () -> this.applierState, new ClusterApplier.ClusterApplyListener(){

                    @Override
                    public void onFailure(String source, Exception e) {
                        applyListener.onFailure(e);
                    }

                    @Override
                    public void onSuccess(String source) {
                        applyListener.onResponse(null);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PublishWithJoinResponse handlePublishRequest(PublishRequest publishRequest) {
        assert (publishRequest.getAcceptedState().nodes().getLocalNode().equals(this.getLocalNode())) : publishRequest.getAcceptedState().nodes().getLocalNode() + " != " + this.getLocalNode();
        Object object = this.mutex;
        synchronized (object) {
            DiscoveryNode sourceNode = publishRequest.getAcceptedState().nodes().getMasterNode();
            logger.trace("handlePublishRequest: handling [{}] from [{}]", (Object)publishRequest, (Object)sourceNode);
            if (sourceNode.equals(this.getLocalNode()) && this.mode != Mode.LEADER) {
                throw new CoordinationStateRejectedException("no longer leading this publication's term: " + publishRequest, new Object[0]);
            }
            if (publishRequest.getAcceptedState().term() == 0L && this.getCurrentTerm() == 0L && this.mode == Mode.FOLLOWER && !Optional.of(sourceNode).equals(this.lastKnownLeader)) {
                logger.debug("received cluster state from {} but currently following {}, rejecting", (Object)sourceNode, (Object)this.lastKnownLeader);
                throw new CoordinationStateRejectedException("received cluster state from " + sourceNode + " but currently following " + this.lastKnownLeader + ", rejecting", new Object[0]);
            }
            ClusterState localState = this.coordinationState.get().getLastAcceptedState();
            if (localState.metadata().clusterUUIDCommitted() && !localState.metadata().clusterUUID().equals(publishRequest.getAcceptedState().metadata().clusterUUID())) {
                logger.warn("received cluster state from {} with a different cluster uuid {} than local cluster uuid {}, rejecting", (Object)sourceNode, (Object)publishRequest.getAcceptedState().metadata().clusterUUID(), (Object)localState.metadata().clusterUUID());
                throw new CoordinationStateRejectedException("received cluster state from " + sourceNode + " with a different cluster uuid " + publishRequest.getAcceptedState().metadata().clusterUUID() + " than local cluster uuid " + localState.metadata().clusterUUID() + ", rejecting", new Object[0]);
            }
            if (publishRequest.getAcceptedState().term() > localState.term()) {
                this.onJoinValidators.forEach(a -> a.accept(this.getLocalNode(), publishRequest.getAcceptedState()));
            }
            this.ensureTermAtLeast(sourceNode, publishRequest.getAcceptedState().term());
            PublishResponse publishResponse = this.coordinationState.get().handlePublishRequest(publishRequest);
            if (sourceNode.equals(this.getLocalNode())) {
                this.preVoteCollector.update(this.getPreVoteResponse(), this.getLocalNode());
            } else {
                this.becomeFollower("handlePublishRequest", sourceNode);
            }
            return new PublishWithJoinResponse(publishResponse, Coordinator.joinWithDestination(this.lastJoin, sourceNode, publishRequest.getAcceptedState().term()));
        }
    }

    private static Optional<Join> joinWithDestination(Optional<Join> lastJoin, DiscoveryNode leader, long term) {
        if (lastJoin.isPresent() && lastJoin.get().targetMatches(leader) && lastJoin.get().getTerm() == term) {
            return lastJoin;
        }
        return Optional.empty();
    }

    private void closePrevotingAndElectionScheduler() {
        if (this.prevotingRound != null) {
            this.prevotingRound.close();
            this.prevotingRound = null;
        }
        if (this.electionScheduler != null) {
            this.electionScheduler.close();
            this.electionScheduler = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateMaxTermSeen(long term) {
        Object object = this.mutex;
        synchronized (object) {
            this.maxTermSeen = Math.max(this.maxTermSeen, term);
            long currentTerm = this.getCurrentTerm();
            if (this.mode == Mode.LEADER && this.maxTermSeen > currentTerm) {
                if (this.publicationInProgress()) {
                    logger.debug("updateMaxTermSeen: maxTermSeen = {} > currentTerm = {}, enqueueing term bump", (Object)this.maxTermSeen, (Object)currentTerm);
                } else {
                    try {
                        logger.debug("updateMaxTermSeen: maxTermSeen = {} > currentTerm = {}, bumping term", (Object)this.maxTermSeen, (Object)currentTerm);
                        this.ensureTermAtLeast(this.getLocalNode(), this.maxTermSeen);
                        this.startElection();
                    }
                    catch (Exception e) {
                        logger.warn(new ParameterizedMessage("failed to bump term to {}", (Object)this.maxTermSeen), (Throwable)e);
                        this.becomeCandidate("updateMaxTermSeen");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startElection() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.mode == Mode.CANDIDATE) {
                if (!Coordinator.localNodeMayWinElection(this.getLastAcceptedState())) {
                    logger.trace("skip election as local node may not win it: {}", (Object)this.getLastAcceptedState().coordinationMetadata());
                    return;
                }
                StartJoinRequest startJoinRequest = new StartJoinRequest(this.getLocalNode(), Math.max(this.getCurrentTerm(), this.maxTermSeen) + 1L);
                logger.debug("starting election with {}", (Object)startJoinRequest);
                this.getDiscoveredNodes().forEach(node -> {
                    if (!Coordinator.isZen1Node(node)) {
                        this.joinHelper.sendStartJoinRequest(startJoinRequest, (DiscoveryNode)node);
                    }
                });
            }
        }
    }

    private void abdicateTo(DiscoveryNode newMaster) {
        assert (Thread.holdsLock(this.mutex));
        assert (this.mode == Mode.LEADER) : "expected to be leader on abdication but was " + (Object)((Object)this.mode);
        assert (newMaster.isMasterNode()) : "should only abdicate to master-eligible node but was " + newMaster;
        StartJoinRequest startJoinRequest = new StartJoinRequest(newMaster, Math.max(this.getCurrentTerm(), this.maxTermSeen) + 1L);
        logger.info("abdicating to {} with term {}", (Object)newMaster, (Object)startJoinRequest.getTerm());
        this.getLastAcceptedState().nodes().mastersFirstStream().forEach(node -> {
            if (!Coordinator.isZen1Node(node)) {
                this.joinHelper.sendStartJoinRequest(startJoinRequest, (DiscoveryNode)node);
            }
        });
        assert (this.mode == Mode.LEADER) : "should still be leader after sending abdication messages " + (Object)((Object)this.mode);
        this.becomeCandidate("after abdicating to " + newMaster);
    }

    private static boolean localNodeMayWinElection(ClusterState lastAcceptedState) {
        DiscoveryNode localNode = lastAcceptedState.nodes().getLocalNode();
        assert (localNode != null);
        return Coordinator.nodeMayWinElection(lastAcceptedState, localNode);
    }

    private static boolean nodeMayWinElection(ClusterState lastAcceptedState, DiscoveryNode node) {
        String nodeId = node.getId();
        return lastAcceptedState.getLastCommittedConfiguration().getNodeIds().contains(nodeId) || lastAcceptedState.getLastAcceptedConfiguration().getNodeIds().contains(nodeId) || lastAcceptedState.getVotingConfigExclusions().stream().noneMatch(vce -> vce.getNodeId().equals(nodeId));
    }

    private Optional<Join> ensureTermAtLeast(DiscoveryNode sourceNode, long targetTerm) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.getCurrentTerm() < targetTerm) {
            return Optional.of(this.joinLeaderInTerm(new StartJoinRequest(sourceNode, targetTerm)));
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Join joinLeaderInTerm(StartJoinRequest startJoinRequest) {
        Object object = this.mutex;
        synchronized (object) {
            logger.debug("joinLeaderInTerm: for [{}] with term {}", (Object)startJoinRequest.getSourceNode(), (Object)startJoinRequest.getTerm());
            Join join = this.coordinationState.get().handleStartJoin(startJoinRequest);
            this.lastJoin = Optional.of(join);
            this.peerFinder.setCurrentTerm(this.getCurrentTerm());
            if (this.mode != Mode.CANDIDATE) {
                this.becomeCandidate("joinLeaderInTerm");
            } else {
                this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
                this.preVoteCollector.update(this.getPreVoteResponse(), null);
            }
            return join;
        }
    }

    private void handleJoinRequest(JoinRequest joinRequest, JoinHelper.JoinCallback joinCallback) {
        assert (!Thread.holdsLock(this.mutex));
        assert (this.getLocalNode().isMasterNode()) : this.getLocalNode() + " received a join but is not master-eligible";
        logger.trace("handleJoinRequest: as {}, handling {}", (Object)this.mode, (Object)joinRequest);
        if (this.singleNodeDiscovery && !joinRequest.getSourceNode().equals(this.getLocalNode())) {
            joinCallback.onFailure(new IllegalStateException("cannot join node with [" + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + "] set to [" + "single-node" + "] discovery"));
            return;
        }
        this.transportService.connectToNode(joinRequest.getSourceNode(), ActionListener.wrap(ignore -> {
            ClusterState stateForJoinValidation = this.getStateForMasterService();
            if (stateForJoinValidation.nodes().isLocalNodeElectedMaster()) {
                this.onJoinValidators.forEach(a -> a.accept(joinRequest.getSourceNode(), stateForJoinValidation));
                if (!stateForJoinValidation.getBlocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
                    JoinTaskExecutor.ensureVersionBarrier(joinRequest.getSourceNode().getVersion(), stateForJoinValidation.getNodes().getMinNodeVersion());
                }
                this.sendValidateJoinRequest(stateForJoinValidation, joinRequest, joinCallback);
            } else {
                this.processJoinRequest(joinRequest, joinCallback);
            }
        }, joinCallback::onFailure));
    }

    void sendValidateJoinRequest(ClusterState stateForJoinValidation, final JoinRequest joinRequest, final JoinHelper.JoinCallback joinCallback) {
        this.joinHelper.sendValidateJoinRequest(joinRequest.getSourceNode(), stateForJoinValidation, new ActionListener<TransportResponse.Empty>(){

            @Override
            public void onResponse(TransportResponse.Empty empty) {
                try {
                    Coordinator.this.processJoinRequest(joinRequest, joinCallback);
                }
                catch (Exception e) {
                    joinCallback.onFailure(e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                logger.warn(() -> new ParameterizedMessage("failed to validate incoming join request from node [{}]", (Object)joinRequest.getSourceNode()), (Throwable)e);
                joinCallback.onFailure(new IllegalStateException("failure when sending a validation request to node", e));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJoinRequest(JoinRequest joinRequest, JoinHelper.JoinCallback joinCallback) {
        Optional<Join> optionalJoin = joinRequest.getOptionalJoin();
        Object object = this.mutex;
        synchronized (object) {
            this.updateMaxTermSeen(joinRequest.getTerm());
            CoordinationState coordState = this.coordinationState.get();
            boolean prevElectionWon = coordState.electionWon();
            optionalJoin.ifPresent(this::handleJoin);
            this.joinAccumulator.handleJoinRequest(joinRequest.getSourceNode(), joinCallback);
            if (!prevElectionWon && coordState.electionWon()) {
                this.becomeLeader("handleJoinRequest");
            }
        }
    }

    void becomeCandidate(String method) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        logger.debug("{}: coordinator becoming CANDIDATE in term {} (was {}, lastKnownLeader was [{}])", (Object)method, (Object)this.getCurrentTerm(), (Object)this.mode, (Object)this.lastKnownLeader);
        if (this.mode != Mode.CANDIDATE) {
            Mode prevMode = this.mode;
            this.mode = Mode.CANDIDATE;
            this.cancelActivePublication("become candidate: " + method);
            this.joinAccumulator.close(this.mode);
            this.joinAccumulator = new JoinHelper.CandidateJoinAccumulator(this.joinHelper);
            this.peerFinder.activate(this.coordinationState.get().getLastAcceptedState().nodes());
            this.clusterFormationFailureHelper.start();
            if (this.getCurrentTerm() == 0L) {
                this.discoveryUpgradeService.activate(this.lastKnownLeader, this.coordinationState.get().getLastAcceptedState());
            }
            this.leaderChecker.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
            this.leaderChecker.updateLeader(null);
            this.followersChecker.clearCurrentNodes();
            this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
            this.lagDetector.clearTrackedNodes();
            if (prevMode == Mode.LEADER) {
                this.cleanMasterService();
            }
            if (this.applierState.nodes().getMasterNodeId() != null) {
                this.applierState = this.clusterStateWithNoMasterBlock(this.applierState);
                this.clusterApplier.onNewClusterState("becoming candidate: " + method, () -> this.applierState, (source, e) -> {});
            }
        }
        this.preVoteCollector.update(this.getPreVoteResponse(), null);
    }

    void becomeLeader(String method) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.mode == Mode.CANDIDATE) : "expected candidate but was " + (Object)((Object)this.mode);
        assert (this.getLocalNode().isMasterNode()) : this.getLocalNode() + " became a leader but is not master-eligible";
        logger.debug("{}: coordinator becoming LEADER in term {} (was {}, lastKnownLeader was [{}])", (Object)method, (Object)this.getCurrentTerm(), (Object)this.mode, (Object)this.lastKnownLeader);
        this.mode = Mode.LEADER;
        this.joinAccumulator.close(this.mode);
        this.joinAccumulator = new JoinHelper.LeaderJoinAccumulator(this.joinHelper);
        this.lastKnownLeader = Optional.of(this.getLocalNode());
        this.peerFinder.deactivate(this.getLocalNode());
        this.discoveryUpgradeService.deactivate();
        this.clusterFormationFailureHelper.stop();
        this.closePrevotingAndElectionScheduler();
        this.preVoteCollector.update(this.getPreVoteResponse(), this.getLocalNode());
        assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
        this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
    }

    void becomeFollower(String method, DiscoveryNode leaderNode) {
        boolean restartLeaderChecker;
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (leaderNode.isMasterNode()) : leaderNode + " became a leader but is not master-eligible";
        assert (this.mode != Mode.LEADER) : "do not switch to follower from leader (should be candidate first)";
        if (this.mode == Mode.FOLLOWER && Optional.of(leaderNode).equals(this.lastKnownLeader)) {
            logger.trace("{}: coordinator remaining FOLLOWER of [{}] in term {}", (Object)method, (Object)leaderNode, (Object)this.getCurrentTerm());
        } else {
            logger.debug("{}: coordinator becoming FOLLOWER of [{}] in term {} (was {}, lastKnownLeader was [{}])", (Object)method, (Object)leaderNode, (Object)this.getCurrentTerm(), (Object)this.mode, (Object)this.lastKnownLeader);
        }
        boolean bl = restartLeaderChecker = !(this.mode == Mode.FOLLOWER && Optional.of(leaderNode).equals(this.lastKnownLeader));
        if (this.mode != Mode.FOLLOWER) {
            this.mode = Mode.FOLLOWER;
            this.joinAccumulator.close(this.mode);
            this.joinAccumulator = new JoinHelper.FollowerJoinAccumulator();
            this.leaderChecker.setCurrentNodes(DiscoveryNodes.EMPTY_NODES);
        }
        this.lastKnownLeader = Optional.of(leaderNode);
        this.peerFinder.deactivate(leaderNode);
        this.discoveryUpgradeService.deactivate();
        this.clusterFormationFailureHelper.stop();
        this.closePrevotingAndElectionScheduler();
        this.cancelActivePublication("become follower: " + method);
        this.preVoteCollector.update(this.getPreVoteResponse(), leaderNode);
        if (restartLeaderChecker) {
            this.leaderChecker.updateLeader(leaderNode);
        }
        this.followersChecker.clearCurrentNodes();
        this.followersChecker.updateFastResponseState(this.getCurrentTerm(), this.mode);
        this.lagDetector.clearTrackedNodes();
    }

    private void cleanMasterService() {
        this.masterService.submitStateUpdateTask("clean-up after stepping down as master", new LocalClusterUpdateTask(){

            @Override
            public void onFailure(String source, Exception e) {
                logger.trace("failed to clean-up after stepping down as master", (Throwable)e);
            }

            @Override
            public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                if (!currentState.nodes().isLocalNodeElectedMaster()) {
                    Coordinator.this.allocationService.cleanCaches();
                }
                return 3.unchanged();
            }
        });
    }

    private PreVoteResponse getPreVoteResponse() {
        return new PreVoteResponse(this.getCurrentTerm(), this.coordinationState.get().getLastAcceptedTerm(), this.coordinationState.get().getLastAcceptedState().getVersionOrMetadataVersion());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    long getCurrentTerm() {
        Object object = this.mutex;
        synchronized (object) {
            return this.coordinationState.get().getCurrentTerm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Mode getMode() {
        Object object = this.mutex;
        synchronized (object) {
            return this.mode;
        }
    }

    DiscoveryNode getLocalNode() {
        return this.transportService.getLocalNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean publicationInProgress() {
        Object object = this.mutex;
        synchronized (object) {
            return this.currentPublication.isPresent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStart() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState initialState;
            CoordinationState.PersistedState persistedState = this.persistedStateSupplier.get();
            this.coordinationState.set(new CoordinationState(this.getLocalNode(), persistedState, this.electionStrategy));
            this.peerFinder.setCurrentTerm(this.getCurrentTerm());
            this.configuredHostsResolver.start();
            ClusterState lastAcceptedState = this.coordinationState.get().getLastAcceptedState();
            if (lastAcceptedState.metadata().clusterUUIDCommitted()) {
                logger.info("cluster UUID [{}]", (Object)lastAcceptedState.metadata().clusterUUID());
            }
            CoordinationMetadata.VotingConfiguration votingConfiguration = lastAcceptedState.getLastCommittedConfiguration();
            if (this.singleNodeDiscovery && !votingConfiguration.isEmpty() && !votingConfiguration.hasQuorum(Collections.singleton(this.getLocalNode().getId()))) {
                throw new IllegalStateException("cannot start with [" + DiscoveryModule.DISCOVERY_TYPE_SETTING.getKey() + "] set to [" + "single-node" + "] when local node " + this.getLocalNode() + " does not have quorum in voting configuration " + votingConfiguration);
            }
            this.applierState = initialState = ClusterState.builder(ClusterName.CLUSTER_NAME_SETTING.get(this.settings)).blocks(ClusterBlocks.builder().addGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK).addGlobalBlock(this.noMasterBlockService.getNoMasterBlock())).nodes(DiscoveryNodes.builder().add(this.getLocalNode()).localNodeId(this.getLocalNode().getId())).build();
            this.clusterApplier.setInitialState(initialState);
        }
    }

    @Override
    public DiscoveryStats stats() {
        return new DiscoveryStats(new PendingClusterStateStats(0, 0, 0), this.publicationHandler.stats());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startInitialJoin() {
        Object object = this.mutex;
        synchronized (object) {
            this.becomeCandidate("startInitialJoin");
        }
        this.clusterBootstrapService.scheduleUnconfiguredBootstrap();
    }

    @Override
    protected void doStop() {
        this.configuredHostsResolver.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doClose() throws IOException {
        CoordinationState coordinationState = this.coordinationState.get();
        if (coordinationState != null) {
            Object object = this.mutex;
            synchronized (object) {
                coordinationState.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invariant() {
        Object object = this.mutex;
        synchronized (object) {
            Optional<DiscoveryNode> peerFinderLeader = this.peerFinder.getLeader();
            assert (this.peerFinder.getCurrentTerm() == this.getCurrentTerm());
            assert (this.followersChecker.getFastResponseState().term == this.getCurrentTerm()) : this.followersChecker.getFastResponseState();
            assert (this.followersChecker.getFastResponseState().mode == this.getMode()) : this.followersChecker.getFastResponseState();
            assert (this.applierState.nodes().getMasterNodeId() == null == this.applierState.blocks().hasGlobalBlockWithId(2));
            assert (this.preVoteCollector.getPreVoteResponse().equals(this.getPreVoteResponse())) : this.preVoteCollector + " vs " + this.getPreVoteResponse();
            assert (!this.lagDetector.getTrackedNodes().contains(this.getLocalNode())) : this.lagDetector.getTrackedNodes();
            assert (this.followersChecker.getKnownFollowers().equals(this.lagDetector.getTrackedNodes())) : this.followersChecker.getKnownFollowers() + " vs " + this.lagDetector.getTrackedNodes();
            if (this.mode == Mode.LEADER) {
                boolean becomingMaster;
                boolean bl = becomingMaster = this.getStateForMasterService().term() != this.getCurrentTerm();
                assert (this.coordinationState.get().electionWon());
                assert (this.lastKnownLeader.isPresent() && this.lastKnownLeader.get().equals(this.getLocalNode()));
                assert (this.joinAccumulator instanceof JoinHelper.LeaderJoinAccumulator);
                assert (peerFinderLeader.equals(this.lastKnownLeader)) : peerFinderLeader;
                assert (this.electionScheduler == null) : this.electionScheduler;
                assert (this.prevotingRound == null) : this.prevotingRound;
                assert (becomingMaster || this.getStateForMasterService().nodes().getMasterNodeId() != null) : this.getStateForMasterService();
                assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
                assert (this.getLocalNode().equals(this.applierState.nodes().getMasterNode()) || this.applierState.nodes().getMasterNodeId() == null && this.applierState.term() < this.getCurrentTerm());
                assert (this.preVoteCollector.getLeader() == this.getLocalNode()) : this.preVoteCollector;
                assert (!this.clusterFormationFailureHelper.isRunning());
                boolean activePublication = this.currentPublication.map(CoordinatorPublication::isActiveForCurrentLeader).orElse(false);
                if (becomingMaster && !activePublication) {
                    assert (this.followersChecker.getKnownFollowers().isEmpty()) : this.followersChecker.getKnownFollowers();
                } else {
                    ClusterState lastPublishedState = activePublication ? this.currentPublication.get().publishedState() : this.coordinationState.get().getLastAcceptedState();
                    HashSet lastPublishedNodes = new HashSet();
                    lastPublishedState.nodes().forEach(lastPublishedNodes::add);
                    assert (lastPublishedNodes.remove(this.getLocalNode()));
                    assert (lastPublishedNodes.equals(this.followersChecker.getKnownFollowers())) : lastPublishedNodes + " != " + this.followersChecker.getKnownFollowers();
                }
                assert (becomingMaster || activePublication || this.coordinationState.get().getLastAcceptedConfiguration().equals(this.coordinationState.get().getLastCommittedConfiguration())) : this.coordinationState.get().getLastAcceptedConfiguration() + " != " + this.coordinationState.get().getLastCommittedConfiguration();
            } else if (this.mode == Mode.FOLLOWER) {
                assert (!this.coordinationState.get().electionWon()) : this.getLocalNode() + " is FOLLOWER so electionWon() should be false";
                assert (this.lastKnownLeader.isPresent() && !this.lastKnownLeader.get().equals(this.getLocalNode()));
                assert (this.joinAccumulator instanceof JoinHelper.FollowerJoinAccumulator);
                assert (peerFinderLeader.equals(this.lastKnownLeader)) : peerFinderLeader;
                assert (this.electionScheduler == null) : this.electionScheduler;
                assert (this.prevotingRound == null) : this.prevotingRound;
                assert (this.getStateForMasterService().nodes().getMasterNodeId() == null) : this.getStateForMasterService();
                assert (!this.leaderChecker.currentNodeIsMaster());
                assert (this.lastKnownLeader.equals(Optional.of(this.leaderChecker.leader())));
                assert (this.followersChecker.getKnownFollowers().isEmpty());
                assert (this.lastKnownLeader.get().equals(this.applierState.nodes().getMasterNode()) || this.applierState.nodes().getMasterNodeId() == null && (this.applierState.term() < this.getCurrentTerm() || this.applierState.version() < this.getLastAcceptedState().version()));
                assert (this.currentPublication.map(Publication::isCommitted).orElse(true).booleanValue());
                assert (this.preVoteCollector.getLeader().equals(this.lastKnownLeader.get())) : this.preVoteCollector;
                assert (!this.clusterFormationFailureHelper.isRunning());
            } else {
                assert (this.mode == Mode.CANDIDATE);
                assert (this.joinAccumulator instanceof JoinHelper.CandidateJoinAccumulator);
                assert (!peerFinderLeader.isPresent()) : peerFinderLeader;
                assert (this.prevotingRound == null || this.electionScheduler != null);
                assert (this.getStateForMasterService().nodes().getMasterNodeId() == null) : this.getStateForMasterService();
                assert (!this.leaderChecker.currentNodeIsMaster());
                assert (this.leaderChecker.leader() == null) : this.leaderChecker.leader();
                assert (this.followersChecker.getKnownFollowers().isEmpty());
                assert (this.applierState.nodes().getMasterNodeId() == null);
                assert (this.currentPublication.map(Publication::isCommitted).orElse(true).booleanValue());
                assert (this.preVoteCollector.getLeader() == null) : this.preVoteCollector;
                assert (this.clusterFormationFailureHelper.isRunning());
            }
        }
    }

    public boolean isInitialConfigurationSet() {
        return !this.getStateForMasterService().getLastAcceptedConfiguration().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setInitialConfiguration(CoordinationMetadata.VotingConfiguration votingConfiguration) {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState currentState = this.getStateForMasterService();
            if (this.isInitialConfigurationSet()) {
                logger.debug("initial configuration already set, ignoring {}", (Object)votingConfiguration);
                return false;
            }
            if (!this.getLocalNode().isMasterNode()) {
                logger.debug("skip setting initial configuration as local node is not a master-eligible node");
                throw new CoordinationStateRejectedException("this node is not master-eligible, but cluster bootstrapping can only happen on a master-eligible node", new Object[0]);
            }
            if (!votingConfiguration.getNodeIds().contains(this.getLocalNode().getId())) {
                logger.debug("skip setting initial configuration as local node is not part of initial configuration");
                throw new CoordinationStateRejectedException("local node is not part of initial configuration", new Object[0]);
            }
            ArrayList<DiscoveryNode> knownNodes = new ArrayList<DiscoveryNode>();
            knownNodes.add(this.getLocalNode());
            this.peerFinder.getFoundPeers().forEach(knownNodes::add);
            if (!votingConfiguration.hasQuorum(knownNodes.stream().map(DiscoveryNode::getId).collect(Collectors.toList()))) {
                logger.debug("skip setting initial configuration as not enough nodes discovered to form a quorum in the initial configuration [knownNodes={}, {}]", (Object)knownNodes, (Object)votingConfiguration);
                throw new CoordinationStateRejectedException("not enough nodes discovered to form a quorum in the initial configuration [knownNodes=" + knownNodes + ", " + votingConfiguration + "]", new Object[0]);
            }
            logger.info("setting initial configuration to {}", (Object)votingConfiguration);
            CoordinationMetadata coordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).lastAcceptedConfiguration(votingConfiguration).lastCommittedConfiguration(votingConfiguration).build();
            Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
            metadataBuilder.generateClusterUuidIfNeeded();
            metadataBuilder.coordinationMetadata(coordinationMetadata);
            this.coordinationState.get().setInitialState(ClusterState.builder(currentState).metadata(metadataBuilder).build());
            assert (Coordinator.localNodeMayWinElection(this.getLastAcceptedState())) : "initial state does not allow local node to win election: " + this.getLastAcceptedState().coordinationMetadata();
            this.preVoteCollector.update(this.getPreVoteResponse(), null);
            this.startElectionScheduler();
            return true;
        }
    }

    ClusterState improveConfiguration(ClusterState clusterState) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (Coordinator.validVotingConfigExclusionState(clusterState)) : clusterState;
        Stream<String> excludedNodeIds = clusterState.getVotingConfigExclusions().stream().map(CoordinationMetadata.VotingConfigExclusion::getNodeId);
        Stream<String> masterIneligibleNodeIdsInVotingConfig = StreamSupport.stream(clusterState.nodes().spliterator(), false).filter(n -> !n.isMasterNode() && (clusterState.getLastAcceptedConfiguration().getNodeIds().contains(n.getId()) || clusterState.getLastCommittedConfiguration().getNodeIds().contains(n.getId()))).map(DiscoveryNode::getId);
        Set<DiscoveryNode> liveNodes = StreamSupport.stream(clusterState.nodes().spliterator(), false).filter(DiscoveryNode::isMasterNode).filter(this.coordinationState.get()::containsJoinVoteFor).filter(discoveryNode -> !Coordinator.isZen1Node(discoveryNode)).collect(Collectors.toSet());
        CoordinationMetadata.VotingConfiguration newConfig = this.reconfigurator.reconfigure(liveNodes, Stream.concat(masterIneligibleNodeIdsInVotingConfig, excludedNodeIds).collect(Collectors.toSet()), this.getLocalNode(), clusterState.getLastAcceptedConfiguration());
        if (!newConfig.equals(clusterState.getLastAcceptedConfiguration())) {
            assert (this.coordinationState.get().joinVotesHaveQuorumFor(newConfig));
            return ClusterState.builder(clusterState).metadata(Metadata.builder(clusterState.metadata()).coordinationMetadata(CoordinationMetadata.builder(clusterState.coordinationMetadata()).lastAcceptedConfiguration(newConfig).build())).build();
        }
        return clusterState;
    }

    static boolean validVotingConfigExclusionState(ClusterState clusterState) {
        Set<CoordinationMetadata.VotingConfigExclusion> votingConfigExclusions = clusterState.getVotingConfigExclusions();
        Set nodeNamesWithAbsentId = votingConfigExclusions.stream().filter(e -> e.getNodeId().equals("_absent_")).map(CoordinationMetadata.VotingConfigExclusion::getNodeName).collect(Collectors.toSet());
        Set nodeIdsWithAbsentName = votingConfigExclusions.stream().filter(e -> e.getNodeName().equals("_absent_")).map(CoordinationMetadata.VotingConfigExclusion::getNodeId).collect(Collectors.toSet());
        for (DiscoveryNode node : clusterState.getNodes()) {
            if (!node.isMasterNode() || !nodeIdsWithAbsentName.contains(node.getId()) && !nodeNamesWithAbsentId.contains(node.getName())) continue;
            return false;
        }
        return true;
    }

    private void scheduleReconfigurationIfNeeded() {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        assert (this.mode == Mode.LEADER) : this.mode;
        assert (!this.currentPublication.isPresent()) : "Expected no publication in progress";
        ClusterState state = this.getLastAcceptedState();
        if (this.improveConfiguration(state) != state && this.reconfigurationTaskScheduled.compareAndSet(false, true)) {
            logger.trace("scheduling reconfiguration");
            this.masterService.submitStateUpdateTask("reconfigure", new ClusterStateUpdateTask(Priority.URGENT){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public ClusterState execute(ClusterState currentState) {
                    Coordinator.this.reconfigurationTaskScheduled.set(false);
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        return Coordinator.this.improveConfiguration(currentState);
                    }
                }

                @Override
                public void onFailure(String source, Exception e) {
                    Coordinator.this.reconfigurationTaskScheduled.set(false);
                    logger.debug("reconfiguration failed", (Throwable)e);
                }
            });
        }
    }

    boolean missingJoinVoteFrom(DiscoveryNode node) {
        return node.isMasterNode() && !this.coordinationState.get().containsJoinVoteFor(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleJoin(Join join) {
        Object object = this.mutex;
        synchronized (object) {
            this.ensureTermAtLeast(this.getLocalNode(), join.getTerm()).ifPresent(this::handleJoin);
            if (this.coordinationState.get().electionWon()) {
                boolean establishedAsMaster;
                boolean isNewJoinFromMasterEligibleNode = this.handleJoinIgnoringExceptions(join);
                boolean bl = establishedAsMaster = this.mode == Mode.LEADER && this.getLastAcceptedState().term() == this.getCurrentTerm();
                if (isNewJoinFromMasterEligibleNode && establishedAsMaster && !this.publicationInProgress()) {
                    this.scheduleReconfigurationIfNeeded();
                }
            } else {
                this.coordinationState.get().handleJoin(join);
            }
        }
    }

    private boolean handleJoinIgnoringExceptions(Join join) {
        try {
            return this.coordinationState.get().handleJoin(join);
        }
        catch (CoordinationStateRejectedException e) {
            logger.debug(new ParameterizedMessage("failed to add {} - ignoring", (Object)join), (Throwable)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ClusterState getLastAcceptedState() {
        Object object = this.mutex;
        synchronized (object) {
            return this.coordinationState.get().getLastAcceptedState();
        }
    }

    @Nullable
    public ClusterState getApplierState() {
        return this.applierState;
    }

    private List<DiscoveryNode> getDiscoveredNodes() {
        ArrayList<DiscoveryNode> nodes = new ArrayList<DiscoveryNode>();
        nodes.add(this.getLocalNode());
        this.peerFinder.getFoundPeers().forEach(nodes::add);
        return nodes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ClusterState getStateForMasterService() {
        Object object = this.mutex;
        synchronized (object) {
            ClusterState clusterState = this.coordinationState.get().getLastAcceptedState();
            assert (clusterState.nodes().getLocalNode() != null);
            if (this.mode != Mode.LEADER || clusterState.term() != this.getCurrentTerm()) {
                return this.clusterStateWithNoMasterBlock(clusterState);
            }
            return clusterState;
        }
    }

    private ClusterState clusterStateWithNoMasterBlock(ClusterState clusterState) {
        if (clusterState.nodes().getMasterNodeId() != null) {
            assert (!clusterState.blocks().hasGlobalBlockWithId(2)) : "NO_MASTER_BLOCK should only be added by Coordinator";
            ClusterBlocks clusterBlocks = ClusterBlocks.builder().blocks(clusterState.blocks()).addGlobalBlock(this.noMasterBlockService.getNoMasterBlock()).build();
            DiscoveryNodes discoveryNodes = new DiscoveryNodes.Builder(clusterState.nodes()).masterNodeId(null).build();
            return ClusterState.builder(clusterState).blocks(clusterBlocks).nodes(discoveryNodes).build();
        }
        return clusterState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(ClusterChangedEvent clusterChangedEvent, ActionListener<Void> publishListener, ClusterStatePublisher.AckListener ackListener) {
        try {
            Object object = this.mutex;
            synchronized (object) {
                if (this.mode != Mode.LEADER || this.getCurrentTerm() != clusterChangedEvent.state().term()) {
                    logger.debug(() -> new ParameterizedMessage("[{}] failed publication as node is no longer master for term {}", (Object)clusterChangedEvent.source(), (Object)clusterChangedEvent.state().term()));
                    publishListener.onFailure(new FailedToCommitClusterStateException("node is no longer master for term " + clusterChangedEvent.state().term() + " while handling publication", new Object[0]));
                    return;
                }
                if (this.currentPublication.isPresent()) {
                    assert (false) : "[" + this.currentPublication.get() + "] in progress, cannot start new publication";
                    logger.warn(() -> new ParameterizedMessage("[{}] failed publication as already publication in progress", (Object)clusterChangedEvent.source()));
                    publishListener.onFailure(new FailedToCommitClusterStateException("publication " + this.currentPublication.get() + " already in progress", new Object[0]));
                    return;
                }
                assert (this.assertPreviousStateConsistency(clusterChangedEvent));
                ClusterState clusterState = clusterChangedEvent.state();
                assert (this.getLocalNode().equals(clusterState.getNodes().get(this.getLocalNode().getId()))) : this.getLocalNode() + " should be in published " + clusterState;
                PublicationTransportHandler.PublicationContext publicationContext = this.publicationHandler.newPublicationContext(clusterChangedEvent);
                PublishRequest publishRequest = this.coordinationState.get().handleClientValue(clusterState);
                CoordinatorPublication publication = new CoordinatorPublication(publishRequest, publicationContext, new ListenableFuture<Void>(), ackListener, publishListener);
                this.currentPublication = Optional.of(publication);
                DiscoveryNodes publishNodes = publishRequest.getAcceptedState().nodes();
                this.leaderChecker.setCurrentNodes(publishNodes);
                this.followersChecker.setCurrentNodes(publishNodes);
                this.lagDetector.setTrackedNodes(publishNodes);
                publication.start(this.followersChecker.getFaultyNodes());
            }
        }
        catch (Exception e) {
            logger.debug(() -> new ParameterizedMessage("[{}] publishing failed", (Object)clusterChangedEvent.source()), (Throwable)e);
            publishListener.onFailure(new FailedToCommitClusterStateException("publishing failed", (Throwable)e, new Object[0]));
        }
    }

    private boolean assertPreviousStateConsistency(ClusterChangedEvent event) {
        assert (event.previousState() == this.coordinationState.get().getLastAcceptedState() || XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, Strings.toString(event.previousState()), false).equals(XContentHelper.convertToMap((XContent)JsonXContent.jsonXContent, Strings.toString(this.clusterStateWithNoMasterBlock(this.coordinationState.get().getLastAcceptedState())), false))) : Strings.toString(event.previousState()) + " vs " + Strings.toString(this.clusterStateWithNoMasterBlock(this.coordinationState.get().getLastAcceptedState()));
        return true;
    }

    private <T> ActionListener<T> wrapWithMutex(final ActionListener<T> listener) {
        return new ActionListener<T>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onResponse(T t) {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    listener.onResponse(t);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onFailure(Exception e) {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    listener.onFailure(e);
                }
            }
        };
    }

    private void cancelActivePublication(String reason) {
        assert (Thread.holdsLock(this.mutex)) : "Coordinator mutex not held";
        if (this.currentPublication.isPresent()) {
            this.currentPublication.get().cancel(reason);
        }
    }

    public Collection<BiConsumer<DiscoveryNode, ClusterState>> getOnJoinValidators() {
        return this.onJoinValidators;
    }

    private void startElectionScheduler() {
        assert (this.electionScheduler == null) : this.electionScheduler;
        if (!this.getLocalNode().isMasterNode()) {
            return;
        }
        TimeValue gracePeriod = TimeValue.ZERO;
        this.electionScheduler = this.electionSchedulerFactory.startElectionScheduler(gracePeriod, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = Coordinator.this.mutex;
                synchronized (object) {
                    if (Coordinator.this.mode == Mode.CANDIDATE) {
                        ClusterState lastAcceptedState = ((CoordinationState)Coordinator.this.coordinationState.get()).getLastAcceptedState();
                        if (!Coordinator.localNodeMayWinElection(lastAcceptedState)) {
                            logger.trace("skip prevoting as local node may not win election: {}", (Object)lastAcceptedState.coordinationMetadata());
                            return;
                        }
                        StatusInfo statusInfo = Coordinator.this.nodeHealthService.getHealth();
                        if (statusInfo.getStatus() == StatusInfo.Status.UNHEALTHY) {
                            logger.debug("skip prevoting as local node is unhealthy: [{}]", (Object)statusInfo.getInfo());
                            return;
                        }
                        if (Coordinator.this.prevotingRound != null) {
                            Coordinator.this.prevotingRound.close();
                        }
                        List<DiscoveryNode> discoveredNodes = Coordinator.this.getDiscoveredNodes().stream().filter(n -> !Coordinator.isZen1Node(n)).collect(Collectors.toList());
                        Coordinator.this.prevotingRound = Coordinator.this.preVoteCollector.start(lastAcceptedState, discoveredNodes);
                    }
                }
            }

            public String toString() {
                return "scheduling of new prevoting round";
            }
        });
    }

    public Iterable<DiscoveryNode> getFoundPeers() {
        return this.peerFinder.getFoundPeers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean cancelCommittedPublication() {
        Object object = this.mutex;
        synchronized (object) {
            CoordinatorPublication publication;
            if (this.currentPublication.isPresent() && (publication = this.currentPublication.get()).isCommitted()) {
                publication.cancel("cancelCommittedPublication");
                logger.debug("Cancelled publication of [{}].", (Object)publication);
                return true;
            }
            return false;
        }
    }

    public static Settings.Builder addZen1Attribute(boolean isZen1Node, Settings.Builder builder) {
        return builder.put("node.attr.zen1", isZen1Node);
    }

    public static boolean isZen1Node(DiscoveryNode discoveryNode) {
        return discoveryNode.getVersion().before(Version.V_7_0_0) || Booleans.isTrue(discoveryNode.getAttributes().getOrDefault("zen1", "false"));
    }

    public static enum Mode {
        CANDIDATE,
        LEADER,
        FOLLOWER;

    }

    private class CoordinatorPeerFinder
    extends PeerFinder {
        CoordinatorPeerFinder(Settings settings, TransportService transportService, PeerFinder.TransportAddressConnector transportAddressConnector, PeerFinder.ConfiguredHostsResolver configuredHostsResolver) {
            super(settings, transportService, transportAddressConnector, Coordinator.this.singleNodeDiscovery ? hostsResolver -> Collections.emptyList() : configuredHostsResolver);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onActiveMasterFound(DiscoveryNode masterNode, long term) {
            Object object = Coordinator.this.mutex;
            synchronized (object) {
                Coordinator.this.ensureTermAtLeast(masterNode, term);
                Coordinator.this.joinHelper.sendJoinRequest(masterNode, this.getCurrentTerm(), Coordinator.joinWithDestination(Coordinator.this.lastJoin, masterNode, term));
            }
        }

        @Override
        protected void startProbe(TransportAddress transportAddress) {
            if (!Coordinator.this.singleNodeDiscovery) {
                super.startProbe(transportAddress);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void onFoundPeersUpdated() {
            Object object = Coordinator.this.mutex;
            synchronized (object) {
                Iterable<DiscoveryNode> foundPeers = this.getFoundPeers();
                if (Coordinator.this.mode == Mode.CANDIDATE) {
                    CoordinationState.VoteCollection expectedVotes = new CoordinationState.VoteCollection();
                    foundPeers.forEach(expectedVotes::addVote);
                    expectedVotes.addVote(Coordinator.this.getLocalNode());
                    boolean foundQuorum = ((CoordinationState)Coordinator.this.coordinationState.get()).isElectionQuorum(expectedVotes);
                    if (foundQuorum) {
                        if (Coordinator.this.electionScheduler == null) {
                            Coordinator.this.startElectionScheduler();
                        }
                    } else {
                        Coordinator.this.closePrevotingAndElectionScheduler();
                    }
                }
            }
            Coordinator.this.clusterBootstrapService.onFoundPeersUpdated();
        }
    }

    class CoordinatorPublication
    extends Publication {
        private final PublishRequest publishRequest;
        private final ListenableFuture<Void> localNodeAckEvent;
        private final ClusterStatePublisher.AckListener ackListener;
        private final ActionListener<Void> publishListener;
        private final PublicationTransportHandler.PublicationContext publicationContext;
        @Nullable
        private final Scheduler.ScheduledCancellable timeoutHandler;
        private final Scheduler.Cancellable infoTimeoutHandler;
        private final List<Join> receivedJoins;
        private boolean receivedJoinsProcessed;

        CoordinatorPublication(final PublishRequest publishRequest, PublicationTransportHandler.PublicationContext publicationContext, final ListenableFuture<Void> localNodeAckEvent, final ClusterStatePublisher.AckListener ackListener, ActionListener<Void> publishListener) {
            super(publishRequest, new ClusterStatePublisher.AckListener(){

                @Override
                public void onCommit(TimeValue commitTime) {
                    ackListener.onCommit(commitTime);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void onNodeAck(DiscoveryNode node, Exception e) {
                    if (node.equals(Coordinator.this.getLocalNode())) {
                        Object object = Coordinator.this.mutex;
                        synchronized (object) {
                            if (e == null) {
                                localNodeAckEvent.onResponse(null);
                            } else {
                                localNodeAckEvent.onFailure(e);
                            }
                        }
                    } else {
                        ackListener.onNodeAck(node, e);
                        if (e == null) {
                            Coordinator.this.lagDetector.setAppliedVersion(node, publishRequest.getAcceptedState().version());
                        }
                    }
                }
            }, Coordinator.this.transportService.getThreadPool()::relativeTimeInMillis);
            this.receivedJoins = new ArrayList<Join>();
            this.publishRequest = publishRequest;
            this.publicationContext = publicationContext;
            this.localNodeAckEvent = localNodeAckEvent;
            this.ackListener = ackListener;
            this.publishListener = publishListener;
            this.timeoutHandler = Coordinator.this.singleNodeDiscovery ? null : Coordinator.this.transportService.getThreadPool().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        CoordinatorPublication.this.cancel("timed out after " + Coordinator.this.publishTimeout);
                    }
                }

                public String toString() {
                    return "scheduled timeout for " + CoordinatorPublication.this;
                }
            }, Coordinator.this.publishTimeout, "generic");
            this.infoTimeoutHandler = Coordinator.this.transportService.getThreadPool().schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = Coordinator.this.mutex;
                    synchronized (object) {
                        CoordinatorPublication.this.logIncompleteNodes(Level.INFO);
                    }
                }

                public String toString() {
                    return "scheduled timeout for reporting on " + CoordinatorPublication.this;
                }
            }, Coordinator.this.publishInfoTimeout, "generic");
        }

        private void removePublicationAndPossiblyBecomeCandidate(String reason) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            assert (Coordinator.this.currentPublication.get() == this);
            Coordinator.this.currentPublication = Optional.empty();
            this.logger.debug("publication ended unsuccessfully: {}", (Object)this);
            if (this.isActiveForCurrentLeader()) {
                Coordinator.this.becomeCandidate(reason);
            }
        }

        boolean isActiveForCurrentLeader() {
            return Coordinator.this.mode == Mode.LEADER && this.publishRequest.getAcceptedState().term() == Coordinator.this.getCurrentTerm();
        }

        @Override
        protected void onCompletion(final boolean committed) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            this.localNodeAckEvent.addListener(new ActionListener<Void>(){

                @Override
                public void onResponse(Void ignore) {
                    assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
                    assert (committed);
                    CoordinatorPublication.this.receivedJoins.forEach(x$0 -> CoordinatorPublication.this.handleAssociatedJoin(x$0));
                    assert (!CoordinatorPublication.this.receivedJoinsProcessed);
                    CoordinatorPublication.this.receivedJoinsProcessed = true;
                    Coordinator.this.clusterApplier.onNewClusterState(CoordinatorPublication.this.toString(), () -> Coordinator.this.applierState, new ClusterApplier.ClusterApplyListener(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onFailure(String source, Exception e) {
                            Object object = Coordinator.this.mutex;
                            synchronized (object) {
                                CoordinatorPublication.this.removePublicationAndPossiblyBecomeCandidate("clusterApplier#onNewClusterState");
                            }
                            CoordinatorPublication.this.cancelTimeoutHandlers();
                            CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), e);
                            CoordinatorPublication.this.publishListener.onFailure(e);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void onSuccess(String source) {
                            Object object = Coordinator.this.mutex;
                            synchronized (object) {
                                assert (Coordinator.this.currentPublication.get() == CoordinatorPublication.this);
                                Coordinator.this.currentPublication = Optional.empty();
                                CoordinatorPublication.this.logger.debug("publication ended successfully: {}", (Object)CoordinatorPublication.this);
                                Coordinator.this.updateMaxTermSeen(Coordinator.this.getCurrentTerm());
                                if (Coordinator.this.mode == Mode.LEADER) {
                                    List masterCandidates;
                                    boolean attemptReconfiguration = true;
                                    ClusterState state = Coordinator.this.getLastAcceptedState();
                                    if (!Coordinator.localNodeMayWinElection(state) && !(masterCandidates = CoordinatorPublication.this.completedNodes().stream().filter(DiscoveryNode::isMasterNode).filter(node -> Coordinator.nodeMayWinElection(state, node)).filter(node -> {
                                        long futureElectionTerm = state.term() + 1L;
                                        CoordinationState.VoteCollection futureVoteCollection = new CoordinationState.VoteCollection();
                                        CoordinatorPublication.this.completedNodes().forEach(completedNode -> futureVoteCollection.addJoinVote(new Join((DiscoveryNode)completedNode, (DiscoveryNode)node, futureElectionTerm, state.term(), state.version())));
                                        return Coordinator.this.electionStrategy.isElectionQuorum((DiscoveryNode)node, futureElectionTerm, state.term(), state.version(), state.getLastCommittedConfiguration(), state.getLastAcceptedConfiguration(), futureVoteCollection);
                                    }).collect(Collectors.toList())).isEmpty()) {
                                        Coordinator.this.abdicateTo((DiscoveryNode)masterCandidates.get(Coordinator.this.random.nextInt(masterCandidates.size())));
                                        attemptReconfiguration = false;
                                    }
                                    if (attemptReconfiguration) {
                                        Coordinator.this.scheduleReconfigurationIfNeeded();
                                    }
                                }
                                Coordinator.this.lagDetector.startLagDetector(CoordinatorPublication.this.publishRequest.getAcceptedState().version());
                                CoordinatorPublication.this.logIncompleteNodes(Level.WARN);
                            }
                            CoordinatorPublication.this.cancelTimeoutHandlers();
                            CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), null);
                            CoordinatorPublication.this.publishListener.onResponse(null);
                        }
                    });
                }

                @Override
                public void onFailure(Exception e) {
                    assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
                    CoordinatorPublication.this.removePublicationAndPossiblyBecomeCandidate("Publication.onCompletion(false)");
                    CoordinatorPublication.this.cancelTimeoutHandlers();
                    FailedToCommitClusterStateException exception = new FailedToCommitClusterStateException("publication failed", (Throwable)e, new Object[0]);
                    CoordinatorPublication.this.ackListener.onNodeAck(Coordinator.this.getLocalNode(), exception);
                    CoordinatorPublication.this.publishListener.onFailure(exception);
                }
            }, EsExecutors.DIRECT_EXECUTOR_SERVICE, Coordinator.this.transportService.getThreadPool().getThreadContext());
        }

        private void cancelTimeoutHandlers() {
            if (this.timeoutHandler != null) {
                this.timeoutHandler.cancel();
            }
            this.infoTimeoutHandler.cancel();
        }

        private void handleAssociatedJoin(Join join) {
            if (join.getTerm() == Coordinator.this.getCurrentTerm() && Coordinator.this.missingJoinVoteFrom(join.getSourceNode())) {
                this.logger.trace("handling {}", (Object)join);
                Coordinator.this.handleJoin(join);
            }
        }

        @Override
        protected boolean isPublishQuorum(CoordinationState.VoteCollection votes) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            return ((CoordinationState)Coordinator.this.coordinationState.get()).isPublishQuorum(votes);
        }

        @Override
        protected Optional<ApplyCommitRequest> handlePublishResponse(DiscoveryNode sourceNode, PublishResponse publishResponse) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            assert (Coordinator.this.getCurrentTerm() >= publishResponse.getTerm());
            return ((CoordinationState)Coordinator.this.coordinationState.get()).handlePublishResponse(sourceNode, publishResponse);
        }

        @Override
        protected void onJoin(Join join) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            if (this.receivedJoinsProcessed) {
                this.handleAssociatedJoin(join);
            } else {
                this.receivedJoins.add(join);
            }
        }

        @Override
        protected void onMissingJoin(DiscoveryNode discoveryNode) {
            assert (Thread.holdsLock(Coordinator.this.mutex)) : "Coordinator mutex not held";
            if (Coordinator.this.missingJoinVoteFrom(discoveryNode)) {
                long term = this.publishRequest.getAcceptedState().term();
                this.logger.debug("onMissingJoin: no join vote from {}, bumping term to exceed {}", (Object)discoveryNode, (Object)term);
                Coordinator.this.updateMaxTermSeen(term + 1L);
            }
        }

        @Override
        protected void sendPublishRequest(DiscoveryNode destination, PublishRequest publishRequest, ActionListener<PublishWithJoinResponse> responseActionListener) {
            this.publicationContext.sendPublishRequest(destination, publishRequest, Coordinator.this.wrapWithMutex(responseActionListener));
        }

        @Override
        protected void sendApplyCommit(DiscoveryNode destination, ApplyCommitRequest applyCommit, ActionListener<TransportResponse.Empty> responseActionListener) {
            this.publicationContext.sendApplyCommit(destination, applyCommit, Coordinator.this.wrapWithMutex(responseActionListener));
        }
    }
}

