/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.fieldcaps;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.NoShardAvailableActionException;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexRequest;
import org.elasticsearch.action.fieldcaps.FieldCapabilitiesIndexResponse;
import org.elasticsearch.action.fieldcaps.IndexFieldCapabilities;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.GroupShardsIterator;
import org.elasticsearch.cluster.routing.ShardIterator;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.ObjectMapper;
import org.elasticsearch.index.mapper.RuntimeField;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.search.SearchService;
import org.elasticsearch.search.builder.SearchSourceBuilder;
import org.elasticsearch.search.internal.AliasFilter;
import org.elasticsearch.search.internal.ShardSearchRequest;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class TransportFieldCapabilitiesIndexAction
extends HandledTransportAction<FieldCapabilitiesIndexRequest, FieldCapabilitiesIndexResponse> {
    private static final Logger logger = LogManager.getLogger(TransportFieldCapabilitiesIndexAction.class);
    private static final String ACTION_NAME = "indices:data/read/field_caps[index]";
    private static final String ACTION_SHARD_NAME = "indices:data/read/field_caps[index][s]";
    public static final ActionType<FieldCapabilitiesIndexResponse> TYPE = new ActionType<FieldCapabilitiesIndexResponse>("indices:data/read/field_caps[index]", FieldCapabilitiesIndexResponse::new);
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final IndicesService indicesService;

    @Inject
    public TransportFieldCapabilitiesIndexAction(ClusterService clusterService, TransportService transportService, IndicesService indicesService, ActionFilters actionFilters) {
        super(ACTION_NAME, transportService, actionFilters, FieldCapabilitiesIndexRequest::new);
        this.clusterService = clusterService;
        this.transportService = transportService;
        this.indicesService = indicesService;
        transportService.registerRequestHandler(ACTION_SHARD_NAME, "same", FieldCapabilitiesIndexRequest::new, new ShardTransportHandler());
    }

    @Override
    protected void doExecute(Task task, FieldCapabilitiesIndexRequest request, ActionListener<FieldCapabilitiesIndexResponse> listener) {
        new AsyncShardsAction(this.transportService, this.clusterService, request, listener).start();
    }

    private FieldCapabilitiesIndexResponse shardOperation(FieldCapabilitiesIndexRequest request) throws IOException {
        ShardId shardId = request.shardId();
        IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
        IndexShard indexShard = indexService.getShard(request.shardId().getId());
        try (Engine.Searcher searcher = indexShard.acquireSearcher("can_match");){
            SearchExecutionContext searchExecutionContext = indexService.newSearchExecutionContext(shardId.id(), 0, searcher, request::nowInMillis, null, request.runtimeFields());
            if (!this.canMatchShard(request, searchExecutionContext)) {
                FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse = new FieldCapabilitiesIndexResponse(request.index(), Collections.emptyMap(), false);
                return fieldCapabilitiesIndexResponse;
            }
            HashSet<String> fieldNames = new HashSet<String>();
            for (String pattern : request.fields()) {
                fieldNames.addAll(searchExecutionContext.getMatchingFieldNames(pattern));
            }
            Predicate<String> fieldPredicate = this.indicesService.getFieldFilter().apply(shardId.getIndexName());
            HashMap<String, IndexFieldCapabilities> responseMap = new HashMap<String, IndexFieldCapabilities>();
            for (String field : fieldNames) {
                String parentField;
                MappedFieldType ft = searchExecutionContext.getFieldType(field);
                boolean isMetadataField = searchExecutionContext.isMetadataField(field);
                if (!isMetadataField && !fieldPredicate.test(ft.name())) continue;
                IndexFieldCapabilities fieldCap = new IndexFieldCapabilities(field, ft.familyTypeName(), isMetadataField, ft.isSearchable(), ft.isAggregatable(), ft.meta());
                responseMap.put(field, fieldCap);
                if (ft instanceof RuntimeField) continue;
                int dotIndex = ft.name().lastIndexOf(46);
                while (dotIndex > -1 && !responseMap.containsKey(parentField = ft.name().substring(0, dotIndex))) {
                    if (searchExecutionContext.getFieldType(parentField) == null) {
                        ObjectMapper mapper = searchExecutionContext.getObjectMapper(parentField);
                        String type = mapper.nested().isNested() ? "nested" : "object";
                        IndexFieldCapabilities fieldCap2 = new IndexFieldCapabilities(parentField, type, false, false, false, Collections.emptyMap());
                        responseMap.put(parentField, fieldCap2);
                    }
                    dotIndex = parentField.lastIndexOf(46);
                }
            }
            FieldCapabilitiesIndexResponse fieldCapabilitiesIndexResponse = new FieldCapabilitiesIndexResponse(request.index(), responseMap, true);
            return fieldCapabilitiesIndexResponse;
        }
    }

    private boolean canMatchShard(FieldCapabilitiesIndexRequest req, SearchExecutionContext searchExecutionContext) throws IOException {
        if (req.indexFilter() == null || req.indexFilter() instanceof MatchAllQueryBuilder) {
            return true;
        }
        assert (req.nowInMillis() != 0L);
        ShardSearchRequest searchRequest = new ShardSearchRequest(req.shardId(), null, req.nowInMillis(), AliasFilter.EMPTY);
        searchRequest.source(new SearchSourceBuilder().query(req.indexFilter()));
        return SearchService.queryStillMatchesAfterRewrite(searchRequest, searchExecutionContext);
    }

    private static ClusterBlockException checkGlobalBlock(ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.READ);
    }

    private static ClusterBlockException checkRequestBlock(ClusterState state, String concreteIndex) {
        return state.blocks().indexBlockedException(ClusterBlockLevel.READ, concreteIndex);
    }

    private class ShardTransportHandler
    implements TransportRequestHandler<FieldCapabilitiesIndexRequest> {
        private ShardTransportHandler() {
        }

        @Override
        public void messageReceived(FieldCapabilitiesIndexRequest request, TransportChannel channel, Task task) throws Exception {
            FieldCapabilitiesIndexResponse resp;
            if (logger.isTraceEnabled()) {
                logger.trace("executing [{}]", (Object)request);
            }
            ChannelActionListener<FieldCapabilitiesIndexResponse, FieldCapabilitiesIndexRequest> listener = new ChannelActionListener<FieldCapabilitiesIndexResponse, FieldCapabilitiesIndexRequest>(channel, TransportFieldCapabilitiesIndexAction.ACTION_SHARD_NAME, request);
            try {
                resp = TransportFieldCapabilitiesIndexAction.this.shardOperation(request);
            }
            catch (Exception exc) {
                listener.onFailure(exc);
                return;
            }
            listener.onResponse(resp);
        }
    }

    public static class AsyncShardsAction {
        private final FieldCapabilitiesIndexRequest request;
        private final TransportService transportService;
        private final DiscoveryNodes nodes;
        private final ActionListener<FieldCapabilitiesIndexResponse> listener;
        private final GroupShardsIterator<ShardIterator> shardsIt;
        private volatile int shardIndex = 0;

        public AsyncShardsAction(TransportService transportService, ClusterService clusterService, FieldCapabilitiesIndexRequest request, ActionListener<FieldCapabilitiesIndexResponse> listener) {
            this.listener = listener;
            this.transportService = transportService;
            ClusterState clusterState = clusterService.state();
            if (logger.isTraceEnabled()) {
                logger.trace("executing [{}] based on cluster state version [{}]", (Object)request, (Object)clusterState.version());
            }
            this.nodes = clusterState.nodes();
            ClusterBlockException blockException = TransportFieldCapabilitiesIndexAction.checkGlobalBlock(clusterState);
            if (blockException != null) {
                throw blockException;
            }
            this.request = request;
            blockException = TransportFieldCapabilitiesIndexAction.checkRequestBlock(clusterState, request.index());
            if (blockException != null) {
                throw blockException;
            }
            this.shardsIt = clusterService.operationRouting().searchShards(clusterService.state(), new String[]{request.index()}, null, null, null, null);
        }

        public void start() {
            this.tryNext(null, true);
        }

        private void onFailure(ShardRouting shardRouting, Exception e) {
            if (e != null) {
                logger.trace(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)shardRouting, (Object)this.request), (Throwable)e);
            }
            this.tryNext(e, false);
        }

        private ShardRouting nextRoutingOrNull() {
            if (this.shardsIt.size() == 0 || this.shardIndex >= this.shardsIt.size()) {
                return null;
            }
            ShardRouting next = this.shardsIt.get(this.shardIndex).nextOrNull();
            if (next != null) {
                return next;
            }
            this.moveToNextShard();
            return this.nextRoutingOrNull();
        }

        private void moveToNextShard() {
            ++this.shardIndex;
        }

        private void tryNext(@Nullable Exception lastFailure, boolean canMatchShard) {
            final ShardRouting shardRouting = this.nextRoutingOrNull();
            if (shardRouting == null) {
                if (!canMatchShard) {
                    if (lastFailure == null) {
                        this.listener.onResponse(new FieldCapabilitiesIndexResponse(this.request.index(), Collections.emptyMap(), false));
                    } else {
                        logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)null, (Object)this.request), (Throwable)lastFailure);
                        this.listener.onFailure(lastFailure);
                    }
                } else if (lastFailure == null || TransportActions.isShardNotAvailableException(lastFailure)) {
                    this.listener.onFailure(new NoShardAvailableActionException(null, LoggerMessageFormat.format("No shard available for [{}]", this.request), lastFailure));
                } else {
                    logger.debug(() -> new ParameterizedMessage("{}: failed to execute [{}]", (Object)null, (Object)this.request), (Throwable)lastFailure);
                    this.listener.onFailure(lastFailure);
                }
                return;
            }
            DiscoveryNode node = this.nodes.get(shardRouting.currentNodeId());
            if (node == null) {
                this.onFailure(shardRouting, new NoShardAvailableActionException(shardRouting.shardId()));
            } else {
                this.request.shardId(shardRouting.shardId());
                if (logger.isTraceEnabled()) {
                    logger.trace("sending request [{}] on node [{}]", (Object)this.request, (Object)node);
                }
                this.transportService.sendRequest(node, TransportFieldCapabilitiesIndexAction.ACTION_SHARD_NAME, this.request, new TransportResponseHandler<FieldCapabilitiesIndexResponse>(){

                    @Override
                    public FieldCapabilitiesIndexResponse read(StreamInput in) throws IOException {
                        return new FieldCapabilitiesIndexResponse(in);
                    }

                    @Override
                    public void handleResponse(FieldCapabilitiesIndexResponse response) {
                        if (response.canMatch()) {
                            listener.onResponse(response);
                        } else {
                            this.moveToNextShard();
                            this.tryNext(null, false);
                        }
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        this.onFailure(shardRouting, exp);
                    }
                });
            }
        }
    }
}

