/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.get;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.StepListener;
import org.elasticsearch.action.admin.cluster.repositories.get.TransportGetRepositoriesAction;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.repositories.GetSnapshotInfoContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryMissingException;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.snapshots.Snapshot;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotMissingException;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetSnapshotsAction
extends TransportMasterNodeAction<GetSnapshotsRequest, GetSnapshotsResponse> {
    private static final Logger logger = LogManager.getLogger(TransportGetSnapshotsAction.class);
    private final RepositoriesService repositoriesService;
    private static final Comparator<SnapshotInfo> BY_START_TIME = Comparator.comparingLong(SnapshotInfo::startTime).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_DURATION = Comparator.comparingLong(sni -> sni.endTime() - sni.startTime()).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_INDICES_COUNT = Comparator.comparingInt(sni -> sni.indices().size()).thenComparing(SnapshotInfo::snapshotId);
    private static final Comparator<SnapshotInfo> BY_NAME = Comparator.comparing(sni -> sni.snapshotId().getName());

    @Inject
    public TransportGetSnapshotsAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RepositoriesService repositoriesService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/snapshot/get", transportService, clusterService, threadPool, actionFilters, GetSnapshotsRequest::new, indexNameExpressionResolver, GetSnapshotsResponse::new, "same");
        this.repositoriesService = repositoriesService;
    }

    @Override
    protected ClusterBlockException checkBlock(GetSnapshotsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }

    @Override
    protected void masterOperation(GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) throws Exception {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, GetSnapshotsRequest request, ClusterState state, ActionListener<GetSnapshotsResponse> listener) {
        assert (task instanceof CancellableTask) : task + " not cancellable";
        this.getMultipleReposSnapshotInfo(!request.isSingleRepositoryRequest(), state.custom("snapshots", SnapshotsInProgress.EMPTY), TransportGetRepositoriesAction.getRepositories(state, request.repositories()), request.snapshots(), request.ignoreUnavailable(), request.verbose(), (CancellableTask)task, request.sort(), request.after(), request.size(), request.order(), listener);
    }

    private void getMultipleReposSnapshotInfo(boolean isMultiRepoRequest, SnapshotsInProgress snapshotsInProgress, List<RepositoryMetadata> repos, String[] snapshots, boolean ignoreUnavailable, boolean verbose, CancellableTask cancellableTask, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order, ActionListener<GetSnapshotsResponse> listener) {
        if (repos.isEmpty()) {
            listener.onResponse(new GetSnapshotsResponse(Collections.emptyList(), Collections.emptyMap(), null));
            return;
        }
        GroupedActionListener groupedActionListener = new GroupedActionListener(listener.map(responses -> {
            assert (repos.size() == responses.size());
            List<SnapshotInfo> allSnapshots = responses.stream().map(Tuple::v2).filter(Objects::nonNull).flatMap(snapshotsInRepo -> ((SnapshotsInRepo)snapshotsInRepo).snapshotInfos.stream()).collect(Collectors.toList());
            Map<String, ElasticsearchException> failures = responses.stream().map(Tuple::v1).filter(Objects::nonNull).collect(Collectors.toMap(Tuple::v1, Tuple::v2));
            SnapshotsInRepo snInfos = TransportGetSnapshotsAction.sortSnapshots(allSnapshots, sortBy, after, size, order);
            List snapshotInfos = snInfos.snapshotInfos;
            return new GetSnapshotsResponse(snapshotInfos, failures, snInfos.hasMore || responses.stream().anyMatch(r -> r.v2() != null && ((SnapshotsInRepo)r.v2()).hasMore) ? GetSnapshotsRequest.After.from((SnapshotInfo)snapshotInfos.get(snapshotInfos.size() - 1), sortBy).asQueryParam() : null);
        }), repos.size());
        for (RepositoryMetadata repo : repos) {
            String repoName = repo.name();
            this.getSingleRepoSnapshotInfo(snapshotsInProgress, repoName, snapshots, ignoreUnavailable, verbose, cancellableTask, sortBy, after, size, order, groupedActionListener.delegateResponse((groupedListener, e) -> {
                if (isMultiRepoRequest && e instanceof ElasticsearchException) {
                    groupedListener.onResponse(Tuple.tuple(Tuple.tuple(repoName, (ElasticsearchException)e), null));
                } else {
                    groupedListener.onFailure((Exception)e);
                }
            }).map(snInfos -> Tuple.tuple(null, snInfos)));
        }
    }

    private void getSingleRepoSnapshotInfo(SnapshotsInProgress snapshotsInProgress, String repo, String[] snapshots, boolean ignoreUnavailable, boolean verbose, CancellableTask task, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order, ActionListener<SnapshotsInRepo> listener) {
        HashMap<String, Snapshot> allSnapshotIds = new HashMap<String, Snapshot>();
        ArrayList<SnapshotInfo> currentSnapshots = new ArrayList<SnapshotInfo>();
        for (SnapshotInfo snapshotInfo : TransportGetSnapshotsAction.sortedCurrentSnapshots(snapshotsInProgress, repo, sortBy, after, size, order).snapshotInfos) {
            Snapshot snapshot = snapshotInfo.snapshot();
            allSnapshotIds.put(snapshot.getSnapshotId().getName(), snapshot);
            currentSnapshots.add(snapshotInfo);
        }
        StepListener<RepositoryData> repositoryDataListener = new StepListener<RepositoryData>();
        if (this.isCurrentSnapshotsOnly(snapshots)) {
            repositoryDataListener.onResponse(null);
        } else {
            this.repositoriesService.getRepositoryData(repo, repositoryDataListener);
        }
        repositoryDataListener.whenComplete(repositoryData -> this.loadSnapshotInfos(snapshotsInProgress, repo, snapshots, ignoreUnavailable, verbose, (Map<String, Snapshot>)allSnapshotIds, (List<SnapshotInfo>)currentSnapshots, (RepositoryData)repositoryData, task, sortBy, after, size, order, listener), listener::onFailure);
    }

    private static SnapshotsInRepo sortedCurrentSnapshots(SnapshotsInProgress snapshotsInProgress, String repositoryName, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order) {
        ArrayList<SnapshotInfo> snapshotList = new ArrayList<SnapshotInfo>();
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, Collections.emptyList());
        for (SnapshotsInProgress.Entry entry : entries) {
            snapshotList.add(new SnapshotInfo(entry));
        }
        return TransportGetSnapshotsAction.sortSnapshots(snapshotList, sortBy, after, size, order);
    }

    /*
     * WARNING - void declaration
     */
    private void loadSnapshotInfos(SnapshotsInProgress snapshotsInProgress, String repo, String[] snapshots, boolean ignoreUnavailable, boolean verbose, Map<String, Snapshot> allSnapshotIds, List<SnapshotInfo> currentSnapshots, @Nullable RepositoryData repositoryData, CancellableTask task, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order, ActionListener<SnapshotsInRepo> listener) {
        if (task.isCancelled()) {
            listener.onFailure(new TaskCancelledException("task cancelled"));
            return;
        }
        if (repositoryData != null) {
            for (SnapshotId snapshotId : repositoryData.getSnapshotIds()) {
                allSnapshotIds.put(snapshotId.getName(), new Snapshot(repo, snapshotId));
            }
        }
        HashSet<Snapshot> toResolve = new HashSet<Snapshot>();
        if (this.isAllSnapshots(snapshots)) {
            toResolve.addAll(allSnapshotIds.values());
        } else {
            for (String snapshotOrPattern : snapshots) {
                if ("_current".equalsIgnoreCase(snapshotOrPattern)) {
                    toResolve.addAll(currentSnapshots.stream().map(SnapshotInfo::snapshot).collect(Collectors.toList()));
                    continue;
                }
                if (!Regex.isSimpleMatchPattern(snapshotOrPattern)) {
                    if (allSnapshotIds.containsKey(snapshotOrPattern)) {
                        toResolve.add(allSnapshotIds.get(snapshotOrPattern));
                        continue;
                    }
                    if (ignoreUnavailable) continue;
                    throw new SnapshotMissingException(repo, snapshotOrPattern);
                }
                for (Map.Entry<String, Snapshot> entry : allSnapshotIds.entrySet()) {
                    if (!Regex.simpleMatch(snapshotOrPattern, entry.getKey())) continue;
                    toResolve.add(entry.getValue());
                }
            }
            if (toResolve.isEmpty() && !ignoreUnavailable && !this.isCurrentSnapshotsOnly(snapshots)) {
                throw new SnapshotMissingException(repo, snapshots[0]);
            }
        }
        if (verbose) {
            this.snapshots(snapshotsInProgress, repo, Collections.unmodifiableList(toResolve.stream().map(Snapshot::getSnapshotId).collect(Collectors.toList())), ignoreUnavailable, task, sortBy, after, size, order, listener);
        } else {
            void var16_21;
            if (repositoryData != null) {
                SnapshotsInRepo snapshotsInRepo = TransportGetSnapshotsAction.buildSimpleSnapshotInfos(toResolve, repo, repositoryData, currentSnapshots, sortBy, after, size, order);
            } else {
                SnapshotsInRepo snapshotsInRepo = TransportGetSnapshotsAction.sortSnapshots(currentSnapshots.stream().map(SnapshotInfo::basic).collect(Collectors.toList()), sortBy, after, size, order);
            }
            listener.onResponse((SnapshotsInRepo)var16_21);
        }
    }

    private void snapshots(SnapshotsInProgress snapshotsInProgress, String repositoryName, Collection<SnapshotId> snapshotIds, boolean ignoreUnavailable, CancellableTask task, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order, ActionListener<SnapshotsInRepo> listener) {
        Repository repository;
        if (task.isCancelled()) {
            listener.onFailure(new TaskCancelledException("task cancelled"));
            return;
        }
        HashSet<SnapshotInfo> snapshotSet = new HashSet<SnapshotInfo>();
        final HashSet<SnapshotId> snapshotIdsToIterate = new HashSet<SnapshotId>(snapshotIds);
        List<SnapshotsInProgress.Entry> entries = SnapshotsService.currentSnapshots(snapshotsInProgress, repositoryName, snapshotIdsToIterate.stream().map(SnapshotId::getName).collect(Collectors.toList()));
        for (SnapshotsInProgress.Entry entry : entries) {
            if (!snapshotIdsToIterate.remove(entry.snapshot().getSnapshotId())) continue;
            snapshotSet.add(new SnapshotInfo(entry));
        }
        List<Object> snapshotInfos = snapshotIdsToIterate.isEmpty() ? Collections.emptyList() : Collections.synchronizedList(new ArrayList());
        ActionListener<Void> allDoneListener = listener.delegateFailure((l, v) -> {
            ArrayList<SnapshotInfo> snapshotList = new ArrayList<SnapshotInfo>(snapshotInfos);
            snapshotList.addAll(snapshotSet);
            listener.onResponse(TransportGetSnapshotsAction.sortSnapshots(snapshotList, sortBy, after, size, order));
        });
        if (snapshotIdsToIterate.isEmpty()) {
            allDoneListener.onResponse(null);
            return;
        }
        try {
            repository = this.repositoriesService.repository(repositoryName);
        }
        catch (RepositoryMissingException e) {
            listener.onFailure(e);
            return;
        }
        repository.getSnapshotInfo(new GetSnapshotInfoContext(snapshotIdsToIterate, !ignoreUnavailable, task::isCancelled, (context, snapshotInfo) -> snapshotInfos.add(snapshotInfo), ignoreUnavailable ? ActionListener.runAfter(new ActionListener<Void>(){

            @Override
            public void onResponse(Void unused) {
                logger.trace("done fetching snapshot infos [{}]", (Object)snapshotIdsToIterate);
            }

            @Override
            public void onFailure(Exception e) {
                assert (false) : new AssertionError("listener should always complete successfully for ignoreUnavailable=true", e);
                logger.warn("failed to fetch snapshot info for some snapshots", (Throwable)e);
            }
        }, () -> allDoneListener.onResponse(null)) : allDoneListener));
    }

    private boolean isAllSnapshots(String[] snapshots) {
        return snapshots.length == 0 || snapshots.length == 1 && "_all".equalsIgnoreCase(snapshots[0]);
    }

    private boolean isCurrentSnapshotsOnly(String[] snapshots) {
        return snapshots.length == 1 && "_current".equalsIgnoreCase(snapshots[0]);
    }

    private static SnapshotsInRepo buildSimpleSnapshotInfos(Set<Snapshot> toResolve, String repoName, RepositoryData repositoryData, List<SnapshotInfo> currentSnapshots, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order) {
        ArrayList<SnapshotInfo> snapshotInfos = new ArrayList<SnapshotInfo>();
        for (SnapshotInfo snapshotInfo : currentSnapshots) {
            if (!toResolve.remove(snapshotInfo.snapshot())) continue;
            snapshotInfos.add(snapshotInfo.basic());
        }
        HashMap snapshotsToIndices = new HashMap();
        for (IndexId indexId : repositoryData.getIndices().values()) {
            for (SnapshotId snapshotId : repositoryData.getSnapshots(indexId)) {
                if (!toResolve.contains(new Snapshot(repoName, snapshotId))) continue;
                snapshotsToIndices.computeIfAbsent(snapshotId, k -> new ArrayList()).add(indexId.getName());
            }
        }
        for (Snapshot snapshot : toResolve) {
            List<String> indices = snapshotsToIndices.getOrDefault(snapshot.getSnapshotId(), Collections.emptyList());
            CollectionUtil.timSort(indices);
            snapshotInfos.add(new SnapshotInfo(snapshot, indices, Collections.emptyList(), Collections.emptyList(), repositoryData.getSnapshotState(snapshot.getSnapshotId())));
        }
        return TransportGetSnapshotsAction.sortSnapshots(snapshotInfos, sortBy, after, size, order);
    }

    private static SnapshotsInRepo sortSnapshots(List<SnapshotInfo> snapshotInfos, GetSnapshotsRequest.SortBy sortBy, @Nullable GetSnapshotsRequest.After after, int size, SortOrder order) {
        Comparator<SnapshotInfo> comparator;
        switch (sortBy) {
            case START_TIME: {
                comparator = BY_START_TIME;
                break;
            }
            case NAME: {
                comparator = BY_NAME;
                break;
            }
            case DURATION: {
                comparator = BY_DURATION;
                break;
            }
            case INDICES: {
                comparator = BY_INDICES_COUNT;
                break;
            }
            default: {
                throw new AssertionError((Object)("unexpected sort column [" + (Object)((Object)sortBy) + "]"));
            }
        }
        Stream<Object> infos = snapshotInfos.stream();
        if (after != null) {
            Predicate<SnapshotInfo> isAfter;
            String snapshotName = after.snapshotName();
            String repoName = after.repoName();
            switch (sortBy) {
                case START_TIME: {
                    isAfter = TransportGetSnapshotsAction.filterByLongOffset(SnapshotInfo::startTime, Long.parseLong(after.value()), snapshotName, repoName, order);
                    break;
                }
                case NAME: {
                    isAfter = order == SortOrder.ASC ? info -> TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) < 0 : info -> TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) > 0;
                    break;
                }
                case DURATION: {
                    isAfter = TransportGetSnapshotsAction.filterByLongOffset(info -> info.endTime() - info.startTime(), Long.parseLong(after.value()), snapshotName, repoName, order);
                    break;
                }
                case INDICES: {
                    isAfter = TransportGetSnapshotsAction.filterByLongOffset(info -> info.indices().size(), Integer.parseInt(after.value()), snapshotName, repoName, order);
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unexpected sort column [" + (Object)((Object)sortBy) + "]"));
                }
            }
            infos = infos.filter(isAfter);
        }
        infos = infos.sorted(order == SortOrder.DESC ? comparator.reversed() : comparator);
        if (size != -1) {
            infos = infos.limit(size + 1);
        }
        List<SnapshotInfo> snapshots = Collections.unmodifiableList(infos.collect(Collectors.toList()));
        boolean hasMore = size != -1 && size < snapshots.size();
        return new SnapshotsInRepo(hasMore ? snapshots.subList(0, size) : snapshots, hasMore);
    }

    private static Predicate<SnapshotInfo> filterByLongOffset(ToLongFunction<SnapshotInfo> extractor, long after, String snapshotName, String repoName, SortOrder order) {
        return order == SortOrder.ASC ? info -> {
            long val = extractor.applyAsLong((SnapshotInfo)info);
            return after < val || after == val && TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) < 0;
        } : info -> {
            long val = extractor.applyAsLong((SnapshotInfo)info);
            return after > val || after == val && TransportGetSnapshotsAction.compareName(snapshotName, repoName, info) > 0;
        };
    }

    private static int compareName(String name, String repoName, SnapshotInfo info) {
        int res = name.compareTo(info.snapshotId().getName());
        if (res != 0) {
            return res;
        }
        return repoName.compareTo(info.repository());
    }

    private static final class SnapshotsInRepo {
        private final boolean hasMore;
        private final List<SnapshotInfo> snapshotInfos;

        SnapshotsInRepo(List<SnapshotInfo> snapshotInfos, boolean hasMore) {
            this.hasMore = hasMore;
            this.snapshotInfos = snapshotInfos;
        }
    }
}

