/*
 * Decompiled with CFR 0.152.
 */
package com.unboundid.ldap.sdk.persist;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.persist.LDAPObject;
import com.unboundid.ldap.sdk.persist.LDAPPersistException;
import com.unboundid.ldap.sdk.persist.LDAPSetter;
import com.unboundid.ldap.sdk.persist.ObjectEncoder;
import com.unboundid.ldap.sdk.persist.PersistMessages;
import com.unboundid.util.Debug;
import com.unboundid.util.NotMutable;
import com.unboundid.util.StaticUtils;
import com.unboundid.util.ThreadSafety;
import com.unboundid.util.ThreadSafetyLevel;
import com.unboundid.util.Validator;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;

@NotMutable
@ThreadSafety(level=ThreadSafetyLevel.COMPLETELY_THREADSAFE)
public final class SetterInfo
implements Serializable {
    private static final long serialVersionUID = -1743750276508505946L;
    private final boolean failOnInvalidValue;
    private final boolean failOnTooManyValues;
    private final boolean supportsMultipleValues;
    private final Class<?> containingClass;
    private final Method method;
    private final ObjectEncoder encoder;
    private final String attributeName;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    SetterInfo(Method m, Class<?> c) throws LDAPPersistException {
        Validator.ensureNotNull(m, c);
        this.method = m;
        m.setAccessible(true);
        LDAPSetter a = m.getAnnotation(LDAPSetter.class);
        if (a == null) {
            throw new LDAPPersistException(PersistMessages.ERR_SETTER_INFO_METHOD_NOT_ANNOTATED.get(m.getName(), c.getName()));
        }
        LDAPObject o = c.getAnnotation(LDAPObject.class);
        if (o == null) {
            throw new LDAPPersistException(PersistMessages.ERR_SETTER_INFO_CLASS_NOT_ANNOTATED.get(c.getName()));
        }
        this.containingClass = c;
        this.failOnInvalidValue = a.failOnInvalidValue();
        Type[] params = m.getGenericParameterTypes();
        if (params.length != 1) {
            throw new LDAPPersistException(PersistMessages.ERR_SETTER_INFO_METHOD_DOES_NOT_TAKE_ONE_ARGUMENT.get(m.getName(), c.getName()));
        }
        try {
            this.encoder = a.encoderClass().newInstance();
        }
        catch (Exception e) {
            Debug.debugException(e);
            throw new LDAPPersistException(PersistMessages.ERR_SETTER_INFO_CANNOT_GET_ENCODER.get(a.encoderClass().getName(), m.getName(), c.getName(), StaticUtils.getExceptionMessage(e)), (Throwable)e);
        }
        if (!this.encoder.supportsType(params[0])) {
            throw new LDAPPersistException(PersistMessages.ERR_SETTER_INFO_ENCODER_UNSUPPORTED_TYPE.get(this.encoder.getClass().getName(), m.getName(), c.getName(), String.valueOf(params[0])));
        }
        this.supportsMultipleValues = this.encoder.supportsMultipleValues(m);
        this.failOnTooManyValues = this.supportsMultipleValues ? false : a.failOnTooManyValues();
        String attrName = a.attribute();
        if (attrName == null || attrName.isEmpty()) {
            String methodName = m.getName();
            if (!methodName.startsWith("set") || methodName.length() < 4) throw new LDAPPersistException(PersistMessages.ERR_SETTER_INFO_CANNOT_INFER_ATTR.get(methodName, c.getName()));
            this.attributeName = StaticUtils.toInitialLowerCase(methodName.substring(3));
            return;
        } else {
            this.attributeName = attrName;
        }
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getContainingClass() {
        return this.containingClass;
    }

    public boolean failOnInvalidValue() {
        return this.failOnInvalidValue;
    }

    public boolean failOnTooManyValues() {
        return this.failOnTooManyValues;
    }

    public ObjectEncoder getEncoder() {
        return this.encoder;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public boolean supportsMultipleValues() {
        return this.supportsMultipleValues;
    }

    boolean invokeSetter(Object o, Entry e, List<String> failureReasons) {
        boolean successful;
        block6: {
            successful = true;
            Attribute a = e.getAttribute(this.attributeName);
            if (a == null || !a.hasValue()) {
                try {
                    this.encoder.setNull(this.method, o);
                }
                catch (LDAPPersistException lpe) {
                    Debug.debugException(lpe);
                    successful = false;
                    failureReasons.add(lpe.getMessage());
                }
                return successful;
            }
            if (this.failOnTooManyValues && a.size() > 1) {
                successful = false;
                failureReasons.add(PersistMessages.ERR_SETTER_INFO_METHOD_NOT_MULTIVALUED.get(this.method.getName(), a.getName(), this.containingClass.getName()));
            }
            try {
                this.encoder.invokeSetter(this.method, o, a);
            }
            catch (LDAPPersistException lpe) {
                Debug.debugException(lpe);
                if (!this.failOnInvalidValue) break block6;
                successful = false;
                failureReasons.add(lpe.getMessage());
            }
        }
        return successful;
    }
}

