/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.geoip;

import com.maxmind.geoip2.model.AbstractResponse;
import java.net.InetAddress;
import java.nio.file.Path;
import java.util.Objects;
import java.util.function.Function;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;

final class GeoIpCache {
    private final Cache<CacheKey, AbstractResponse> cache;

    GeoIpCache(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException("geoip max cache size must be 0 or greater");
        }
        this.cache = CacheBuilder.builder().setMaximumWeight(maxSize).build();
    }

    <T extends AbstractResponse> T putIfAbsent(InetAddress ip, String databasePath, Function<InetAddress, AbstractResponse> retrieveFunction) {
        CacheKey cacheKey = new CacheKey(ip, databasePath);
        AbstractResponse response = (AbstractResponse)this.cache.get((Object)cacheKey);
        if (response == null) {
            response = retrieveFunction.apply(ip);
            this.cache.put((Object)cacheKey, (Object)response);
        }
        return (T)response;
    }

    AbstractResponse get(InetAddress ip, String databasePath) {
        CacheKey cacheKey = new CacheKey(ip, databasePath);
        return (AbstractResponse)this.cache.get((Object)cacheKey);
    }

    public int purgeCacheEntriesForDatabase(Path databaseFile) {
        String databasePath = databaseFile.toString();
        int counter = 0;
        for (CacheKey key : this.cache.keys()) {
            if (!key.databasePath.equals(databasePath)) continue;
            this.cache.invalidate((Object)key);
            ++counter;
        }
        return counter;
    }

    public int count() {
        return this.cache.count();
    }

    private static class CacheKey {
        private final InetAddress ip;
        private final String databasePath;

        private CacheKey(InetAddress ip, String databasePath) {
            this.ip = ip;
            this.databasePath = databasePath;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.ip, cacheKey.ip) && Objects.equals(this.databasePath, cacheKey.databasePath);
        }

        public int hashCode() {
            return Objects.hash(this.ip, this.databasePath);
        }
    }
}

