/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.logstash;

import java.time.Instant;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.ParseField;

public class Pipeline {
    public static final ConstructingObjectParser<Pipeline, String> PARSER = new ConstructingObjectParser("pipeline", true, (objects, id) -> {
        Iterator<Object> iterator = Arrays.asList(objects).iterator();
        return new Pipeline((String)id, (Instant)iterator.next(), (Map)iterator.next(), (String)iterator.next(), (String)iterator.next(), (Map)iterator.next());
    });
    public static final ParseField LAST_MODIFIED = new ParseField("last_modified", new String[0]);
    public static final ParseField PIPELINE_METADATA = new ParseField("pipeline_metadata", new String[0]);
    public static final ParseField USERNAME = new ParseField("username", new String[0]);
    public static final ParseField PIPELINE = new ParseField("pipeline", new String[0]);
    public static final ParseField PIPELINE_SETTINGS = new ParseField("pipeline_settings", new String[0]);
    private final String id;
    private final Instant lastModified;
    private final Map<String, Object> pipelineMetadata;
    private final String username;
    private final String pipeline;
    private final Map<String, Object> pipelineSettings;

    public Pipeline(String id, Instant lastModified, Map<String, Object> pipelineMetadata, String username, String pipeline, Map<String, Object> pipelineSettings) {
        this.id = id;
        this.lastModified = lastModified;
        this.pipelineMetadata = pipelineMetadata;
        this.username = username;
        this.pipeline = pipeline;
        this.pipelineSettings = pipelineSettings;
    }

    public String getId() {
        return this.id;
    }

    public Instant getLastModified() {
        return this.lastModified;
    }

    public Map<String, Object> getPipelineMetadata() {
        return this.pipelineMetadata;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPipeline() {
        return this.pipeline;
    }

    public Map<String, Object> getPipelineSettings() {
        return this.pipelineSettings;
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), (parser, s) -> {
            String instantISOString = parser.text();
            return Instant.parse(instantISOString);
        }, LAST_MODIFIED, ObjectParser.ValueType.STRING);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, s) -> parser.map(), PIPELINE_METADATA);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), USERNAME);
        PARSER.declareString(ConstructingObjectParser.constructorArg(), PIPELINE);
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), (parser, s) -> parser.map(), PIPELINE_SETTINGS);
    }
}

