/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.message.BasicHeader;
import org.apache.http.nio.conn.ssl.SSLIOSessionStrategy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.RestClientBuilder;
import org.elasticsearch.client.sniff.ElasticsearchNodesSniffer;
import org.elasticsearch.client.sniff.NodesSniffer;
import org.elasticsearch.client.sniff.Sniffer;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.settings.SecureSetting;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.monitoring.Monitoring;
import org.elasticsearch.xpack.monitoring.exporter.ClusterAlertsUtil;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringMigrationCoordinator;
import org.elasticsearch.xpack.monitoring.exporter.http.ClusterAlertHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpHostBuilder;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.MultiHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.NodeFailureListener;
import org.elasticsearch.xpack.monitoring.exporter.http.PipelineHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.SecurityHttpClientConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.TemplateHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.TimeoutRequestConfigCallback;
import org.elasticsearch.xpack.monitoring.exporter.http.VersionHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.WatcherExistsHttpResource;

public class HttpExporter
extends Exporter {
    private static final Logger logger = LogManager.getLogger(HttpExporter.class);
    public static final String TYPE = "http";
    private static Setting.AffixSettingDependency HTTP_TYPE_DEPENDENCY = new Setting.AffixSettingDependency(){

        public Setting.AffixSetting<String> getSetting() {
            return Exporter.TYPE_SETTING;
        }

        public void validate(String key, Object value, Object dependency) {
            if (!HttpExporter.TYPE.equals(dependency)) {
                throw new SettingsException("[" + key + "] is set but type is [" + dependency + "]");
            }
        }
    };
    public static final Setting.AffixSetting<List<String>> HOST_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"host", key -> Setting.listSetting((String)key, Collections.emptyList(), Function.identity(), (Setting.Validator)new Setting.Validator<List<String>>(){

        public void validate(List<String> value) {
        }

        public void validate(List<String> hosts, Map<Setting<?>, Object> settings) {
            String namespace = HOST_SETTING.getNamespace(HOST_SETTING.getConcreteSetting(key));
            String type = (String)settings.get(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace));
            if (hosts.isEmpty()) {
                String defaultType = (String)Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace).get(Settings.EMPTY);
                if (Objects.equals(type, defaultType)) {
                    return;
                }
                throw new SettingsException("host list for [" + key + "] is empty but type is [" + type + "]");
            }
            boolean httpHostFound = false;
            boolean httpsHostFound = false;
            for (String host : hosts) {
                HttpHost httpHost;
                try {
                    httpHost = HttpHostBuilder.builder(host).build();
                }
                catch (IllegalArgumentException e) {
                    throw new SettingsException("[" + key + "] invalid host: [" + host + "]", (Throwable)e);
                }
                if (HttpExporter.TYPE.equals(httpHost.getSchemeName())) {
                    httpHostFound = true;
                } else {
                    httpsHostFound = true;
                }
                if (!httpHostFound || !httpsHostFound) continue;
                throw new SettingsException("[" + key + "] must use a consistent scheme: http or https");
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = HOST_SETTING.getNamespace(HOST_SETTING.getConcreteSetting(key));
            List<Setting> settings = Collections.singletonList(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> BULK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"bulk.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> CONNECTION_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"connection.timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)6L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> CONNECTION_READ_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"connection.read_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.timeValueSeconds((long)60L), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<String> AUTH_USERNAME_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.username", key -> Setting.simpleString((String)key, (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String password) {
        }

        public void validate(String username, Map<Setting<?>, Object> settings) {
            String type;
            String namespace = AUTH_USERNAME_SETTING.getNamespace(AUTH_USERNAME_SETTING.getConcreteSetting(key));
            if (!Strings.isNullOrEmpty((String)username) && !HttpExporter.TYPE.equals(type = (String)settings.get(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace)))) {
                throw new SettingsException("username for [" + key + "] is set but type is [" + type + "]");
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = AUTH_USERNAME_SETTING.getNamespace(AUTH_USERNAME_SETTING.getConcreteSetting(key));
            List<Setting> settings = Arrays.asList(Exporter.TYPE_SETTING.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<String> AUTH_PASSWORD_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.password", key -> Setting.simpleString((String)key, (Setting.Validator)new Setting.Validator<String>(){

        public void validate(String password) {
        }

        public void validate(String password, Map<Setting<?>, Object> settings) {
            String namespace = AUTH_PASSWORD_SETTING.getNamespace(AUTH_PASSWORD_SETTING.getConcreteSetting(key));
            String username = (String)settings.get(AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(namespace));
            if (Strings.isNullOrEmpty((String)username) && !Strings.isNullOrEmpty((String)password)) {
                throw new IllegalArgumentException("[" + AUTH_PASSWORD_SETTING.getConcreteSettingForNamespace(namespace).getKey() + "] without [" + AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(namespace).getKey() + "]");
            }
        }

        public Iterator<Setting<?>> settings() {
            String namespace = AUTH_PASSWORD_SETTING.getNamespace(AUTH_PASSWORD_SETTING.getConcreteSetting(key));
            List<Setting> settings = Collections.singletonList(AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(namespace));
            return settings.iterator();
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered, Setting.Property.Deprecated}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<SecureString> AUTH_SECURE_PASSWORD_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"auth.secure_password", key -> SecureSetting.secureString((String)key, null, (Setting.Property[])new Setting.Property[0]), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Settings> SSL_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"ssl", key -> Setting.groupSetting((String)(key + "."), (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Filtered}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<String> PROXY_BASE_PATH_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"proxy.base_path", key -> Setting.simpleString((String)key, value -> {
        if (!Strings.isNullOrEmpty((String)value)) {
            try {
                RestClientBuilder.cleanPathPrefix((String)value);
            }
            catch (RuntimeException e) {
                Setting concreteSetting = PROXY_BASE_PATH_SETTING.getConcreteSetting(key);
                throw new SettingsException("[" + concreteSetting.getKey() + "] is malformed [" + value + "]", (Throwable)e);
            }
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Boolean> SNIFF_ENABLED_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"sniff.enabled", key -> Setting.boolSetting((String)key, (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Settings> HEADERS_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"headers", key -> Setting.groupSetting((String)(key + "."), settings -> {
        Set names = settings.names();
        for (String name : names) {
            String fullSetting = key + "." + name;
            if (BLACKLISTED_HEADERS.contains(name)) {
                throw new SettingsException("header cannot be overwritten via [" + fullSetting + "]");
            }
            List values = settings.getAsList(name);
            if (!values.isEmpty()) continue;
            throw new SettingsException("headers must have values, missing for setting [" + fullSetting + "]");
        }
    }, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Set<String> BLACKLISTED_HEADERS = Collections.unmodifiableSet(Sets.newHashSet((Object[])new String[]{"Content-Length", "Content-Type"}));
    public static final Setting.AffixSetting<TimeValue> TEMPLATE_CHECK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.template.master_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<Boolean> TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.template.create_legacy_templates", key -> Setting.boolSetting((String)key, (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Setting.AffixSetting<TimeValue> PIPELINE_CHECK_TIMEOUT_SETTING = Setting.affixKeySetting((String)"xpack.monitoring.exporters.", (String)"index.pipeline.master_timeout", key -> Setting.timeSetting((String)key, (TimeValue)TimeValue.MINUS_ONE, (Setting.Property[])new Setting.Property[]{Setting.Property.Dynamic, Setting.Property.NodeScope}), (Setting.AffixSettingDependency[])new Setting.AffixSettingDependency[]{HTTP_TYPE_DEPENDENCY});
    public static final Version MIN_SUPPORTED_CLUSTER_VERSION = Version.V_7_0_0;
    private final RestClient client;
    @Nullable
    private final Sniffer sniffer;
    private final Map<String, String> defaultParams;
    private final HttpResource resource;
    private final HttpResource alertingResource;
    private final AtomicBoolean clusterAlertsAllowed = new AtomicBoolean(false);
    private final MonitoringMigrationCoordinator migrationCoordinator;
    private static final ConcurrentHashMap<String, SecureString> SECURE_AUTH_PASSWORDS = new ConcurrentHashMap();
    private final ThreadContext threadContext;
    private final DateFormatter dateTimeFormatter;
    private final ClusterStateListener onLocalMasterListener;

    public HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator) {
        this(config, sslService, threadContext, migrationCoordinator, new NodeFailureListener(), HttpExporter.createResources(config));
    }

    private HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, Resources resource) {
        this(config, sslService, threadContext, migrationCoordinator, listener, (HttpResource)resource.allResources, resource.alertingResource);
    }

    HttpExporter(Exporter.Config config, SSLService sslService, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, HttpResource resource, HttpResource alertingResource) {
        this(config, HttpExporter.createRestClient(config, sslService, listener), threadContext, migrationCoordinator, listener, resource, alertingResource);
    }

    HttpExporter(Exporter.Config config, RestClient client, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, HttpResource resource, HttpResource alertingResource) {
        this(config, client, HttpExporter.createSniffer(config, client, listener), threadContext, migrationCoordinator, listener, resource, alertingResource);
    }

    HttpExporter(Exporter.Config config, RestClient client, @Nullable Sniffer sniffer, ThreadContext threadContext, MonitoringMigrationCoordinator migrationCoordinator, NodeFailureListener listener, HttpResource resource, HttpResource alertingResource) {
        super(config);
        this.client = Objects.requireNonNull(client);
        this.sniffer = sniffer;
        this.resource = resource;
        this.alertingResource = alertingResource;
        this.defaultParams = HttpExporter.createDefaultParams(config);
        this.threadContext = threadContext;
        this.migrationCoordinator = migrationCoordinator;
        this.dateTimeFormatter = HttpExporter.dateTimeFormatter(config);
        listener.setResource(resource);
        this.onLocalMasterListener = clusterChangedEvent -> {
            if (clusterChangedEvent.nodesDelta().masterNodeChanged() && clusterChangedEvent.localNodeMaster()) {
                resource.markDirty();
            }
        };
        config.clusterService().addListener(this.onLocalMasterListener);
    }

    public static void registerSettingValidators(ClusterService clusterService, SSLService sslService) {
        clusterService.getClusterSettings().addAffixUpdateConsumer(SSL_SETTING, (ignoreKey, ignoreSettings) -> {}, (key, settings) -> {
            HttpExporter.validateSslSettings(key, settings);
            HttpExporter.configureSslStrategy(settings, null, sslService);
        });
    }

    private static void validateSslSettings(String exporter, Settings settings) {
        List secureSettings = SSLConfigurationSettings.withoutPrefix().getSecureSettingsInUse(settings).stream().map(Setting::getKey).collect(Collectors.toList());
        if (!secureSettings.isEmpty()) {
            throw new IllegalStateException("Cannot dynamically update SSL settings for the exporter [" + exporter + "] as it depends on the secure setting(s) [" + Strings.collectionToCommaDelimitedString(secureSettings) + "]");
        }
    }

    static RestClient createRestClient(Exporter.Config config, SSLService sslService, NodeFailureListener listener) {
        RestClientBuilder builder = RestClient.builder((HttpHost[])HttpExporter.createHosts(config)).setFailureListener((RestClient.FailureListener)listener);
        Setting concreteSetting = PROXY_BASE_PATH_SETTING.getConcreteSettingForNamespace(config.name());
        String proxyBasePath = (String)concreteSetting.get(config.settings());
        if (!Strings.isNullOrEmpty((String)proxyBasePath)) {
            try {
                builder.setPathPrefix(proxyBasePath);
            }
            catch (IllegalArgumentException e) {
                throw new SettingsException("[" + concreteSetting.getKey() + "] is malformed [" + proxyBasePath + "]", (Throwable)e);
            }
        }
        HttpExporter.configureHeaders(builder, config);
        HttpExporter.configureSecurity(builder, config, sslService);
        HttpExporter.configureTimeouts(builder, config);
        return builder.build();
    }

    static Sniffer createSniffer(Exporter.Config config, RestClient client, NodeFailureListener listener) {
        Sniffer sniffer = null;
        boolean sniffingEnabled = (Boolean)SNIFF_ENABLED_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (sniffingEnabled) {
            List hosts = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
            ElasticsearchNodesSniffer.Scheme scheme = ((String)hosts.get(0)).startsWith("https") ? ElasticsearchNodesSniffer.Scheme.HTTPS : ElasticsearchNodesSniffer.Scheme.HTTP;
            ElasticsearchNodesSniffer hostsSniffer = new ElasticsearchNodesSniffer(client, ElasticsearchNodesSniffer.DEFAULT_SNIFF_REQUEST_TIMEOUT, scheme);
            sniffer = Sniffer.builder((RestClient)client).setNodesSniffer((NodesSniffer)hostsSniffer).build();
            listener.setSniffer(sniffer);
            logger.debug("exporter [{}] using host sniffing", (Object)config.name());
        }
        return sniffer;
    }

    static Resources createResources(Exporter.Config config) {
        String resourceOwnerName = "xpack.monitoring.exporters." + config.name();
        ArrayList<HttpResource> resources = new ArrayList<HttpResource>();
        resources.add(new VersionHttpResource(resourceOwnerName, MIN_SUPPORTED_CLUSTER_VERSION));
        HttpExporter.configureTemplateResources(config, resourceOwnerName, resources);
        HttpExporter.configurePipelineResources(config, resourceOwnerName, resources);
        HttpResource alertingResource = HttpExporter.configureClusterAlertsResources(config, resourceOwnerName);
        if (alertingResource != null) {
            resources.add(alertingResource);
        }
        return new Resources(new MultiHttpResource(resourceOwnerName, resources), alertingResource);
    }

    private static HttpHost[] createHosts(Exporter.Config config) {
        List hosts = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        ArrayList<HttpHost> httpHosts = new ArrayList<HttpHost>(hosts.size());
        for (String host : hosts) {
            HttpHost httpHost = HttpHostBuilder.builder(host).build();
            httpHosts.add(httpHost);
        }
        logger.debug("exporter [{}] using hosts {}", (Object)config.name(), (Object)hosts);
        return httpHosts.toArray(new HttpHost[0]);
    }

    private static void configureHeaders(RestClientBuilder builder, Exporter.Config config) {
        Setting concreteSetting = HEADERS_SETTING.getConcreteSettingForNamespace(config.name());
        Settings headerSettings = (Settings)concreteSetting.get(config.settings());
        Set names = headerSettings.names();
        if (names.isEmpty()) {
            return;
        }
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        for (String name : names) {
            if (BLACKLISTED_HEADERS.contains(name)) {
                throw new SettingsException("header cannot be overwritten via [" + concreteSetting.getKey() + name + "]");
            }
            List values = headerSettings.getAsList(name);
            if (values.isEmpty()) {
                throw new SettingsException("headers must have values, missing for setting [" + concreteSetting.getKey() + name + "]");
            }
            for (String value : values) {
                headers.add(new BasicHeader(name, value));
            }
        }
        builder.setDefaultHeaders(headers.toArray(new Header[headers.size()]));
    }

    private static void configureSecurity(RestClientBuilder builder, Exporter.Config config, SSLService sslService) {
        Setting concreteSetting = SSL_SETTING.getConcreteSettingForNamespace(config.name());
        Settings sslSettings = (Settings)concreteSetting.get(config.settings());
        SSLIOSessionStrategy sslStrategy = HttpExporter.configureSslStrategy(sslSettings, (Setting<Settings>)concreteSetting, sslService);
        CredentialsProvider credentialsProvider = HttpExporter.createCredentialsProvider(config);
        List hostList = (List)HOST_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (credentialsProvider != null && !hostList.stream().findFirst().orElse("").startsWith("https")) {
            logger.warn("exporter [{}] is not using https, but using user authentication with plaintext username/password!", (Object)config.name());
        }
        if (sslStrategy != null) {
            builder.setHttpClientConfigCallback((RestClientBuilder.HttpClientConfigCallback)new SecurityHttpClientConfigCallback(sslStrategy, credentialsProvider));
        }
    }

    private static SSLIOSessionStrategy configureSslStrategy(Settings sslSettings, Setting<Settings> concreteSetting, SSLService sslService) {
        SSLIOSessionStrategy sslStrategy;
        if (SSLConfigurationSettings.withoutPrefix().getSecureSettingsInUse(sslSettings).isEmpty()) {
            sslStrategy = sslService.sslIOSessionStrategy(sslSettings);
        } else {
            SSLConfiguration sslConfiguration = sslService.getSSLConfiguration(concreteSetting.getKey());
            sslStrategy = sslService.sslIOSessionStrategy(sslConfiguration);
        }
        return sslStrategy;
    }

    private static void configureTimeouts(RestClientBuilder builder, Exporter.Config config) {
        TimeValue connectTimeout = (TimeValue)CONNECTION_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        TimeValue socketTimeout = (TimeValue)CONNECTION_READ_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        builder.setRequestConfigCallback((RestClientBuilder.RequestConfigCallback)new TimeoutRequestConfigCallback(connectTimeout, socketTimeout));
    }

    public static List<String> loadSettings(Settings settings) {
        ArrayList<String> changedExporters = new ArrayList<String>();
        for (String namespace : AUTH_SECURE_PASSWORD_SETTING.getNamespaces(settings)) {
            SecureString existingPassword;
            Setting s = AUTH_SECURE_PASSWORD_SETTING.getConcreteSettingForNamespace(namespace);
            SecureString securePassword = (SecureString)s.get(settings);
            if (securePassword.equals((Object)(existingPassword = SECURE_AUTH_PASSWORDS.put(namespace, securePassword)))) continue;
            changedExporters.add(namespace);
        }
        return changedExporters;
    }

    @Nullable
    static CredentialsProvider createCredentialsProvider(Exporter.Config config) {
        String password;
        String username = (String)AUTH_USERNAME_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (Strings.isNullOrEmpty((String)username)) {
            return null;
        }
        String deprecatedPassword = (String)AUTH_PASSWORD_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        SecureString securePassword = SECURE_AUTH_PASSWORDS.get(config.name());
        if (securePassword != null) {
            password = securePassword.toString();
            if (!Strings.isNullOrEmpty((String)deprecatedPassword)) {
                logger.warn("exporter [{}] specified both auth.secure_password and auth.password.  using auth.secure_password and ignoring auth.password", (Object)config.name());
            }
        } else {
            password = deprecatedPassword;
        }
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return credentialsProvider;
    }

    static Map<String, String> createDefaultParams(Exporter.Config config) {
        TimeValue bulkTimeout = (TimeValue)BULK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        MapBuilder params = new MapBuilder();
        if (!TimeValue.MINUS_ONE.equals((Object)bulkTimeout)) {
            params.put((Object)"timeout", (Object)bulkTimeout.toString());
        }
        if (((Boolean)USE_INGEST_PIPELINE_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            params.put((Object)"pipeline", (Object)MonitoringTemplateUtils.pipelineName((String)"7"));
        }
        params.put((Object)"filter_path", (Object)"errors,items.*.error");
        return params.immutableMap();
    }

    private static void configureTemplateResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        TimeValue templateTimeout = (TimeValue)TEMPLATE_CHECK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        for (String templateId : MonitoringTemplateUtils.TEMPLATE_IDS) {
            String templateName = MonitoringTemplateUtils.templateName((String)templateId);
            Supplier<String> templateLoader = () -> MonitoringTemplateUtils.loadTemplate((String)templateId);
            resources.add(new TemplateHttpResource(resourceOwnerName, templateTimeout, templateName, templateLoader));
        }
        boolean createLegacyTemplates = (Boolean)TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
        if (createLegacyTemplates) {
            for (String templateId : MonitoringTemplateUtils.OLD_TEMPLATE_IDS) {
                String templateName = MonitoringTemplateUtils.oldTemplateName((String)templateId);
                Supplier<String> templateLoader = () -> MonitoringTemplateUtils.createEmptyTemplate((String)templateId);
                resources.add(new TemplateHttpResource(resourceOwnerName, templateTimeout, templateName, templateLoader));
            }
        }
    }

    private static void configurePipelineResources(Exporter.Config config, String resourceOwnerName, List<HttpResource> resources) {
        if (((Boolean)USE_INGEST_PIPELINE_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            TimeValue pipelineTimeout = (TimeValue)PIPELINE_CHECK_TIMEOUT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings());
            for (String pipelineId : MonitoringTemplateUtils.PIPELINE_IDS) {
                String pipelineName = MonitoringTemplateUtils.pipelineName((String)pipelineId);
                Supplier<byte[]> pipeline = () -> BytesReference.toBytes((BytesReference)BytesReference.bytes((XContentBuilder)MonitoringTemplateUtils.loadPipeline((String)pipelineId, (XContentType)XContentType.JSON)));
                resources.add(new PipelineHttpResource(resourceOwnerName, pipelineTimeout, pipelineName, pipeline));
            }
        }
    }

    private static HttpResource configureClusterAlertsResources(Exporter.Config config, String resourceOwnerName) {
        if (((Boolean)CLUSTER_ALERTS_MANAGEMENT_SETTING.getConcreteSettingForNamespace(config.name()).get(config.settings())).booleanValue()) {
            ClusterService clusterService = config.clusterService();
            ArrayList<ClusterAlertHttpResource> watchResources = new ArrayList<ClusterAlertHttpResource>();
            List<String> blacklist = ClusterAlertsUtil.getClusterAlertsBlacklist(config);
            for (String watchId : ClusterAlertsUtil.WATCH_IDS) {
                boolean blacklisted = blacklist.contains(watchId) || (Boolean)Monitoring.MIGRATION_DECOMMISSION_ALERTS.get(config.settings()) != false;
                Supplier<String> uniqueWatchId = () -> ClusterAlertsUtil.createUniqueWatchId(clusterService, watchId);
                Supplier<String> watch = blacklisted ? null : () -> ClusterAlertsUtil.loadWatch(clusterService, watchId);
                watchResources.add(new ClusterAlertHttpResource(resourceOwnerName, config.licenseState(), uniqueWatchId, watch));
            }
            return new WatcherExistsHttpResource(resourceOwnerName, clusterService, new MultiHttpResource(resourceOwnerName, watchResources));
        }
        return null;
    }

    @Override
    public void removeAlerts(Consumer<Exporter.ExporterResourceStatus> listener) {
        this.alertingResource.checkAndPublish(this.client, (ActionListener<HttpResource.ResourcePublishResult>)ActionListener.wrap(result -> {
            Exporter.ExporterResourceStatus status;
            if (result.isSuccess()) {
                status = Exporter.ExporterResourceStatus.ready(this.name(), TYPE);
            } else {
                switch (result.getResourceState()) {
                    case CLEAN: {
                        status = Exporter.ExporterResourceStatus.ready(this.name(), TYPE);
                        break;
                    }
                    case CHECKING: 
                    case DIRTY: {
                        status = Exporter.ExporterResourceStatus.notReady(this.name(), TYPE, result.getReason(), new Object[0]);
                        break;
                    }
                    default: {
                        throw new ElasticsearchException("Illegal exporter resource status state [{}]", new Object[]{result.getResourceState()});
                    }
                }
            }
            listener.accept(status);
        }, exception -> listener.accept(Exporter.ExporterResourceStatus.notReady(this.name(), TYPE, exception))));
    }

    @Override
    public void openBulk(ActionListener<ExportBulk> listener) {
        boolean canUseClusterAlerts = this.config.licenseState().checkFeature(XPackLicenseState.Feature.MONITORING_CLUSTER_ALERTS);
        if (this.clusterAlertsAllowed.compareAndSet(!canUseClusterAlerts, canUseClusterAlerts)) {
            this.resource.markDirty();
        }
        if (this.migrationCoordinator.canInstall()) {
            this.resource.checkAndPublishIfDirty(this.client, (ActionListener<Boolean>)ActionListener.wrap(success -> {
                if (success.booleanValue()) {
                    String name = "xpack.monitoring.exporters." + this.config.name();
                    listener.onResponse((Object)new HttpExportBulk(name, this.client, this.defaultParams, this.dateTimeFormatter, this.threadContext));
                } else {
                    listener.onResponse(null);
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        } else {
            listener.onResponse(null);
        }
    }

    @Override
    public void doClose() {
        try {
            this.config.clusterService().removeListener(this.onLocalMasterListener);
            if (this.sniffer != null) {
                this.sniffer.close();
            }
        }
        catch (Exception e) {
            logger.error("an error occurred while closing the internal client sniffer", (Throwable)e);
        }
        finally {
            try {
                this.client.close();
            }
            catch (Exception e) {
                logger.error("an error occurred while closing the internal client", (Throwable)e);
            }
        }
    }

    public static List<Setting.AffixSetting<?>> getDynamicSettings() {
        return Arrays.asList(HOST_SETTING, TEMPLATE_CREATE_LEGACY_VERSIONS_SETTING, AUTH_PASSWORD_SETTING, AUTH_USERNAME_SETTING, BULK_TIMEOUT_SETTING, CONNECTION_READ_TIMEOUT_SETTING, CONNECTION_TIMEOUT_SETTING, PIPELINE_CHECK_TIMEOUT_SETTING, PROXY_BASE_PATH_SETTING, SNIFF_ENABLED_SETTING, TEMPLATE_CHECK_TIMEOUT_SETTING, SSL_SETTING, HEADERS_SETTING);
    }

    public static List<Setting.AffixSetting<?>> getSecureSettings() {
        return Collections.singletonList(AUTH_SECURE_PASSWORD_SETTING);
    }

    public static List<Setting.AffixSetting<?>> getSettings() {
        ArrayList allSettings = new ArrayList(HttpExporter.getDynamicSettings());
        allSettings.addAll(HttpExporter.getSecureSettings());
        return allSettings;
    }

    static class Resources {
        MultiHttpResource allResources;
        HttpResource alertingResource;

        Resources(MultiHttpResource allResources, HttpResource alertingResource) {
            this.allResources = allResources;
            this.alertingResource = alertingResource;
        }
    }
}

