/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeReadRequest;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckAction;
import org.elasticsearch.xpack.deprecation.NodesDeprecationCheckResponse;

public class DeprecationInfoAction
extends ActionType<Response> {
    public static final DeprecationInfoAction INSTANCE = new DeprecationInfoAction();
    public static final String NAME = "cluster:admin/xpack/deprecation/info";

    private DeprecationInfoAction() {
        super(NAME, Response::new);
    }

    public static <T> List<DeprecationIssue> filterChecks(List<T> checks, Function<T, DeprecationIssue> mapper) {
        return checks.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private static List<DeprecationIssue> mergeNodeIssues(NodesDeprecationCheckResponse response) {
        HashMap<DeprecationIssue, List> issueListMap = new HashMap<DeprecationIssue, List>();
        for (NodesDeprecationCheckAction.NodeResponse resp : response.getNodes()) {
            for (DeprecationIssue issue : resp.getDeprecationIssues()) {
                issueListMap.computeIfAbsent(issue, key -> new ArrayList()).add(resp.getNode().getName());
            }
        }
        return issueListMap.entrySet().stream().map(entry -> {
            DeprecationIssue issue = (DeprecationIssue)entry.getKey();
            String details = issue.getDetails() != null ? issue.getDetails() + " " : "";
            return new DeprecationIssue(issue.getLevel(), issue.getMessage(), issue.getUrl(), details + "(nodes impacted: " + entry.getValue() + ")", issue.getMeta());
        }).collect(Collectors.toList());
    }

    public static class Request
    extends MasterNodeReadRequest<Request>
    implements IndicesRequest.Replaceable {
        private static final IndicesOptions INDICES_OPTIONS = IndicesOptions.fromOptions((boolean)false, (boolean)true, (boolean)true, (boolean)true);
        private String[] indices;

        public Request(String ... indices) {
            this.indices = indices;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.indices = in.readStringArray();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeStringArray(this.indices);
        }

        public String[] indices() {
            return this.indices;
        }

        public Request indices(String ... indices) {
            this.indices = indices;
            return this;
        }

        public IndicesOptions indicesOptions() {
            return INDICES_OPTIONS;
        }

        public boolean includeDataStreams() {
            return true;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.indices == null) {
                validationException = ValidateActions.addValidationError((String)"index/indices is missing", validationException);
            }
            return validationException;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Arrays.equals(this.indices, request.indices);
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.indices));
        }
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        static final Set<String> RESERVED_NAMES = Sets.newHashSet((Object[])new String[]{"cluster_settings", "node_settings", "index_settings"});
        private final List<DeprecationIssue> clusterSettingsIssues;
        private final List<DeprecationIssue> nodeSettingsIssues;
        private final Map<String, List<DeprecationIssue>> indexSettingsIssues;
        private final Map<String, List<DeprecationIssue>> pluginSettingsIssues;

        public Response(StreamInput in) throws IOException {
            super(in);
            this.clusterSettingsIssues = in.readList(DeprecationIssue::new);
            this.nodeSettingsIssues = in.readList(DeprecationIssue::new);
            this.indexSettingsIssues = in.readMapOfLists(StreamInput::readString, DeprecationIssue::new);
            if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
                if (in.getVersion().before(Version.V_7_11_0)) {
                    List mlIssues = in.readList(DeprecationIssue::new);
                    this.pluginSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
                    this.pluginSettingsIssues.put("ml_settings", mlIssues);
                } else {
                    this.pluginSettingsIssues = in.readMapOfLists(StreamInput::readString, DeprecationIssue::new);
                }
            } else {
                this.pluginSettingsIssues = Collections.singletonMap("ml_settings", Collections.emptyList());
            }
        }

        public Response(List<DeprecationIssue> clusterSettingsIssues, List<DeprecationIssue> nodeSettingsIssues, Map<String, List<DeprecationIssue>> indexSettingsIssues, Map<String, List<DeprecationIssue>> pluginSettingsIssues) {
            this.clusterSettingsIssues = clusterSettingsIssues;
            this.nodeSettingsIssues = nodeSettingsIssues;
            this.indexSettingsIssues = indexSettingsIssues;
            Set intersection = Sets.intersection(RESERVED_NAMES, pluginSettingsIssues.keySet());
            if (!intersection.isEmpty()) {
                throw new ElasticsearchStatusException("Unable to discover deprecations as plugin deprecation names overlap with reserved names {}", RestStatus.INTERNAL_SERVER_ERROR, new Object[]{intersection});
            }
            this.pluginSettingsIssues = pluginSettingsIssues;
        }

        public List<DeprecationIssue> getClusterSettingsIssues() {
            return this.clusterSettingsIssues;
        }

        public List<DeprecationIssue> getNodeSettingsIssues() {
            return this.nodeSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getIndexSettingsIssues() {
            return this.indexSettingsIssues;
        }

        public Map<String, List<DeprecationIssue>> getPluginSettingsIssues() {
            return this.pluginSettingsIssues;
        }

        public void writeTo(StreamOutput out) throws IOException {
            out.writeList(this.clusterSettingsIssues);
            out.writeList(this.nodeSettingsIssues);
            out.writeMapOfLists(this.indexSettingsIssues, StreamOutput::writeString, (o, v) -> v.writeTo(o));
            if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
                if (out.getVersion().before(Version.V_7_11_0)) {
                    out.writeList(this.pluginSettingsIssues.getOrDefault("ml_settings", Collections.emptyList()));
                } else {
                    out.writeMapOfLists(this.pluginSettingsIssues, StreamOutput::writeString, (o, v) -> v.writeTo(o));
                }
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return builder.startObject().array("cluster_settings", this.clusterSettingsIssues.toArray()).array("node_settings", this.nodeSettingsIssues.toArray()).field("index_settings").map(this.indexSettingsIssues).mapContents(this.pluginSettingsIssues).endObject();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.clusterSettingsIssues, response.clusterSettingsIssues) && Objects.equals(this.nodeSettingsIssues, response.nodeSettingsIssues) && Objects.equals(this.indexSettingsIssues, response.indexSettingsIssues) && Objects.equals(this.pluginSettingsIssues, response.pluginSettingsIssues);
        }

        public int hashCode() {
            return Objects.hash(this.clusterSettingsIssues, this.nodeSettingsIssues, this.indexSettingsIssues, this.pluginSettingsIssues);
        }

        public static Response from(ClusterState state, IndexNameExpressionResolver indexNameExpressionResolver, Request request, NodesDeprecationCheckResponse nodeDeprecationResponse, List<Function<IndexMetadata, DeprecationIssue>> indexSettingsChecks, List<Function<ClusterState, DeprecationIssue>> clusterSettingsChecks, Map<String, List<DeprecationIssue>> pluginSettingIssues) {
            List<DeprecationIssue> clusterSettingsIssues = DeprecationInfoAction.filterChecks(clusterSettingsChecks, c -> (DeprecationIssue)c.apply(state));
            List nodeSettingsIssues = DeprecationInfoAction.mergeNodeIssues(nodeDeprecationResponse);
            String[] concreteIndexNames = indexNameExpressionResolver.concreteIndexNames(state, (IndicesRequest)request);
            HashMap<String, List<DeprecationIssue>> indexSettingsIssues = new HashMap<String, List<DeprecationIssue>>();
            for (String concreteIndex : concreteIndexNames) {
                IndexMetadata indexMetadata = state.getMetadata().index(concreteIndex);
                List<DeprecationIssue> singleIndexIssues = DeprecationInfoAction.filterChecks(indexSettingsChecks, c -> (DeprecationIssue)c.apply(indexMetadata));
                if (singleIndexIssues.size() <= 0) continue;
                indexSettingsIssues.put(concreteIndex, singleIndexIssues);
            }
            return new Response(clusterSettingsIssues, nodeSettingsIssues, indexSettingsIssues, pluginSettingIssues);
        }
    }
}

