/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.search.aggregations;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreMode;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.LongArray;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.LeafBucketCollector;
import org.elasticsearch.search.aggregations.metrics.MetricsAggregator;
import org.elasticsearch.search.aggregations.support.AggregationContext;
import org.elasticsearch.search.sort.BucketedSort;
import org.elasticsearch.search.sort.SortOrder;
import org.elasticsearch.xpack.spatial.search.aggregations.GeoLineBucketedSort;
import org.elasticsearch.xpack.spatial.search.aggregations.InternalGeoLine;
import org.elasticsearch.xpack.spatial.search.aggregations.PathArraySorter;
import org.elasticsearch.xpack.spatial.search.aggregations.support.GeoLineMultiValuesSource;

final class GeoLineAggregator
extends MetricsAggregator {
    private final GeoLineMultiValuesSource valuesSources;
    private final BigArrays bigArrays;
    private final GeoLineBucketedSort sort;
    private final GeoLineBucketedSort.Extra extra;
    private LongArray counts;
    private final boolean includeSorts;
    private final SortOrder sortOrder;
    private final int size;

    GeoLineAggregator(String name, GeoLineMultiValuesSource valuesSources, AggregationContext context, Aggregator parent, Map<String, Object> metaData, boolean includeSorts, SortOrder sortOrder, int size) throws IOException {
        super(name, context, parent, metaData);
        this.valuesSources = valuesSources;
        this.bigArrays = context.bigArrays();
        if (valuesSources != null) {
            this.extra = new GeoLineBucketedSort.Extra(this.bigArrays, valuesSources);
            this.sort = new GeoLineBucketedSort(this.bigArrays, sortOrder, null, size, valuesSources, this.extra);
            this.counts = this.bigArrays.newLongArray(1L, true);
        } else {
            this.extra = null;
            this.sort = null;
        }
        this.includeSorts = includeSorts;
        this.sortOrder = sortOrder;
        this.size = size;
    }

    public ScoreMode scoreMode() {
        if (this.valuesSources != null && this.valuesSources.needsScores()) {
            return ScoreMode.COMPLETE;
        }
        return super.scoreMode();
    }

    public LeafBucketCollector getLeafCollector(LeafReaderContext ctx, LeafBucketCollector sub) throws IOException {
        if (this.valuesSources == null) {
            return LeafBucketCollector.NO_OP_COLLECTOR;
        }
        final BucketedSort.Leaf leafSort = this.sort.forLeaf(ctx);
        return new LeafBucketCollector(){

            public void collect(int doc, long bucket) throws IOException {
                leafSort.collect(doc, bucket);
                GeoLineAggregator.this.counts = GeoLineAggregator.this.bigArrays.grow(GeoLineAggregator.this.counts, bucket + 1L);
                GeoLineAggregator.this.counts.increment(bucket, 1L);
            }
        };
    }

    public InternalAggregation buildAggregation(long bucket) {
        if (this.valuesSources == null) {
            return this.buildEmptyAggregation();
        }
        boolean complete = this.counts.get(bucket) <= (long)this.size;
        this.addRequestCircuitBreakerBytes(128L * this.sort.sizeOf(bucket));
        double[] sortVals = this.sort.getSortValues(bucket);
        long[] bucketLine = this.sort.getPoints(bucket);
        new PathArraySorter(bucketLine, sortVals, this.sortOrder).sort();
        return new InternalGeoLine(this.name, bucketLine, sortVals, this.metadata(), complete, this.includeSorts, this.sortOrder, this.size);
    }

    public InternalAggregation buildEmptyAggregation() {
        return new InternalGeoLine(this.name, null, null, this.metadata(), true, this.includeSorts, this.sortOrder, this.size);
    }

    public void doClose() {
        Releasables.close((Releasable[])new Releasable[]{this.sort, this.extra, this.counts});
    }
}

