/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.spatial.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.document.XYDocValuesField;
import org.apache.lucene.document.XYPointField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.geometry.Point;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.AbstractPointGeometryFieldMapper;
import org.elasticsearch.index.mapper.ContentPath;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.SearchExecutionContext;
import org.elasticsearch.xpack.spatial.common.CartesianFormatterFactory;
import org.elasticsearch.xpack.spatial.common.CartesianPoint;
import org.elasticsearch.xpack.spatial.index.mapper.ShapeQueryable;
import org.elasticsearch.xpack.spatial.index.query.ShapeQueryPointProcessor;

public class PointFieldMapper
extends AbstractPointGeometryFieldMapper<CartesianPoint> {
    public static final String CONTENT_TYPE = "point";
    private static final DeprecationLogger DEPRECATION_LOGGER = DeprecationLogger.getLogger(GeoShapeFieldMapper.class);
    public static FieldMapper.TypeParser PARSER = new FieldMapper.TypeParser((n, c) -> new Builder((String)n, (Boolean)IGNORE_MALFORMED_SETTING.get(c.getSettings())));
    private final Builder builder;

    private static Builder builder(FieldMapper in) {
        return ((PointFieldMapper)in).builder;
    }

    public PointFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, CartesianPointParser parser, Builder builder) {
        super(simpleName, mappedFieldType, multiFields, (Explicit)builder.ignoreMalformed.get(), (Explicit)builder.ignoreZValue.get(), (Object)((CartesianPoint)builder.nullValue.get()), copyTo, (AbstractGeometryFieldMapper.Parser)parser);
        this.builder = builder;
    }

    protected void index(ParseContext context, CartesianPoint point) throws IOException {
        if (this.fieldType().isSearchable()) {
            context.doc().add((IndexableField)new XYPointField(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        }
        if (this.fieldType().hasDocValues()) {
            context.doc().add((IndexableField)new XYDocValuesField(this.fieldType().name(), (float)point.getX(), (float)point.getY()));
        } else if (this.fieldType().isStored() || this.fieldType().isSearchable()) {
            context.addToFieldNames(this.fieldType().name());
        }
        if (this.fieldType().isStored()) {
            context.doc().add((IndexableField)new StoredField(this.fieldType().name(), point.toString()));
        }
    }

    protected String contentType() {
        return CONTENT_TYPE;
    }

    public PointFieldType fieldType() {
        return (PointFieldType)this.mappedFieldType;
    }

    public FieldMapper.Builder getMergeBuilder() {
        return new Builder(this.simpleName(), (Boolean)((Explicit)this.builder.ignoreMalformed.getDefaultValue()).value()).init((FieldMapper)this);
    }

    public static class Builder
    extends FieldMapper.Builder {
        final FieldMapper.Parameter<Boolean> indexed = FieldMapper.Parameter.indexParam(m -> (Boolean)PointFieldMapper.builder((FieldMapper)m).indexed.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> hasDocValues = FieldMapper.Parameter.docValuesParam(m -> (Boolean)PointFieldMapper.builder((FieldMapper)m).hasDocValues.get(), (boolean)true);
        final FieldMapper.Parameter<Boolean> stored = FieldMapper.Parameter.storeParam(m -> (Boolean)PointFieldMapper.builder((FieldMapper)m).stored.get(), (boolean)false);
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreMalformed;
        final FieldMapper.Parameter<Explicit<Boolean>> ignoreZValue = AbstractGeometryFieldMapper.ignoreZValueParam(m -> (Explicit)PointFieldMapper.builder((FieldMapper)m).ignoreZValue.get());
        final FieldMapper.Parameter<CartesianPoint> nullValue;
        final FieldMapper.Parameter<Map<String, String>> meta = FieldMapper.Parameter.metaParam();

        public Builder(String name, boolean ignoreMalformedByDefault) {
            super(name);
            this.ignoreMalformed = AbstractGeometryFieldMapper.ignoreMalformedParam(m -> (Explicit)PointFieldMapper.builder((FieldMapper)m).ignoreMalformed.get(), (boolean)ignoreMalformedByDefault);
            this.nullValue = AbstractPointGeometryFieldMapper.nullValueParam(m -> (CartesianPoint)PointFieldMapper.builder((FieldMapper)m).nullValue.get(), (n, c, o) -> o == null ? null : Builder.parseNullValue(o, (Boolean)((Explicit)this.ignoreZValue.get()).value(), (Boolean)((Explicit)this.ignoreMalformed.get()).value()), () -> null).acceptsNull();
        }

        protected List<FieldMapper.Parameter<?>> getParameters() {
            return Arrays.asList(this.indexed, this.hasDocValues, this.stored, this.ignoreMalformed, this.ignoreZValue, this.nullValue, this.meta);
        }

        private static CartesianPoint parseNullValue(Object nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            CartesianPoint point = new CartesianPoint();
            CartesianPoint.parsePoint(nullValue, point, ignoreZValue);
            if (!ignoreMalformed) {
                if (!Double.isFinite(point.getX())) {
                    throw new IllegalArgumentException("illegal x value [" + point.getX() + "]");
                }
                if (!Double.isFinite(point.getY())) {
                    throw new IllegalArgumentException("illegal y value [" + point.getY() + "]");
                }
            }
            return point;
        }

        public FieldMapper build(ContentPath contentPath) {
            if (this.multiFieldsBuilder.hasMultiFields()) {
                DEPRECATION_LOGGER.deprecate(DeprecationCategory.MAPPINGS, "point_multifields", "Adding multifields to [point] mappers has no effect and will be forbidden in future", new Object[0]);
            }
            CartesianPointParser parser = new CartesianPointParser(this.name, CartesianPoint::new, (CheckedBiFunction<XContentParser, CartesianPoint, CartesianPoint, IOException>)((CheckedBiFunction)(p, point) -> {
                CartesianPoint.parsePoint(p, point, (boolean)((Boolean)((Explicit)this.ignoreZValue.get()).value()));
                return point;
            }), (CartesianPoint)this.nullValue.get(), (Boolean)((Explicit)this.ignoreZValue.get()).value(), (Boolean)((Explicit)this.ignoreMalformed.get()).value());
            PointFieldType ft = new PointFieldType(this.buildFullName(contentPath), (Boolean)this.indexed.get(), (Boolean)this.stored.get(), (Boolean)this.hasDocValues.get(), parser, (Map)this.meta.get());
            return new PointFieldMapper(this.name, (MappedFieldType)ft, this.multiFieldsBuilder.build((Mapper.Builder)this, contentPath), this.copyTo.build(), parser, this);
        }
    }

    public static class PointFieldType
    extends AbstractGeometryFieldMapper.AbstractGeometryFieldType<CartesianPoint>
    implements ShapeQueryable {
        private final ShapeQueryPointProcessor queryProcessor = new ShapeQueryPointProcessor();

        private PointFieldType(String name, boolean indexed, boolean stored, boolean hasDocValues, CartesianPointParser parser, Map<String, String> meta) {
            super(name, indexed, stored, hasDocValues, (AbstractGeometryFieldMapper.Parser)parser, meta);
        }

        public String typeName() {
            return PointFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query shapeQuery(Geometry shape, String fieldName, ShapeRelation relation, SearchExecutionContext context) {
            return this.queryProcessor.shapeQuery(shape, fieldName, relation, context);
        }

        protected Function<CartesianPoint, Object> getFormatter(String format) {
            Function<Geometry, Object> formatter = CartesianFormatterFactory.getFormatter(format);
            return point -> formatter.apply((Geometry)new Point(point.getX(), point.getY()));
        }
    }

    private static class CartesianPointParser
    extends AbstractPointGeometryFieldMapper.PointParser<CartesianPoint> {
        CartesianPointParser(String field, Supplier<CartesianPoint> pointSupplier, CheckedBiFunction<XContentParser, CartesianPoint, CartesianPoint, IOException> objectParser, CartesianPoint nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            super(field, pointSupplier, objectParser, (Object)nullValue, ignoreZValue, ignoreMalformed);
        }

        protected CartesianPoint validate(CartesianPoint in) {
            if (!this.ignoreMalformed) {
                if (!Double.isFinite(in.getX())) {
                    throw new IllegalArgumentException("illegal x value [" + in.getX() + "] for " + this.field);
                }
                if (!Double.isFinite(in.getY())) {
                    throw new IllegalArgumentException("illegal y value [" + in.getY() + "] for " + this.field);
                }
            }
            return in;
        }

        protected void reset(CartesianPoint in, double x, double y) {
            in.reset(x, y);
        }
    }
}

