/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.transforms;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.refresh.RefreshAction;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequest;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.search.SearchAction;
import org.elasticsearch.action.search.SearchRequest;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.reindex.BulkByScrollResponse;
import org.elasticsearch.index.reindex.DeleteByQueryAction;
import org.elasticsearch.index.reindex.DeleteByQueryRequest;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.indexing.IndexerState;
import org.elasticsearch.xpack.core.transform.transforms.TransformCheckpoint;
import org.elasticsearch.xpack.core.transform.transforms.TransformConfig;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerPosition;
import org.elasticsearch.xpack.core.transform.transforms.TransformIndexerStats;
import org.elasticsearch.xpack.core.transform.transforms.TransformProgress;
import org.elasticsearch.xpack.core.transform.transforms.TransformState;
import org.elasticsearch.xpack.core.transform.transforms.TransformStoredDoc;
import org.elasticsearch.xpack.core.transform.transforms.TransformTaskState;
import org.elasticsearch.xpack.transform.checkpoint.CheckpointProvider;
import org.elasticsearch.xpack.transform.notifications.TransformAuditor;
import org.elasticsearch.xpack.transform.persistence.SeqNoPrimaryTermAndIndex;
import org.elasticsearch.xpack.transform.persistence.TransformConfigManager;
import org.elasticsearch.xpack.transform.transforms.BulkIndexingException;
import org.elasticsearch.xpack.transform.transforms.TransformContext;
import org.elasticsearch.xpack.transform.transforms.TransformException;
import org.elasticsearch.xpack.transform.transforms.TransformIndexer;
import org.elasticsearch.xpack.transform.transforms.pivot.SchemaUtil;
import org.elasticsearch.xpack.transform.utils.ExceptionRootCauseFinder;

class ClientTransformIndexer
extends TransformIndexer {
    private static final Logger logger = LogManager.getLogger(ClientTransformIndexer.class);
    private final Client client;
    private final AtomicBoolean oldStatsCleanedUp = new AtomicBoolean(false);
    private final AtomicReference<SeqNoPrimaryTermAndIndex> seqNoPrimaryTermAndIndex;

    ClientTransformIndexer(ThreadPool threadPool, TransformConfigManager transformsConfigManager, CheckpointProvider checkpointProvider, AtomicReference<IndexerState> initialState, TransformIndexerPosition initialPosition, Client client, TransformAuditor auditor, TransformIndexerStats initialStats, TransformConfig transformConfig, TransformProgress transformProgress, TransformCheckpoint lastCheckpoint, TransformCheckpoint nextCheckpoint, SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex, TransformContext context, boolean shouldStopAtCheckpoint) {
        super((ThreadPool)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)threadPool, (String)"threadPool"), transformsConfigManager, checkpointProvider, auditor, transformConfig, (AtomicReference)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull(initialState, (String)"initialState"), initialPosition, initialStats == null ? new TransformIndexerStats() : initialStats, transformProgress, lastCheckpoint, nextCheckpoint, context);
        this.client = (Client)org.elasticsearch.xpack.core.transform.utils.ExceptionsHelper.requireNonNull((Object)client, (String)"client");
        this.seqNoPrimaryTermAndIndex = new AtomicReference<SeqNoPrimaryTermAndIndex>(seqNoPrimaryTermAndIndex);
        context.setShouldStopAtCheckpoint(shouldStopAtCheckpoint);
    }

    protected void doNextSearch(long waitTimeInNanos, ActionListener<SearchResponse> nextPhase) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to search while failed.", (Object)this.getJobId());
            nextPhase.onFailure((Exception)((Object)new ElasticsearchException("Attempted to do a search request for failed transform [{}].", new Object[]{this.getJobId()})));
            return;
        }
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)this.buildSearchRequest(), nextPhase);
    }

    protected void doNextBulk(BulkRequest request, ActionListener<BulkResponse> nextPhase) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to bulk index while failed.", (Object)this.getJobId());
            nextPhase.onFailure((Exception)((Object)new ElasticsearchException("Attempted to do a bulk index request for failed transform [{}].", new Object[]{this.getJobId()})));
            return;
        }
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)BulkAction.INSTANCE, (ActionRequest)request, (ActionListener)ActionListener.wrap(bulkResponse -> this.handleBulkResponse((BulkResponse)bulkResponse, nextPhase), arg_0 -> nextPhase.onFailure(arg_0)));
    }

    protected void handleBulkResponse(BulkResponse bulkResponse, ActionListener<BulkResponse> nextPhase) {
        if (!bulkResponse.hasFailures()) {
            this.context.resetReasonAndFailureCounter();
            nextPhase.onResponse((Object)bulkResponse);
            return;
        }
        int failureCount = 0;
        LinkedHashMap<String, BulkItemResponse> deduplicatedFailures = new LinkedHashMap<String, BulkItemResponse>();
        for (BulkItemResponse item : bulkResponse.getItems()) {
            if (!item.isFailed()) continue;
            deduplicatedFailures.putIfAbsent(item.getFailure().getCause().getClass().getSimpleName(), item);
            ++failureCount;
        }
        Throwable irrecoverableException = ExceptionRootCauseFinder.getFirstIrrecoverableExceptionFromBulkResponses(deduplicatedFailures.values());
        if (irrecoverableException == null) {
            String failureMessage = ClientTransformIndexer.getBulkIndexDetailedFailureMessage("Significant failures: ", deduplicatedFailures);
            logger.debug("[{}] Bulk index experienced [{}] failures. {}", (Object)this.getJobId(), (Object)failureCount, (Object)failureMessage);
            Exception firstException = ((BulkItemResponse)deduplicatedFailures.values().iterator().next()).getFailure().getCause();
            nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced [{}] failures. {}", firstException, false, failureCount, failureMessage)));
        } else {
            deduplicatedFailures.remove(irrecoverableException.getClass().getSimpleName());
            String failureMessage = ClientTransformIndexer.getBulkIndexDetailedFailureMessage("Other failures: ", deduplicatedFailures);
            irrecoverableException = ClientTransformIndexer.decorateBulkIndexException(irrecoverableException);
            logger.debug("[{}] Bulk index experienced [{}] failures and at least 1 irrecoverable [{}]. {}", (Object)this.getJobId(), (Object)failureCount, (Object)ExceptionRootCauseFinder.getDetailedMessage(irrecoverableException), (Object)failureMessage);
            nextPhase.onFailure((Exception)((Object)new BulkIndexingException("Bulk index experienced [{}] failures and at least 1 irrecoverable [{}]. {}", irrecoverableException, true, failureCount, ExceptionRootCauseFinder.getDetailedMessage(irrecoverableException), failureMessage)));
        }
    }

    @Override
    protected void doDeleteByQuery(DeleteByQueryRequest deleteByQueryRequest, ActionListener<BulkByScrollResponse> responseListener) {
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)DeleteByQueryAction.INSTANCE, (ActionRequest)deleteByQueryRequest, responseListener);
    }

    @Override
    protected void refreshDestinationIndex(ActionListener<RefreshResponse> responseListener) {
        ClientHelper.executeAsyncWithOrigin((Client)this.client, (String)"transform", (ActionType)RefreshAction.INSTANCE, (ActionRequest)new RefreshRequest(new String[]{this.transformConfig.getDestination().getIndex()}), responseListener);
    }

    @Override
    void doGetInitialProgress(SearchRequest request, ActionListener<SearchResponse> responseListener) {
        ClientHelper.executeWithHeadersAsync((Map)this.transformConfig.getHeaders(), (String)"transform", (Client)this.client, (ActionType)SearchAction.INSTANCE, (ActionRequest)request, responseListener);
    }

    @Override
    void doGetFieldMappings(ActionListener<Map<String, String>> fieldMappingsListener) {
        SchemaUtil.getDestinationFieldMappings(this.client, this.getConfig().getDestination().getIndex(), fieldMappingsListener);
    }

    protected void doSaveState(IndexerState indexerState, TransformIndexerPosition position, Runnable next) {
        if (this.context.getTaskState() == TransformTaskState.FAILED) {
            logger.debug("[{}] attempted to save state and stats while failed.", (Object)this.getJobId());
            next.run();
            return;
        }
        if (indexerState.equals((Object)IndexerState.ABORTING)) {
            next.run();
            return;
        }
        Collection saveStateListenersAtTheMomentOfCalling = this.saveStateListeners.getAndSet(null);
        boolean shouldStopAtCheckpoint = this.context.shouldStopAtCheckpoint();
        if (shouldStopAtCheckpoint && this.initialRun() && indexerState.equals((Object)IndexerState.STARTED)) {
            indexerState = IndexerState.STOPPED;
            this.auditor.info(this.transformConfig.getId(), "Transform is no longer in the middle of a checkpoint, initiating stop.");
            logger.info("[{}] transform is no longer in the middle of a checkpoint, initiating stop.", (Object)this.transformConfig.getId());
        }
        if (!this.hasSourceChanged && !indexerState.equals((Object)IndexerState.STOPPED)) {
            if (saveStateListenersAtTheMomentOfCalling != null) {
                ActionListener.onResponse((Iterable)saveStateListenersAtTheMomentOfCalling, null);
            }
            next.run();
            return;
        }
        TransformTaskState taskState = this.context.getTaskState();
        if (indexerState.equals((Object)IndexerState.STARTED) && this.context.getCheckpoint() == 1L && !this.isContinuous()) {
            indexerState = IndexerState.STOPPED;
            this.auditor.info(this.transformConfig.getId(), "Transform finished indexing all data, initiating stop");
            logger.info("[{}] transform finished indexing all data, initiating stop.", (Object)this.transformConfig.getId());
        }
        if (indexerState.equals((Object)IndexerState.STOPPED)) {
            shouldStopAtCheckpoint = false;
            taskState = TransformTaskState.STOPPED;
        }
        TransformState state = new TransformState(taskState, indexerState, position, this.context.getCheckpoint(), this.context.getStateReason(), this.getProgress(), null, shouldStopAtCheckpoint);
        logger.debug("[{}] updating persistent state of transform to [{}].", (Object)this.transformConfig.getId(), (Object)state.toString());
        this.doSaveState(state, (ActionListener<Void>)ActionListener.wrap(r -> {
            try {
                if (saveStateListenersAtTheMomentOfCalling != null) {
                    ActionListener.onResponse((Iterable)saveStateListenersAtTheMomentOfCalling, (Object)r);
                }
            }
            catch (Exception onResponseException) {
                String msg = LoggerMessageFormat.format((String)"[{}] failed notifying saveState listeners, ignoring.", (String)this.getJobId(), (Object[])new Object[0]);
                logger.warn(msg, (Throwable)onResponseException);
            }
            finally {
                next.run();
            }
        }, e -> {
            try {
                if (saveStateListenersAtTheMomentOfCalling != null) {
                    ActionListener.onFailure((Iterable)saveStateListenersAtTheMomentOfCalling, (Exception)e);
                }
            }
            catch (Exception onFailureException) {
                String msg = LoggerMessageFormat.format((String)"[{}] failed notifying saveState listeners, ignoring.", (String)this.getJobId(), (Object[])new Object[0]);
                logger.warn(msg, (Throwable)onFailureException);
            }
            finally {
                next.run();
            }
        }));
    }

    private void doSaveState(TransformState state, ActionListener<Void> listener) {
        SeqNoPrimaryTermAndIndex seqNoPrimaryTermAndIndex = this.getSeqNoPrimaryTermAndIndex();
        this.transformsConfigManager.putOrUpdateTransformStoredDoc(new TransformStoredDoc(this.getJobId(), state, (TransformIndexerStats)this.getStats()), seqNoPrimaryTermAndIndex, (ActionListener<SeqNoPrimaryTermAndIndex>)ActionListener.wrap(r -> {
            this.updateSeqNoPrimaryTermAndIndex(seqNoPrimaryTermAndIndex, (SeqNoPrimaryTermAndIndex)r);
            if (state.getTaskState().equals((Object)TransformTaskState.STOPPED)) {
                this.context.shutdown();
            }
            if (this.oldStatsCleanedUp.compareAndSet(false, true)) {
                this.transformsConfigManager.deleteOldTransformStoredDocuments(this.getJobId(), (ActionListener<Long>)ActionListener.wrap(deletedDocs -> {
                    logger.trace("[{}] deleted old transform stats and state document, deleted: [{}] documents", (Object)this.getJobId(), deletedDocs);
                    listener.onResponse(null);
                }, e -> {
                    String msg = LoggerMessageFormat.format((String)"[{}] failed deleting old transform configurations.", (String)this.getJobId(), (Object[])new Object[0]);
                    logger.warn(msg, (Throwable)e);
                    this.oldStatsCleanedUp.set(false);
                    listener.onResponse(null);
                }));
            } else {
                listener.onResponse(null);
            }
        }, statsExc -> {
            if (ExceptionsHelper.unwrapCause((Throwable)statsExc) instanceof VersionConflictEngineException) {
                logger.error((Message)new ParameterizedMessage("[{}] updating stats of transform failed, unexpected version conflict of internal state, resetting to recover.", (Object)this.transformConfig.getId()), (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform, unexpected version conflict of internal state, resetting to recover: " + statsExc.getMessage());
                assert (false) : "[" + this.getJobId() + "] updating stats of transform failed, unexpected version conflict of internal state";
            } else {
                logger.error((Message)new ParameterizedMessage("[{}] updating stats of transform failed.", (Object)this.transformConfig.getId()), (Throwable)statsExc);
                this.auditor.warning(this.getJobId(), "Failure updating stats of transform: " + statsExc.getMessage());
            }
            if (state.getTaskState().equals((Object)TransformTaskState.STOPPED)) {
                this.context.shutdown();
            }
            listener.onFailure(statsExc);
        }));
    }

    void updateSeqNoPrimaryTermAndIndex(SeqNoPrimaryTermAndIndex expectedValue, SeqNoPrimaryTermAndIndex newValue) {
        logger.debug(() -> new ParameterizedMessage("[{}] Updated state document from [{}] to [{}]", new Object[]{this.transformConfig.getId(), expectedValue, newValue}));
        boolean updated = this.seqNoPrimaryTermAndIndex.compareAndSet(expectedValue, newValue);
        if (!updated) {
            logger.warn("[{}] Unexpected change to internal state detected, expected [{}], got [{}]", (Object)this.transformConfig.getId(), (Object)expectedValue, (Object)this.seqNoPrimaryTermAndIndex.get());
            assert (updated) : "[" + this.getJobId() + "] unexpected change to seqNoPrimaryTermAndIndex.";
        }
    }

    @Nullable
    SeqNoPrimaryTermAndIndex getSeqNoPrimaryTermAndIndex() {
        return this.seqNoPrimaryTermAndIndex.get();
    }

    private static String getBulkIndexDetailedFailureMessage(String prefix, Map<String, BulkItemResponse> failures) {
        if (failures.isEmpty()) {
            return "";
        }
        StringBuilder failureMessageBuilder = new StringBuilder(prefix);
        for (Map.Entry<String, BulkItemResponse> failure : failures.entrySet()) {
            failureMessageBuilder.append("\n[").append(failure.getKey()).append("] message [").append(failure.getValue().getFailureMessage()).append("]");
        }
        String failureMessage = failureMessageBuilder.toString();
        return failureMessage;
    }

    private static Throwable decorateBulkIndexException(Throwable irrecoverableException) {
        if (irrecoverableException instanceof MapperParsingException) {
            return new TransformException("Destination index mappings are incompatible with the transform configuration.", irrecoverableException, new Object[0]);
        }
        return irrecoverableException;
    }
}

