/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.transform.checkpoint;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArraySet;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteConnectionStrategy;

class RemoteClusterResolver
extends RemoteClusterAware {
    private final CopyOnWriteArraySet<String> clusters;

    RemoteClusterResolver(Settings settings, ClusterSettings clusterSettings) {
        super(settings);
        this.clusters = new CopyOnWriteArraySet(RemoteClusterResolver.getEnabledRemoteClusters((Settings)settings));
        this.listenForUpdates(clusterSettings);
    }

    protected void updateRemoteCluster(String clusterAlias, Settings settings) {
        if (RemoteConnectionStrategy.isConnectionEnabled((String)clusterAlias, (Settings)settings)) {
            this.clusters.add(clusterAlias);
        } else {
            this.clusters.remove(clusterAlias);
        }
    }

    ResolvedIndices resolve(String ... indices) {
        Map resolvedClusterIndices = this.groupClusterIndices(this.clusters, indices, i -> false);
        List<String> localIndices = resolvedClusterIndices.getOrDefault("", Collections.emptyList());
        resolvedClusterIndices.remove("");
        return new ResolvedIndices(resolvedClusterIndices, localIndices);
    }

    static class ResolvedIndices {
        private final Map<String, List<String>> remoteIndicesPerClusterAlias;
        private final List<String> localIndices;

        ResolvedIndices(Map<String, List<String>> remoteIndicesPerClusterAlias, List<String> localIndices) {
            this.localIndices = localIndices;
            this.remoteIndicesPerClusterAlias = remoteIndicesPerClusterAlias;
        }

        public Map<String, List<String>> getRemoteIndicesPerClusterAlias() {
            return this.remoteIndicesPerClusterAlias;
        }

        public List<String> getLocalIndices() {
            return this.localIndices;
        }

        public int numClusters() {
            return this.remoteIndicesPerClusterAlias.size() + (this.localIndices.isEmpty() ? 0 : 1);
        }
    }
}

