/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.unsignedlong;

import java.io.IOException;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.util.ArrayUtil;
import org.elasticsearch.index.fielddata.ScriptDocValues;
import org.elasticsearch.search.DocValueFormat;

public class UnsignedLongScriptDocValues
extends ScriptDocValues<Number> {
    private final SortedNumericDocValues in;
    private long[] values = new long[0];
    private int count;

    public UnsignedLongScriptDocValues(SortedNumericDocValues in) {
        this.in = in;
    }

    public void setNextDocId(int docId) throws IOException {
        if (this.in.advanceExact(docId)) {
            this.resize(this.in.docValueCount());
            for (int i = 0; i < this.count; ++i) {
                this.values[i] = this.in.nextValue();
            }
        } else {
            this.resize(0);
        }
    }

    protected void resize(int newSize) {
        this.count = newSize;
        this.values = ArrayUtil.grow((long[])this.values, (int)this.count);
    }

    public Number getValue() {
        return this.get(0);
    }

    public Number get(int index) {
        if (this.count == 0) {
            throw new IllegalStateException("A document doesn't have a value for a field! Use doc[<field>].size()==0 to check if a document is missing a field!");
        }
        return (Number)DocValueFormat.UNSIGNED_LONG_SHIFTED.format(this.values[index]);
    }

    public int size() {
        return this.count;
    }
}

