/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.rest.action;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.XPackClient;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkRequestBuilder;
import org.elasticsearch.xpack.core.monitoring.action.MonitoringBulkResponse;
import org.elasticsearch.xpack.core.rest.XPackRestHandler;

public class RestMonitoringBulkAction
extends XPackRestHandler {
    public static final String MONITORING_ID = "system_id";
    public static final String MONITORING_VERSION = "system_api_version";
    public static final String INTERVAL = "interval";
    private static final List<String> ALL_VERSIONS = Arrays.asList("7", "6");
    private static final Map<MonitoredSystem, List<String>> SUPPORTED_API_VERSIONS = Collections.unmodifiableMap(MapBuilder.newMapBuilder().put((Object)MonitoredSystem.KIBANA, ALL_VERSIONS).put((Object)MonitoredSystem.LOGSTASH, ALL_VERSIONS).put((Object)MonitoredSystem.BEATS, ALL_VERSIONS).map());

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)"/_monitoring/bulk").replaces(RestRequest.Method.POST, "/_xpack/monitoring/_bulk", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.PUT, (String)"/_monitoring/bulk").replaces(RestRequest.Method.PUT, "/_xpack/monitoring/_bulk", RestApiVersion.V_7).build()));
    }

    public String getName() {
        return "monitoring_bulk";
    }

    public BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest request, XPackClient client) throws IOException {
        String id = request.param(MONITORING_ID);
        if (Strings.isEmpty((CharSequence)id)) {
            throw new IllegalArgumentException("no [system_id] for monitoring bulk request");
        }
        String version = request.param(MONITORING_VERSION);
        if (Strings.isEmpty((CharSequence)version)) {
            throw new IllegalArgumentException("no [system_api_version] for monitoring bulk request");
        }
        String intervalAsString = request.param(INTERVAL);
        if (Strings.isEmpty((CharSequence)intervalAsString)) {
            throw new IllegalArgumentException("no [interval] for monitoring bulk request");
        }
        if (!request.hasContentOrSourceParam()) {
            throw new ElasticsearchParseException("no body content for monitoring bulk request", new Object[0]);
        }
        MonitoredSystem system = MonitoredSystem.fromSystem((String)id);
        if (!this.isSupportedSystemVersion(system, version)) {
            throw new IllegalArgumentException("system_api_version [" + version + "] is not supported by " + MONITORING_ID + " [" + id + "]");
        }
        long timestamp = System.currentTimeMillis();
        long intervalMillis = TimeValue.parseTimeValue((String)intervalAsString, (String)INTERVAL).getMillis();
        MonitoringBulkRequestBuilder requestBuilder = client.monitoring().prepareMonitoringBulk();
        requestBuilder.add(system, request.content(), request.getXContentType(), timestamp, intervalMillis);
        return channel -> requestBuilder.execute((ActionListener)new RestBuilderListener<MonitoringBulkResponse>(channel){

            public RestResponse buildResponse(MonitoringBulkResponse response, XContentBuilder builder) throws Exception {
                builder.startObject();
                builder.field("took", response.getTookInMillis());
                builder.field("ignored", response.isIgnored());
                MonitoringBulkResponse.Error error = response.getError();
                builder.field("errors", error != null);
                if (error != null) {
                    builder.field("error", (ToXContent)response.getError());
                }
                builder.endObject();
                return new BytesRestResponse(response.status(), builder);
            }
        });
    }

    public boolean supportsContentStream() {
        return true;
    }

    private boolean isSupportedSystemVersion(MonitoredSystem system, String version) {
        List monitoredSystem = SUPPORTED_API_VERSIONS.getOrDefault(system, Collections.emptyList());
        return monitoredSystem.contains(version);
    }
}

