/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.search;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.search.SearchTask;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.Scroll;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskId;

public class SearchScrollRequest
extends ActionRequest
implements ToXContentObject {
    private String scrollId;
    private Scroll scroll;

    public SearchScrollRequest() {
    }

    public SearchScrollRequest(String scrollId) {
        this.scrollId = scrollId;
    }

    public SearchScrollRequest(StreamInput in) throws IOException {
        super(in);
        this.scrollId = in.readString();
        this.scroll = in.readOptionalWriteable(Scroll::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.scrollId);
        out.writeOptionalWriteable(this.scroll);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.scrollId == null) {
            validationException = ValidateActions.addValidationError("scrollId is missing", validationException);
        }
        return validationException;
    }

    public String scrollId() {
        return this.scrollId;
    }

    public SearchScrollRequest scrollId(String scrollId) {
        this.scrollId = scrollId;
        return this;
    }

    public Scroll scroll() {
        return this.scroll;
    }

    public SearchScrollRequest scroll(Scroll scroll) {
        this.scroll = scroll;
        return this;
    }

    public SearchScrollRequest scroll(TimeValue keepAlive) {
        return this.scroll(new Scroll(keepAlive));
    }

    public SearchScrollRequest scroll(String keepAlive) {
        return this.scroll(new Scroll(TimeValue.parseTimeValue((String)keepAlive, null, (String)(this.getClass().getSimpleName() + ".keepAlive"))));
    }

    @Override
    public void readFrom(StreamInput in) throws IOException {
        throw new UnsupportedOperationException("usage of Streamable is to be replaced by Writeable");
    }

    @Override
    public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
        return new SearchTask(id, type, action, this.getDescription(), parentTaskId, headers);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchScrollRequest that = (SearchScrollRequest)o;
        return Objects.equals(this.scrollId, that.scrollId) && Objects.equals(this.scroll, that.scroll);
    }

    public int hashCode() {
        return Objects.hash(this.scrollId, this.scroll);
    }

    public String toString() {
        return "SearchScrollRequest{scrollId='" + this.scrollId + '\'' + ", scroll=" + this.scroll + '}';
    }

    @Override
    public String getDescription() {
        return "scrollId[" + this.scrollId + "], scroll[" + this.scroll + "]";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("scroll_id", this.scrollId);
        if (this.scroll != null) {
            builder.field("scroll", this.scroll.keepAlive().getStringRep());
        }
        builder.endObject();
        return builder;
    }

    public void fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        if (parser.nextToken() != XContentParser.Token.START_OBJECT) {
            throw new IllegalArgumentException("Malformed content, must start with an object");
        }
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if ("scroll_id".equals(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                this.scrollId(parser.text());
                continue;
            }
            if ("scroll".equals(currentFieldName) && token == XContentParser.Token.VALUE_STRING) {
                this.scroll(new Scroll(TimeValue.parseTimeValue((String)parser.text(), null, (String)"scroll")));
                continue;
            }
            throw new IllegalArgumentException("Unknown parameter [" + currentFieldName + "] in request body or parameter is of the wrong type[" + token + "] ");
        }
    }
}

