/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport.nio;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.recycler.Recycler;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.nio.BytesChannelContext;
import org.elasticsearch.nio.ChannelFactory;
import org.elasticsearch.nio.InboundChannelBuffer;
import org.elasticsearch.nio.NioSelector;
import org.elasticsearch.nio.NioServerSocketChannel;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.nio.ReadWriteHandler;
import org.elasticsearch.nio.ServerChannelContext;
import org.elasticsearch.nio.SocketChannelContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpServerChannel;
import org.elasticsearch.transport.TcpTransport;
import org.elasticsearch.transport.nio.NioGroupFactory;
import org.elasticsearch.transport.nio.NioTcpChannel;
import org.elasticsearch.transport.nio.NioTcpServerChannel;
import org.elasticsearch.transport.nio.NioTransport;
import org.elasticsearch.transport.nio.TcpReadWriteHandler;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.transport.SSLExceptionHelper;
import org.elasticsearch.xpack.core.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.transport.filter.IPFilter;
import org.elasticsearch.xpack.security.transport.nio.NioIPFilter;
import org.elasticsearch.xpack.security.transport.nio.SSLChannelContext;
import org.elasticsearch.xpack.security.transport.nio.SSLDriver;

public class SecurityNioTransport
extends NioTransport {
    private static final Logger logger = LogManager.getLogger(SecurityNioTransport.class);
    private final IPFilter authenticator;
    private final SSLService sslService;
    private final Map<String, SSLConfiguration> profileConfiguration;
    private final boolean sslEnabled;

    public SecurityNioTransport(Settings settings, Version version, ThreadPool threadPool, NetworkService networkService, PageCacheRecycler pageCacheRecycler, NamedWriteableRegistry namedWriteableRegistry, CircuitBreakerService circuitBreakerService, @Nullable IPFilter authenticator, SSLService sslService, NioGroupFactory groupFactory) {
        super(settings, version, threadPool, networkService, pageCacheRecycler, namedWriteableRegistry, circuitBreakerService, groupFactory);
        this.authenticator = authenticator;
        this.sslService = sslService;
        this.sslEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(settings);
        if (this.sslEnabled) {
            SSLConfiguration transportConfiguration = sslService.getSSLConfiguration(SecurityField.setting((String)"transport.ssl."));
            Map profileConfiguration = SecurityNetty4Transport.getTransportProfileConfigurations((Settings)settings, (SSLService)sslService, (SSLConfiguration)transportConfiguration);
            this.profileConfiguration = Collections.unmodifiableMap(profileConfiguration);
        } else {
            this.profileConfiguration = Collections.emptyMap();
        }
    }

    protected void doStart() {
        super.doStart();
        if (this.authenticator != null) {
            this.authenticator.setBoundTransportAddress(this.boundAddress(), this.profileBoundAddresses());
        }
    }

    public void onException(TcpChannel channel, Exception e) {
        if (!this.lifecycle.started()) {
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isNotSslRecordException((Throwable)e)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)new ParameterizedMessage("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                logger.warn("received plaintext traffic on an encrypted channel, closing connection {}", (Object)channel);
            }
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isCloseDuringHandshakeException((Throwable)e)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)new ParameterizedMessage("connection {} closed during ssl handshake", (Object)channel), (Throwable)e);
            } else {
                logger.warn("connection {} closed during handshake", (Object)channel);
            }
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else if (SSLExceptionHelper.isReceivedCertificateUnknownException((Throwable)e)) {
            if (logger.isTraceEnabled()) {
                logger.trace((Message)new ParameterizedMessage("client did not trust server's certificate, closing connection {}", (Object)channel), (Throwable)e);
            } else {
                logger.warn("client did not trust this server's certificate, closing connection {}", (Object)channel);
            }
            CloseableChannel.closeChannel((CloseableChannel)channel);
        } else {
            super.onException(channel, e);
        }
    }

    protected NioTransport.TcpChannelFactory serverChannelFactory(TcpTransport.ProfileSettings profileSettings) {
        return new SecurityTcpChannelFactory(profileSettings, false);
    }

    protected Function<DiscoveryNode, NioTransport.TcpChannelFactory> clientChannelFactoryFunction(TcpTransport.ProfileSettings profileSettings) {
        return node -> {
            SNIHostName serverName;
            ChannelFactory.RawChannelFactory rawChannelFactory = new ChannelFactory.RawChannelFactory(profileSettings.tcpNoDelay, profileSettings.tcpKeepAlive, profileSettings.reuseAddress, Math.toIntExact(profileSettings.sendBufferSize.getBytes()), Math.toIntExact(profileSettings.receiveBufferSize.getBytes()));
            String configuredServerName = (String)node.getAttributes().get("server_name");
            if (configuredServerName != null) {
                try {
                    serverName = new SNIHostName(configuredServerName);
                }
                catch (IllegalArgumentException e) {
                    throw new ConnectTransportException(node, "invalid DiscoveryNode server_name [" + configuredServerName + "]", (Throwable)e);
                }
            } else {
                serverName = null;
            }
            return new SecurityClientTcpChannelFactory(rawChannelFactory, serverName);
        };
    }

    private class SecurityClientTcpChannelFactory
    extends SecurityTcpChannelFactory {
        private final SNIHostName serverName;

        private SecurityClientTcpChannelFactory(ChannelFactory.RawChannelFactory rawChannelFactory, SNIHostName serverName) {
            super(rawChannelFactory, "default", true);
            this.serverName = serverName;
        }

        @Override
        public NioTcpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel) {
            throw new AssertionError((Object)"Cannot create TcpServerChannel with client factory");
        }

        @Override
        protected SSLEngine createSSLEngine(SocketChannel channel) throws IOException {
            SSLEngine sslEngine = super.createSSLEngine(channel);
            if (this.serverName != null) {
                SSLParameters sslParameters = sslEngine.getSSLParameters();
                sslParameters.setServerNames(Collections.singletonList(this.serverName));
                sslEngine.setSSLParameters(sslParameters);
            }
            return sslEngine;
        }
    }

    private class SecurityTcpChannelFactory
    extends NioTransport.TcpChannelFactory {
        private final String profileName;
        private final boolean isClient;
        private final NioIPFilter ipFilter;

        private SecurityTcpChannelFactory(TcpTransport.ProfileSettings profileSettings, boolean isClient) {
            this(new ChannelFactory.RawChannelFactory(profileSettings.tcpNoDelay, profileSettings.tcpKeepAlive, profileSettings.reuseAddress, Math.toIntExact(profileSettings.sendBufferSize.getBytes()), Math.toIntExact(profileSettings.receiveBufferSize.getBytes())), profileSettings.profileName, isClient);
        }

        private SecurityTcpChannelFactory(ChannelFactory.RawChannelFactory rawChannelFactory, String profileName, boolean isClient) {
            super((NioTransport)SecurityNioTransport.this, rawChannelFactory);
            this.profileName = profileName;
            this.isClient = isClient;
            this.ipFilter = new NioIPFilter(SecurityNioTransport.this.authenticator, profileName);
        }

        public NioTcpChannel createChannel(NioSelector selector, SocketChannel channel) throws IOException {
            Object context;
            NioTcpChannel nioChannel = new NioTcpChannel(!this.isClient, this.profileName, channel);
            Supplier<InboundChannelBuffer.Page> pageSupplier = () -> {
                Recycler.V bytes = SecurityNioTransport.this.pageCacheRecycler.bytePage(false);
                return new InboundChannelBuffer.Page(ByteBuffer.wrap((byte[])bytes.v()), () -> ((Recycler.V)bytes).close());
            };
            TcpReadWriteHandler readWriteHandler = new TcpReadWriteHandler(nioChannel, (TcpTransport)SecurityNioTransport.this);
            InboundChannelBuffer buffer = new InboundChannelBuffer(pageSupplier);
            Consumer<Exception> exceptionHandler = e -> SecurityNioTransport.this.onException((TcpChannel)nioChannel, (Exception)e);
            if (SecurityNioTransport.this.sslEnabled) {
                SSLDriver sslDriver = new SSLDriver(this.createSSLEngine(channel), this.isClient);
                context = new SSLChannelContext((NioSocketChannel)nioChannel, selector, exceptionHandler, sslDriver, (ReadWriteHandler)readWriteHandler, buffer, this.ipFilter);
            } else {
                context = new BytesChannelContext((NioSocketChannel)nioChannel, selector, exceptionHandler, (ReadWriteHandler)readWriteHandler, buffer, (Predicate)this.ipFilter);
            }
            nioChannel.setContext((SocketChannelContext)context);
            return nioChannel;
        }

        public NioTcpServerChannel createServerChannel(NioSelector selector, ServerSocketChannel channel) throws IOException {
            NioTcpServerChannel nioChannel = new NioTcpServerChannel(this.profileName, channel);
            Consumer<Exception> exceptionHandler = e -> SecurityNioTransport.this.onServerException((TcpServerChannel)nioChannel, e);
            Consumer<NioSocketChannel> acceptor = x$0 -> SecurityNioTransport.this.acceptChannel(x$0);
            ServerChannelContext context = new ServerChannelContext((NioServerSocketChannel)nioChannel, (ChannelFactory)this, selector, acceptor, exceptionHandler);
            nioChannel.setContext(context);
            return nioChannel;
        }

        protected SSLEngine createSSLEngine(SocketChannel channel) throws IOException {
            SSLEngine sslEngine;
            SSLConfiguration defaultConfig = (SSLConfiguration)SecurityNioTransport.this.profileConfiguration.get("default");
            SSLConfiguration sslConfig = SecurityNioTransport.this.profileConfiguration.getOrDefault(this.profileName, defaultConfig);
            boolean hostnameVerificationEnabled = sslConfig.verificationMode().isHostnameVerificationEnabled();
            if (hostnameVerificationEnabled) {
                InetSocketAddress inetSocketAddress = (InetSocketAddress)channel.getRemoteAddress();
                sslEngine = SecurityNioTransport.this.sslService.createSSLEngine(sslConfig, inetSocketAddress.getHostString(), inetSocketAddress.getPort());
            } else {
                sslEngine = SecurityNioTransport.this.sslService.createSSLEngine(sslConfig, null, -1);
            }
            return sslEngine;
        }
    }
}

