/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.IndicesRequest;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.transport.TaskTransportChannel;
import org.elasticsearch.transport.TcpChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.nio.NioTcpChannel;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.support.Exceptions;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.action.SecurityActionMapper;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.transport.SSLEngineUtils;

public interface ServerTransportFilter {
    public void inbound(String var1, TransportRequest var2, TransportChannel var3, ActionListener<Void> var4) throws IOException;

    public static class ClientProfile
    extends NodeProfile {
        ClientProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, boolean reservedRealmEnabled, SecurityContext securityContext, XPackLicenseState licenseState) {
            super(authcService, authzService, threadContext, extractClientCert, destructiveOperations, reservedRealmEnabled, securityContext, licenseState);
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            boolean isInternalOrShardAction;
            boolean bl = isInternalOrShardAction = action.startsWith("internal:") || action.endsWith("]");
            if (isInternalOrShardAction && !"internal:transport/handshake".equals(action)) {
                throw Exceptions.authenticationError((String)"executing internal/shard actions is considered malicious and forbidden", (Object[])new Object[0]);
            }
            super.inbound(action, request, transportChannel, listener);
        }
    }

    public static class NodeProfile
    implements ServerTransportFilter {
        private static final Logger logger = LogManager.getLogger(NodeProfile.class);
        private final AuthenticationService authcService;
        private final AuthorizationService authzService;
        private final SecurityActionMapper actionMapper = new SecurityActionMapper();
        private final ThreadContext threadContext;
        private final boolean extractClientCert;
        private final DestructiveOperations destructiveOperations;
        private final boolean reservedRealmEnabled;
        private final SecurityContext securityContext;
        private final XPackLicenseState licenseState;

        NodeProfile(AuthenticationService authcService, AuthorizationService authzService, ThreadContext threadContext, boolean extractClientCert, DestructiveOperations destructiveOperations, boolean reservedRealmEnabled, SecurityContext securityContext, XPackLicenseState licenseState) {
            this.authcService = authcService;
            this.authzService = authzService;
            this.threadContext = threadContext;
            this.extractClientCert = extractClientCert;
            this.destructiveOperations = destructiveOperations;
            this.reservedRealmEnabled = reservedRealmEnabled;
            this.securityContext = securityContext;
            this.licenseState = licenseState;
        }

        @Override
        public void inbound(String action, TransportRequest request, TransportChannel transportChannel, ActionListener<Void> listener) throws IOException {
            TcpChannel tcpChannel;
            if ("indices:admin/close".equals(action) || "indices:admin/open".equals(action) || "indices:admin/delete".equals(action)) {
                IndicesRequest indicesRequest = (IndicesRequest)request;
                try {
                    this.destructiveOperations.failDestructive(indicesRequest.indices());
                }
                catch (IllegalArgumentException e) {
                    listener.onFailure((Exception)e);
                    return;
                }
            }
            String securityAction = this.actionMapper.action(action, request);
            TransportChannel unwrappedChannel = transportChannel;
            if (unwrappedChannel instanceof TaskTransportChannel) {
                unwrappedChannel = ((TaskTransportChannel)unwrappedChannel).getChannel();
            }
            if (this.extractClientCert && unwrappedChannel instanceof TcpTransportChannel && ((tcpChannel = ((TcpTransportChannel)unwrappedChannel).getChannel()) instanceof Netty4TcpChannel || tcpChannel instanceof NioTcpChannel) && tcpChannel.isOpen()) {
                SSLEngineUtils.extractClientCertificates(logger, this.threadContext, tcpChannel);
            }
            Version version = transportChannel.getVersion();
            this.authcService.authenticate(securityAction, (TransportMessage)request, (User)null, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                if (authentication != null) {
                    if (securityAction.equals("internal:transport/handshake") && !SystemUser.is((User)authentication.getUser())) {
                        this.securityContext.executeAsUser(SystemUser.INSTANCE, ctx -> {
                            Authentication replaced = Authentication.getAuthentication((ThreadContext)this.threadContext);
                            this.authzService.authorize(replaced, securityAction, request, listener);
                        }, version);
                    } else {
                        this.authzService.authorize((Authentication)authentication, securityAction, request, listener);
                    }
                } else if (!this.licenseState.isAuthAllowed()) {
                    listener.onResponse(null);
                } else {
                    listener.onFailure((Exception)new IllegalStateException("no authentication present but auth is allowed"));
                }
            }, arg_0 -> listener.onFailure(arg_0)));
        }
    }
}

