/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.transport;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.DestructiveOperations;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.AbstractRunnable;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.SecurityField;
import org.elasticsearch.xpack.core.security.transport.netty4.SecurityNetty4Transport;
import org.elasticsearch.xpack.core.security.user.SystemUser;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authz.AuthorizationService;
import org.elasticsearch.xpack.security.authz.AuthorizationUtils;
import org.elasticsearch.xpack.security.transport.ServerTransportFilter;

public class SecurityServerTransportInterceptor
implements TransportInterceptor {
    private static final Function<String, Setting<String>> TRANSPORT_TYPE_SETTING_TEMPLATE = key -> new Setting(key, "node", v -> {
        if (v.equals("node") || v.equals("client")) {
            return v;
        }
        throw new IllegalArgumentException("type must be one of [client, node]");
    }, new Setting.Property[]{Setting.Property.NodeScope});
    private static final String TRANSPORT_TYPE_SETTING_KEY = "xpack.security.type";
    private static final Logger logger = LogManager.getLogger(SecurityServerTransportInterceptor.class);
    public static final Setting.AffixSetting<String> TRANSPORT_TYPE_PROFILE_SETTING = Setting.affixKeySetting((String)"transport.profiles.", (String)"xpack.security.type", TRANSPORT_TYPE_SETTING_TEMPLATE, (Setting.AffixSetting[])new Setting.AffixSetting[0]);
    private final AuthenticationService authcService;
    private final AuthorizationService authzService;
    private final SSLService sslService;
    private final Map<String, ServerTransportFilter> profileFilters;
    private final XPackLicenseState licenseState;
    private final ThreadPool threadPool;
    private final Settings settings;
    private final SecurityContext securityContext;
    private final boolean reservedRealmEnabled;
    private volatile boolean isStateNotRecovered = true;

    public SecurityServerTransportInterceptor(Settings settings, ThreadPool threadPool, AuthenticationService authcService, AuthorizationService authzService, XPackLicenseState licenseState, SSLService sslService, SecurityContext securityContext, DestructiveOperations destructiveOperations, ClusterService clusterService) {
        this.settings = settings;
        this.threadPool = threadPool;
        this.authcService = authcService;
        this.authzService = authzService;
        this.licenseState = licenseState;
        this.sslService = sslService;
        this.securityContext = securityContext;
        this.profileFilters = this.initializeProfileFilters(destructiveOperations);
        this.reservedRealmEnabled = (Boolean)XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings);
        clusterService.addListener(e -> {
            this.isStateNotRecovered = e.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK);
        });
    }

    public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
        return new TransportInterceptor.AsyncSender(){

            public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                boolean sendWithAuth;
                boolean stateNotRecovered = SecurityServerTransportInterceptor.this.isStateNotRecovered;
                boolean bl = sendWithAuth = SecurityServerTransportInterceptor.this.licenseState.isAuthAllowed() || stateNotRecovered;
                if (sendWithAuth) {
                    Version minVersion = Version.min((Version)connection.getVersion(), (Version)Version.CURRENT);
                    if (AuthorizationUtils.shouldReplaceUserWithSystem(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), action)) {
                        SecurityServerTransportInterceptor.this.securityContext.executeAsUser(SystemUser.INSTANCE, original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender, stateNotRecovered), minVersion);
                    } else if (AuthorizationUtils.shouldSetUserBasedOnActionOrigin(SecurityServerTransportInterceptor.this.threadPool.getThreadContext())) {
                        AuthorizationUtils.switchUserBasedOnActionOriginAndExecute(SecurityServerTransportInterceptor.this.threadPool.getThreadContext(), SecurityServerTransportInterceptor.this.securityContext, original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender, stateNotRecovered));
                    } else if (SecurityServerTransportInterceptor.this.securityContext.getAuthentication() != null && !SecurityServerTransportInterceptor.this.securityContext.getAuthentication().getVersion().equals((Object)minVersion)) {
                        SecurityServerTransportInterceptor.this.securityContext.executeAfterRewritingAuthentication(original -> SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, (TransportResponseHandler)new TransportService.ContextRestoreResponseHandler(SecurityServerTransportInterceptor.this.threadPool.getThreadContext().wrapRestorable(original), handler), sender, stateNotRecovered), minVersion);
                    } else {
                        SecurityServerTransportInterceptor.this.sendWithUser(connection, action, request, options, handler, sender, stateNotRecovered);
                    }
                } else {
                    sender.sendRequest(connection, action, request, options, handler);
                }
            }
        };
    }

    private <T extends TransportResponse> void sendWithUser(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler, TransportInterceptor.AsyncSender sender, boolean stateNotRecovered) {
        if (this.securityContext.getAuthentication() == null && !stateNotRecovered) {
            this.assertNoAuthentication(action);
            throw new IllegalStateException("there should always be a user when sending a message for action [" + action + "]");
        }
        try {
            sender.sendRequest(connection, action, request, options, handler);
        }
        catch (Exception e) {
            handler.handleException(new TransportException("failed sending request", (Throwable)e));
        }
    }

    void assertNoAuthentication(String action) {
        assert (false) : "there should always be a user when sending a message for action [" + action + "]";
    }

    public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(String action, String executor, boolean forceExecution, TransportRequestHandler<T> actualHandler) {
        return new ProfileSecuredRequestHandler<T>(logger, action, forceExecution, executor, actualHandler, this.profileFilters, this.licenseState, this.threadPool);
    }

    protected Map<String, ServerTransportFilter> initializeProfileFilters(DestructiveOperations destructiveOperations) {
        SSLConfiguration transportSslConfiguration = this.sslService.getSSLConfiguration(SecurityField.setting((String)"transport.ssl"));
        Map profileConfigurations = SecurityNetty4Transport.getTransportProfileConfigurations((Settings)this.settings, (SSLService)this.sslService, (SSLConfiguration)transportSslConfiguration);
        HashMap<String, ServerTransportFilter.NodeProfile> profileFilters = new HashMap<String, ServerTransportFilter.NodeProfile>(profileConfigurations.size() + 1);
        boolean transportSSLEnabled = (Boolean)XPackSettings.TRANSPORT_SSL_ENABLED.get(this.settings);
        block8: for (Map.Entry entry : profileConfigurations.entrySet()) {
            String type;
            SSLConfiguration profileConfiguration = (SSLConfiguration)entry.getValue();
            boolean extractClientCert = transportSSLEnabled && this.sslService.isSSLClientAuthEnabled(profileConfiguration);
            switch (type = (String)TRANSPORT_TYPE_PROFILE_SETTING.getConcreteSettingForNamespace((String)entry.getKey()).get(this.settings)) {
                case "client": {
                    profileFilters.put((String)entry.getKey(), new ServerTransportFilter.ClientProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.reservedRealmEnabled, this.securityContext, this.licenseState));
                    continue block8;
                }
                case "node": {
                    profileFilters.put((String)entry.getKey(), new ServerTransportFilter.NodeProfile(this.authcService, this.authzService, this.threadPool.getThreadContext(), extractClientCert, destructiveOperations, this.reservedRealmEnabled, this.securityContext, this.licenseState));
                    continue block8;
                }
            }
            throw new IllegalStateException("unknown profile type: " + type);
        }
        return Collections.unmodifiableMap(profileFilters);
    }

    public static class ProfileSecuredRequestHandler<T extends TransportRequest>
    implements TransportRequestHandler<T> {
        private final String action;
        private final TransportRequestHandler<T> handler;
        private final Map<String, ServerTransportFilter> profileFilters;
        private final XPackLicenseState licenseState;
        private final ThreadContext threadContext;
        private final String executorName;
        private final ThreadPool threadPool;
        private final boolean forceExecution;
        private final Logger logger;

        ProfileSecuredRequestHandler(Logger logger, String action, boolean forceExecution, String executorName, TransportRequestHandler<T> handler, Map<String, ServerTransportFilter> profileFilters, XPackLicenseState licenseState, ThreadPool threadPool) {
            this.logger = logger;
            this.action = action;
            this.executorName = executorName;
            this.handler = handler;
            this.profileFilters = profileFilters;
            this.licenseState = licenseState;
            this.threadContext = threadPool.getThreadContext();
            this.threadPool = threadPool;
            this.forceExecution = forceExecution;
        }

        AbstractRunnable getReceiveRunnable(T request, final TransportChannel channel, Task task) {
            return new AbstractRunnable((TransportRequest)request, task){
                final /* synthetic */ TransportRequest val$request;
                final /* synthetic */ Task val$task;
                {
                    this.val$request = transportRequest;
                    this.val$task = task;
                }

                public boolean isForceExecution() {
                    return forceExecution;
                }

                public void onFailure(Exception e) {
                    try {
                        channel.sendResponse(e);
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        logger.warn("failed to send exception response for action [" + action + "]", (Throwable)e1);
                    }
                }

                protected void doRun() throws Exception {
                    handler.messageReceived(this.val$request, channel, this.val$task);
                }
            };
        }

        public String toString() {
            return "ProfileSecuredRequestHandler{action='" + this.action + '\'' + ", executorName='" + this.executorName + '\'' + ", forceExecution=" + this.forceExecution + '}';
        }

        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
            AbstractRunnable receiveMessage = this.getReceiveRunnable(request, channel, task);
            try (ThreadContext.StoredContext ctx = this.threadContext.newStoredContext(true);){
                if (this.licenseState.isAuthAllowed()) {
                    String profile = channel.getProfileName();
                    ServerTransportFilter filter = this.profileFilters.get(profile);
                    if (filter == null) {
                        if (".direct".equals(profile)) {
                            filter = this.profileFilters.get("default");
                        } else {
                            String msg = "transport profile [" + profile + "] is not associated with a transport filter";
                            throw new IllegalStateException(msg);
                        }
                    }
                    assert (filter != null);
                    Thread executingThread = Thread.currentThread();
                    CheckedConsumer consumer = x -> {
                        ExecutorService executor = executingThread == Thread.currentThread() ? this.threadPool.executor("same") : this.threadPool.executor(this.executorName);
                        try {
                            executor.execute((Runnable)receiveMessage);
                        }
                        catch (Exception e) {
                            receiveMessage.onFailure(e);
                        }
                    };
                    ActionListener filterListener = ActionListener.wrap((CheckedConsumer)consumer, arg_0 -> ((AbstractRunnable)receiveMessage).onFailure(arg_0));
                    filter.inbound(this.action, (TransportRequest)request, channel, (ActionListener<Void>)filterListener);
                } else {
                    receiveMessage.run();
                }
            }
        }
    }
}

