/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.support;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ElasticsearchStatusException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.UnavailableShardsException;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.health.ClusterHealthStatus;
import org.elasticsearch.cluster.health.ClusterIndexHealth;
import org.elasticsearch.cluster.metadata.AliasOrIndex;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.template.TemplateUtils;

public class SecurityIndexManager
implements ClusterStateListener {
    public static final String INTERNAL_SECURITY_INDEX = ".security-7";
    public static final int INTERNAL_INDEX_FORMAT = 6;
    public static final String SECURITY_VERSION_STRING = "security-version";
    public static final String TEMPLATE_VERSION_PATTERN = Pattern.quote("${security.template.version}");
    public static final String SECURITY_TEMPLATE_NAME = "security-index-template";
    public static final String SECURITY_INDEX_NAME = ".security";
    private static final Logger LOGGER = LogManager.getLogger(SecurityIndexManager.class);
    private final String indexName;
    private final Client client;
    private final List<BiConsumer<State, State>> stateChangeListeners = new CopyOnWriteArrayList<BiConsumer<State, State>>();
    private volatile State indexState;

    public SecurityIndexManager(Client client, String indexName, ClusterService clusterService) {
        this(client, indexName, State.UNRECOVERED_STATE);
        clusterService.addListener((ClusterStateListener)this);
    }

    private SecurityIndexManager(Client client, String indexName, State indexState) {
        this.client = client;
        this.indexName = indexName;
        this.indexState = indexState;
    }

    public SecurityIndexManager freeze() {
        return new SecurityIndexManager(null, this.indexName, this.indexState);
    }

    public boolean checkMappingVersion(Predicate<Version> requiredVersion) {
        State currentIndexState = this.indexState;
        return currentIndexState.mappingVersion == null || requiredVersion.test(currentIndexState.mappingVersion);
    }

    public boolean indexExists() {
        return this.indexState.indexExists;
    }

    public boolean isIndexUpToDate() {
        return this.indexState.isIndexUpToDate;
    }

    public boolean isAvailable() {
        return this.indexState.indexAvailable;
    }

    public boolean isMappingUpToDate() {
        return this.indexState.mappingUpToDate;
    }

    public boolean isStateRecovered() {
        return this.indexState != State.UNRECOVERED_STATE;
    }

    public ElasticsearchException getUnavailableReason() {
        State localState = this.indexState;
        if (localState.indexAvailable) {
            throw new IllegalStateException("caller must make sure to use a frozen state and check indexAvailable");
        }
        if (localState.indexExists) {
            return new UnavailableShardsException(null, "at least one primary shard for the security index is unavailable", new Object[0]);
        }
        return new IndexNotFoundException(SECURITY_INDEX_NAME);
    }

    public void addIndexStateListener(BiConsumer<State, State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void clusterChanged(ClusterChangedEvent event) {
        State newState;
        if (event.state().blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            LOGGER.debug("security index manager waiting until state has been recovered");
            return;
        }
        State previousState = this.indexState;
        IndexMetaData indexMetaData = SecurityIndexManager.resolveConcreteIndex(this.indexName, event.state().metaData());
        boolean indexExists = indexMetaData != null;
        boolean isIndexUpToDate = !indexExists || (Integer)IndexMetaData.INDEX_FORMAT_SETTING.get(indexMetaData.getSettings()) == 6;
        boolean indexAvailable = this.checkIndexAvailable(event.state());
        boolean mappingIsUpToDate = !indexExists || this.checkIndexMappingUpToDate(event.state());
        Version mappingVersion = this.oldestIndexMappingVersion(event.state());
        ClusterHealthStatus indexStatus = indexMetaData == null ? null : new ClusterIndexHealth(indexMetaData, event.state().getRoutingTable().index(indexMetaData.getIndex())).getStatus();
        String concreteIndexName = indexMetaData == null ? INTERNAL_SECURITY_INDEX : indexMetaData.getIndex().getName();
        this.indexState = newState = new State(indexExists, isIndexUpToDate, indexAvailable, mappingIsUpToDate, mappingVersion, concreteIndexName, indexStatus);
        if (!newState.equals(previousState)) {
            for (BiConsumer<State, State> listener : this.stateChangeListeners) {
                listener.accept(previousState, newState);
            }
        }
    }

    private boolean checkIndexAvailable(ClusterState state) {
        IndexRoutingTable routingTable = this.getIndexRoutingTable(state);
        if (routingTable != null && routingTable.allPrimaryShardsActive()) {
            return true;
        }
        LOGGER.debug("Security index [{}] is not yet active", (Object)this.indexName);
        return false;
    }

    private IndexRoutingTable getIndexRoutingTable(ClusterState clusterState) {
        IndexMetaData metaData = SecurityIndexManager.resolveConcreteIndex(this.indexName, clusterState.metaData());
        if (metaData == null) {
            return null;
        }
        return clusterState.routingTable().index(metaData.getIndex());
    }

    public static boolean checkTemplateExistsAndVersionMatches(String templateName, ClusterState state, Logger logger, Predicate<Version> predicate) {
        return TemplateUtils.checkTemplateExistsAndVersionMatches((String)templateName, (String)SECURITY_VERSION_STRING, (ClusterState)state, (Logger)logger, predicate);
    }

    private boolean checkIndexMappingUpToDate(ClusterState clusterState) {
        return this.checkIndexMappingVersionMatches(clusterState, arg_0 -> ((Version)Version.CURRENT).equals(arg_0));
    }

    private boolean checkIndexMappingVersionMatches(ClusterState clusterState, Predicate<Version> predicate) {
        return SecurityIndexManager.checkIndexMappingVersionMatches(this.indexName, clusterState, LOGGER, predicate);
    }

    public static boolean checkIndexMappingVersionMatches(String indexName, ClusterState clusterState, Logger logger, Predicate<Version> predicate) {
        return SecurityIndexManager.loadIndexMappingVersions(indexName, clusterState, logger).stream().allMatch(predicate);
    }

    private Version oldestIndexMappingVersion(ClusterState clusterState) {
        Set<Version> versions = SecurityIndexManager.loadIndexMappingVersions(this.indexName, clusterState, LOGGER);
        return versions.stream().min(Version::compareTo).orElse(null);
    }

    private static Set<Version> loadIndexMappingVersions(String indexName, ClusterState clusterState, Logger logger) {
        HashSet<Version> versions = new HashSet<Version>();
        IndexMetaData indexMetaData = SecurityIndexManager.resolveConcreteIndex(indexName, clusterState.metaData());
        if (indexMetaData != null) {
            for (Object object : indexMetaData.getMappings().values().toArray()) {
                MappingMetaData mappingMetaData = (MappingMetaData)object;
                if (mappingMetaData.type().equals("_default_")) continue;
                versions.add(SecurityIndexManager.readMappingVersion(indexName, mappingMetaData, logger));
            }
        }
        return versions;
    }

    private static IndexMetaData resolveConcreteIndex(String indexOrAliasName, MetaData metaData) {
        AliasOrIndex aliasOrIndex = (AliasOrIndex)metaData.getAliasAndIndexLookup().get(indexOrAliasName);
        if (aliasOrIndex != null) {
            List indices = aliasOrIndex.getIndices();
            if (aliasOrIndex.isAlias() && indices.size() > 1) {
                throw new IllegalStateException("Alias [" + indexOrAliasName + "] points to more than one index: " + indices.stream().map(imd -> imd.getIndex().getName()).collect(Collectors.toList()));
            }
            return (IndexMetaData)indices.get(0);
        }
        return null;
    }

    private static Version readMappingVersion(String indexName, MappingMetaData mappingMetaData, Logger logger) {
        try {
            Map meta = (Map)mappingMetaData.sourceAsMap().get("_meta");
            if (meta == null) {
                logger.info("Missing _meta field in mapping [{}] of index [{}]", (Object)mappingMetaData.type(), (Object)indexName);
                throw new IllegalStateException("Cannot read security-version string in index " + indexName);
            }
            return Version.fromString((String)((String)meta.get(SECURITY_VERSION_STRING)));
        }
        catch (ElasticsearchParseException e) {
            logger.error((Message)new ParameterizedMessage("Cannot parse the mapping for index [{}]", (Object)indexName), (Throwable)e);
            throw new ElasticsearchException("Cannot parse the mapping for index [{}]", (Throwable)e, new Object[]{indexName});
        }
    }

    public void checkIndexVersionThenExecute(Consumer<Exception> consumer, Runnable andThen) {
        State indexState = this.indexState;
        if (indexState.indexExists && !indexState.isIndexUpToDate) {
            consumer.accept(new IllegalStateException("Security index is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the security index"));
        } else {
            andThen.run();
        }
    }

    public void prepareIndexIfNeededThenExecute(final Consumer<Exception> consumer, final Runnable andThen) {
        State indexState = this.indexState;
        if (indexState == State.UNRECOVERED_STATE) {
            consumer.accept((Exception)new ElasticsearchStatusException("Cluster state has not been recovered yet, cannot write to the security index", RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
        } else if (indexState.indexExists && !indexState.isIndexUpToDate) {
            consumer.accept(new IllegalStateException("Security index is not on the current version. Security features relying on the index will not be available until the upgrade API is run on the security index"));
        } else if (!indexState.indexExists) {
            LOGGER.info("security index does not exist. Creating [{}] with alias [{}]", (Object)INTERNAL_SECURITY_INDEX, (Object)SECURITY_INDEX_NAME);
            Tuple<String, Settings> mappingAndSettings = this.loadMappingAndSettingsSourceFromTemplate();
            CreateIndexRequest request = new CreateIndexRequest(INTERNAL_SECURITY_INDEX).alias(new Alias(SECURITY_INDEX_NAME)).mapping("_doc", (String)mappingAndSettings.v1(), XContentType.JSON).waitForActiveShards(ActiveShardCount.ALL).settings((Settings)mappingAndSettings.v2());
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)new ActionListener<CreateIndexResponse>(){

                public void onResponse(CreateIndexResponse createIndexResponse) {
                    if (createIndexResponse.isAcknowledged()) {
                        andThen.run();
                    } else {
                        consumer.accept(new ElasticsearchException("Failed to create security index", new Object[0]));
                    }
                }

                public void onFailure(Exception e) {
                    Throwable cause = ExceptionsHelper.unwrapCause((Throwable)e);
                    if (cause instanceof ResourceAlreadyExistsException) {
                        andThen.run();
                    } else {
                        consumer.accept(e);
                    }
                }
            }, (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).create(arg_0, arg_1));
        } else if (!indexState.mappingUpToDate) {
            LOGGER.info("security index [{}] (alias [{}]) is not up to date. Updating mapping", (Object)indexState.concreteIndexName, (Object)SECURITY_INDEX_NAME);
            PutMappingRequest request = new PutMappingRequest(new String[]{indexState.concreteIndexName}).source((String)this.loadMappingAndSettingsSourceFromTemplate().v1(), XContentType.JSON).type("_doc");
            ClientHelper.executeAsyncWithOrigin((ThreadContext)this.client.threadPool().getThreadContext(), (String)"security", (ActionRequest)request, (ActionListener)ActionListener.wrap(putMappingResponse -> {
                if (putMappingResponse.isAcknowledged()) {
                    andThen.run();
                } else {
                    consumer.accept(new IllegalStateException("put mapping request was not acknowledged"));
                }
            }, consumer), (arg_0, arg_1) -> ((IndicesAdminClient)this.client.admin().indices()).putMapping(arg_0, arg_1));
        } else {
            andThen.run();
        }
    }

    private Tuple<String, Settings> loadMappingAndSettingsSourceFromTemplate() {
        Tuple tuple;
        block8: {
            byte[] template = TemplateUtils.loadTemplate((String)"/security-index-template.json", (String)Version.CURRENT.toString(), (String)TEMPLATE_VERSION_PATTERN).getBytes(StandardCharsets.UTF_8);
            PutIndexTemplateRequest request = new PutIndexTemplateRequest(SECURITY_TEMPLATE_NAME).source(template, XContentType.JSON);
            String mappingSource = (String)request.mappings().get("_doc");
            XContentParser parser = XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, mappingSource);
            try {
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
                XContentParserUtils.ensureFieldName((XContentParser)parser, (XContentParser.Token)parser.nextToken(), (String)"_doc");
                XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
                XContentBuilder builder = JsonXContent.contentBuilder();
                builder.generator().copyCurrentStructure(parser);
                tuple = new Tuple((Object)Strings.toString((XContentBuilder)builder), (Object)request.settings());
                if (parser == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw ExceptionsHelper.convertToRuntime((Exception)e);
                }
            }
            parser.close();
        }
        return tuple;
    }

    public static boolean isMoveFromRedToNonRed(State previousState, State currentState) {
        return (previousState.indexStatus == null || previousState.indexStatus == ClusterHealthStatus.RED) && currentState.indexStatus != null && currentState.indexStatus != ClusterHealthStatus.RED;
    }

    public static boolean isIndexDeleted(State previousState, State currentState) {
        return previousState.indexStatus != null && currentState.indexStatus == null;
    }

    public static class State {
        public static final State UNRECOVERED_STATE = new State(false, false, false, false, null, null, null);
        public final boolean indexExists;
        public final boolean isIndexUpToDate;
        public final boolean indexAvailable;
        public final boolean mappingUpToDate;
        public final Version mappingVersion;
        public final String concreteIndexName;
        public final ClusterHealthStatus indexStatus;

        public State(boolean indexExists, boolean isIndexUpToDate, boolean indexAvailable, boolean mappingUpToDate, Version mappingVersion, String concreteIndexName, ClusterHealthStatus indexStatus) {
            this.indexExists = indexExists;
            this.isIndexUpToDate = isIndexUpToDate;
            this.indexAvailable = indexAvailable;
            this.mappingUpToDate = mappingUpToDate;
            this.mappingVersion = mappingVersion;
            this.concreteIndexName = concreteIndexName;
            this.indexStatus = indexStatus;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            State state = (State)o;
            return this.indexExists == state.indexExists && this.isIndexUpToDate == state.isIndexUpToDate && this.indexAvailable == state.indexAvailable && this.mappingUpToDate == state.mappingUpToDate && Objects.equals(this.mappingVersion, state.mappingVersion) && Objects.equals(this.concreteIndexName, state.concreteIndexName) && this.indexStatus == state.indexStatus;
        }

        public int hashCode() {
            return Objects.hash(this.indexExists, this.isIndexUpToDate, this.indexAvailable, this.mappingUpToDate, this.mappingVersion, this.concreteIndexName, this.indexStatus);
        }
    }
}

