/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action.realm;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.security.action.realm.ClearRealmCacheRequest;
import org.elasticsearch.xpack.core.security.client.SecurityClient;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public final class RestClearRealmCacheAction
extends SecurityBaseRestHandler {
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestClearRealmCacheAction.class));

    public RestClearRealmCacheAction(Settings settings, RestController controller, XPackLicenseState licenseState) {
        super(settings, licenseState);
        controller.registerWithDeprecatedHandler(RestRequest.Method.POST, "/_security/realm/{realms}/_clear_cache", (RestHandler)this, RestRequest.Method.POST, "/_xpack/security/realm/{realms}/_clear_cache", deprecationLogger);
    }

    public String getName() {
        return "security_clear_realm_cache_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        String[] realms = request.paramAsStringArrayOrEmptyIfAll("realms");
        String[] usernames = request.paramAsStringArrayOrEmptyIfAll("usernames");
        ClearRealmCacheRequest req = new ClearRealmCacheRequest().realms(realms).usernames(usernames);
        return channel -> new SecurityClient((ElasticsearchClient)client).clearRealmCache(req, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }
}

