/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.rest.action;

import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.rest.action.RestBuilderListener;
import org.elasticsearch.xpack.core.security.SecurityContext;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateAction;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateRequest;
import org.elasticsearch.xpack.core.security.action.user.AuthenticateResponse;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.rest.action.SecurityBaseRestHandler;

public class RestAuthenticateAction
extends SecurityBaseRestHandler {
    private final SecurityContext securityContext;
    private static final DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(RestAuthenticateAction.class));

    public RestAuthenticateAction(Settings settings, RestController controller, SecurityContext securityContext, XPackLicenseState licenseState) {
        super(settings, licenseState);
        this.securityContext = securityContext;
        controller.registerWithDeprecatedHandler(RestRequest.Method.GET, "/_security/_authenticate", (RestHandler)this, RestRequest.Method.GET, "/_xpack/security/_authenticate", deprecationLogger);
    }

    public String getName() {
        return "security_authenticate_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer innerPrepareRequest(RestRequest request, NodeClient client) throws IOException {
        User user = this.securityContext.getUser();
        if (user == null) {
            return restChannel -> {
                throw new IllegalStateException("we should never have a null user and invoke this consumer");
            };
        }
        String username = user.principal();
        return channel -> client.execute((Action)AuthenticateAction.INSTANCE, (ActionRequest)new AuthenticateRequest(username), (ActionListener)new RestBuilderListener<AuthenticateResponse>(channel){

            public RestResponse buildResponse(AuthenticateResponse authenticateResponse, XContentBuilder builder) throws Exception {
                authenticateResponse.authentication().toXContent(builder, ToXContent.EMPTY_PARAMS);
                return new BytesRestResponse(RestStatus.OK, builder);
            }
        });
    }
}

