/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPURL;
import com.unboundid.ldap.sdk.ServerSet;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.SSLSocketVerifier;
import java.util.Arrays;
import java.util.List;
import java.util.function.Function;
import java.util.regex.Pattern;
import javax.net.ssl.SSLSocketFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.SecureString;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xpack.core.security.authc.RealmConfig;
import org.elasticsearch.xpack.core.security.authc.RealmSettings;
import org.elasticsearch.xpack.core.security.authc.ldap.support.SessionFactorySettings;
import org.elasticsearch.xpack.core.ssl.SSLConfiguration;
import org.elasticsearch.xpack.core.ssl.SSLConfigurationSettings;
import org.elasticsearch.xpack.core.ssl.SSLService;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapLoadBalancing;
import org.elasticsearch.xpack.security.authc.ldap.support.LdapSession;

public abstract class SessionFactory {
    private static final Pattern STARTS_WITH_LDAPS = Pattern.compile("^ldaps:.*", 2);
    private static final Pattern STARTS_WITH_LDAP = Pattern.compile("^ldap:.*", 2);
    protected final Logger logger;
    protected final RealmConfig config;
    protected final TimeValue timeout;
    protected final SSLService sslService;
    protected final ThreadPool threadPool;
    protected final ServerSet serverSet;
    protected final boolean sslUsed;
    protected final boolean ignoreReferralErrors;

    protected SessionFactory(RealmConfig config, SSLService sslService, ThreadPool threadPool) {
        this.config = config;
        this.logger = LogManager.getLogger(this.getClass());
        TimeValue searchTimeout = (TimeValue)config.getSetting(SessionFactorySettings.TIMEOUT_LDAP_SETTING, () -> SessionFactorySettings.TIMEOUT_DEFAULT);
        if (searchTimeout.millis() < 1000L) {
            this.logger.warn("ldap_search timeout [{}] is less than the minimum supported search timeout of 1s. using 1s", (Object)searchTimeout.millis());
            searchTimeout = TimeValue.timeValueSeconds((long)1L);
        }
        this.timeout = searchTimeout;
        this.sslService = sslService;
        this.threadPool = threadPool;
        LDAPServers ldapServers = this.ldapServers(config);
        this.serverSet = this.serverSet(config, sslService, ldapServers);
        this.sslUsed = ldapServers.ssl;
        this.ignoreReferralErrors = (Boolean)config.getSetting(SessionFactorySettings.IGNORE_REFERRAL_ERRORS_SETTING);
    }

    public abstract void session(String var1, SecureString var2, ActionListener<LdapSession> var3);

    public boolean supportsUnauthenticatedSession() {
        return false;
    }

    public void unauthenticatedSession(String username, ActionListener<LdapSession> listener) {
        throw new UnsupportedOperationException("unauthenticated sessions are not supported");
    }

    protected static LDAPConnectionOptions connectionOptions(RealmConfig config, SSLService sslService, Logger logger) {
        LDAPConnectionOptions options = new LDAPConnectionOptions();
        options.setConnectTimeoutMillis(Math.toIntExact(((TimeValue)config.getSetting(SessionFactorySettings.TIMEOUT_TCP_CONNECTION_SETTING)).millis()));
        options.setFollowReferrals(((Boolean)config.getSetting(SessionFactorySettings.FOLLOW_REFERRALS_SETTING)).booleanValue());
        options.setResponseTimeoutMillis(((TimeValue)config.getSetting(SessionFactorySettings.TIMEOUT_TCP_READ_SETTING)).millis());
        options.setAllowConcurrentSocketFactoryUse(true);
        boolean verificationModeExists = config.hasSetting(SSLConfigurationSettings.VERIFICATION_MODE_SETTING_REALM);
        boolean hostnameVerificationExists = config.hasSetting(SessionFactorySettings.HOSTNAME_VERIFICATION_SETTING);
        if (verificationModeExists && hostnameVerificationExists) {
            throw new IllegalArgumentException("[" + RealmSettings.getFullSettingKey((RealmConfig)config, (Function)SessionFactorySettings.HOSTNAME_VERIFICATION_SETTING) + "] and [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Function)SSLConfigurationSettings.VERIFICATION_MODE_SETTING_REALM) + "] may not be used at the same time");
        }
        if (verificationModeExists) {
            String sslKey = RealmSettings.realmSslPrefix((RealmConfig.RealmIdentifier)config.identifier());
            SSLConfiguration sslConfiguration = sslService.getSSLConfiguration(sslKey);
            if (sslConfiguration == null) {
                throw new IllegalStateException("cannot find SSL configuration for " + sslKey);
            }
            if (sslConfiguration.verificationMode().isHostnameVerificationEnabled()) {
                options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
            }
        } else if (hostnameVerificationExists) {
            new DeprecationLogger(logger).deprecated("the setting [{}] has been deprecated and will be removed in a future version. use [{}] instead", new Object[]{RealmSettings.getFullSettingKey((RealmConfig)config, (Function)SessionFactorySettings.HOSTNAME_VERIFICATION_SETTING), RealmSettings.getFullSettingKey((RealmConfig)config, (Function)SSLConfigurationSettings.VERIFICATION_MODE_SETTING_REALM)});
            if (((Boolean)config.getSetting(SessionFactorySettings.HOSTNAME_VERIFICATION_SETTING)).booleanValue()) {
                options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
            }
        } else {
            options.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(true));
        }
        return options;
    }

    private LDAPServers ldapServers(RealmConfig config) {
        List ldapUrls = (List)config.getSetting(SessionFactorySettings.URLS_SETTING, () -> this.getDefaultLdapUrls(config));
        if (ldapUrls == null || ldapUrls.isEmpty()) {
            throw new IllegalArgumentException("missing required LDAP setting [" + RealmSettings.getFullSettingKey((RealmConfig)config, (Function)SessionFactorySettings.URLS_SETTING) + "]");
        }
        return new LDAPServers(ldapUrls.toArray(new String[ldapUrls.size()]));
    }

    protected List<String> getDefaultLdapUrls(RealmConfig config) {
        return null;
    }

    private ServerSet serverSet(RealmConfig realmConfig, SSLService clientSSLService, LDAPServers ldapServers) {
        SSLSocketFactory socketFactory = null;
        if (ldapServers.ssl()) {
            String sslKey = RealmSettings.realmSslPrefix((RealmConfig.RealmIdentifier)this.config.identifier());
            SSLConfiguration ssl = clientSSLService.getSSLConfiguration(sslKey);
            socketFactory = clientSSLService.sslSocketFactory(ssl);
            if (ssl.verificationMode().isHostnameVerificationEnabled()) {
                this.logger.debug("using encryption for LDAP connections with hostname verification");
            } else {
                this.logger.debug("using encryption for LDAP connections without hostname verification");
            }
        }
        return LdapLoadBalancing.serverSet(ldapServers.addresses(), ldapServers.ports(), realmConfig, socketFactory, SessionFactory.connectionOptions(realmConfig, this.sslService, this.logger));
    }

    ServerSet getServerSet() {
        return this.serverSet;
    }

    public boolean isSslUsed() {
        return this.sslUsed;
    }

    public static class LDAPServers {
        private final String[] addresses;
        private final int[] ports;
        private final boolean ssl;

        public LDAPServers(String[] urls) {
            this.ssl = this.secureUrls(urls);
            this.addresses = new String[urls.length];
            this.ports = new int[urls.length];
            for (int i = 0; i < urls.length; ++i) {
                try {
                    LDAPURL url = new LDAPURL(urls[i]);
                    this.addresses[i] = url.getHost();
                    this.ports[i] = url.getPort();
                    continue;
                }
                catch (LDAPException e) {
                    throw new IllegalArgumentException("unable to parse configured LDAP url [" + urls[i] + "]", e);
                }
            }
        }

        public String[] addresses() {
            return this.addresses;
        }

        public int[] ports() {
            return this.ports;
        }

        public boolean ssl() {
            return this.ssl;
        }

        private boolean secureUrls(String[] ldapUrls) {
            if (ldapUrls.length == 0) {
                return true;
            }
            boolean allSecure = Arrays.stream(ldapUrls).allMatch(s -> STARTS_WITH_LDAPS.matcher((CharSequence)s).find());
            boolean allClear = Arrays.stream(ldapUrls).allMatch(s -> STARTS_WITH_LDAP.matcher((CharSequence)s).find());
            if (!allSecure && !allClear) {
                throw new IllegalArgumentException("configured LDAP protocols are not all equal (ldaps://.. and ldap://..): [" + Strings.arrayToCommaDelimitedString((Object[])ldapUrls) + "]");
            }
            return allSecure;
        }
    }
}

