/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.user;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.GroupedActionListener;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.user.GetUsersRequest;
import org.elasticsearch.xpack.core.security.action.user.GetUsersResponse;
import org.elasticsearch.xpack.core.security.authc.esnative.ClientReservedRealm;
import org.elasticsearch.xpack.core.security.user.User;
import org.elasticsearch.xpack.security.authc.esnative.NativeUsersStore;
import org.elasticsearch.xpack.security.authc.esnative.ReservedRealm;

public class TransportGetUsersAction
extends HandledTransportAction<GetUsersRequest, GetUsersResponse> {
    private final Settings settings;
    private final NativeUsersStore usersStore;
    private final ReservedRealm reservedRealm;

    @Inject
    public TransportGetUsersAction(Settings settings, ActionFilters actionFilters, NativeUsersStore usersStore, TransportService transportService, ReservedRealm reservedRealm) {
        super("cluster:admin/xpack/security/user/get", transportService, actionFilters, GetUsersRequest::new);
        this.settings = settings;
        this.usersStore = usersStore;
        this.reservedRealm = reservedRealm;
    }

    protected void doExecute(Task task, GetUsersRequest request, ActionListener<GetUsersResponse> listener) {
        String[] requestedUsers = request.usernames();
        boolean specificUsersRequested = requestedUsers != null && requestedUsers.length > 0;
        ArrayList<String> usersToSearchFor = new ArrayList<String>();
        ArrayList users = new ArrayList();
        ArrayList<String> realmLookup = new ArrayList<String>();
        if (specificUsersRequested) {
            for (String username : requestedUsers) {
                if (ClientReservedRealm.isReserved((String)username, (Settings)this.settings)) {
                    realmLookup.add(username);
                    continue;
                }
                if ("_system".equals(username) || "_xpack".equals(username)) {
                    listener.onFailure((Exception)new IllegalArgumentException("user [" + username + "] is internal"));
                    return;
                }
                usersToSearchFor.add(username);
            }
        }
        ActionListener sendingListener = ActionListener.wrap(userLists -> {
            users.addAll(userLists.stream().flatMap(Collection::stream).filter(Objects::nonNull).collect(Collectors.toList()));
            listener.onResponse((Object)new GetUsersResponse((Collection)users));
        }, arg_0 -> listener.onFailure(arg_0));
        GroupedActionListener groupListener = new GroupedActionListener(sendingListener, 2, Collections.emptyList());
        if (realmLookup.isEmpty()) {
            if (!specificUsersRequested) {
                this.reservedRealm.users((ActionListener<Collection<User>>)groupListener);
            } else {
                groupListener.onResponse(Collections.emptyList());
            }
        } else {
            GroupedActionListener realmGroupListener = new GroupedActionListener((ActionListener)groupListener, realmLookup.size(), Collections.emptyList());
            for (String user : realmLookup) {
                this.reservedRealm.lookupUser(user, (ActionListener<User>)realmGroupListener);
            }
        }
        if (specificUsersRequested && usersToSearchFor.isEmpty()) {
            groupListener.onResponse(Collections.emptyList());
        } else {
            this.usersStore.getUsers(usersToSearchFor.toArray(new String[usersToSearchFor.size()]), (ActionListener<Collection<User>>)groupListener);
        }
    }
}

