/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.token;

import java.io.IOException;
import java.util.Collections;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportMessage;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenRequest;
import org.elasticsearch.xpack.core.security.action.token.CreateTokenResponse;
import org.elasticsearch.xpack.core.security.authc.Authentication;
import org.elasticsearch.xpack.core.security.authc.AuthenticationToken;
import org.elasticsearch.xpack.core.security.authc.support.UsernamePasswordToken;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.authc.TokenService;
import org.elasticsearch.xpack.security.authc.UserToken;

public final class TransportCreateTokenAction
extends HandledTransportAction<CreateTokenRequest, CreateTokenResponse> {
    private static final String DEFAULT_SCOPE = "full";
    private final ThreadPool threadPool;
    private final TokenService tokenService;
    private final AuthenticationService authenticationService;

    @Inject
    public TransportCreateTokenAction(ThreadPool threadPool, TransportService transportService, ActionFilters actionFilters, TokenService tokenService, AuthenticationService authenticationService) {
        super("cluster:admin/xpack/security/token/create", transportService, actionFilters, CreateTokenRequest::new);
        this.threadPool = threadPool;
        this.tokenService = tokenService;
        this.authenticationService = authenticationService;
    }

    protected void doExecute(Task task, CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        CreateTokenRequest.GrantType type = CreateTokenRequest.GrantType.fromString((String)request.getGrantType());
        assert (type != null) : "type should have been validated in the action";
        switch (type) {
            case PASSWORD: {
                this.authenticateAndCreateToken(request, listener);
                break;
            }
            case CLIENT_CREDENTIALS: {
                Authentication authentication = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext());
                this.createToken(request, authentication, authentication, false, listener);
                break;
            }
            default: {
                listener.onFailure((Exception)new IllegalStateException("grant_type [" + request.getGrantType() + "] is not supported by the create token action"));
            }
        }
    }

    private void authenticateAndCreateToken(CreateTokenRequest request, ActionListener<CreateTokenResponse> listener) {
        Authentication originatingAuthentication = Authentication.getAuthentication((ThreadContext)this.threadPool.getThreadContext());
        try (ThreadContext.StoredContext ignore = this.threadPool.getThreadContext().stashContext();){
            UsernamePasswordToken authToken = new UsernamePasswordToken(request.getUsername(), request.getPassword());
            this.authenticationService.authenticate("cluster:admin/xpack/security/token/create", (TransportMessage)request, (AuthenticationToken)authToken, (ActionListener<Authentication>)ActionListener.wrap(authentication -> {
                request.getPassword().close();
                if (authentication != null) {
                    this.createToken(request, (Authentication)authentication, originatingAuthentication, true, listener);
                } else {
                    listener.onFailure((Exception)new UnsupportedOperationException("cannot create token if authentication is not allowed"));
                }
            }, e -> {
                request.getPassword().close();
                listener.onFailure(e);
            }));
        }
    }

    private void createToken(CreateTokenRequest request, Authentication authentication, Authentication originatingAuth, boolean includeRefreshToken, ActionListener<CreateTokenResponse> listener) {
        try {
            this.tokenService.createUserToken(authentication, originatingAuth, (ActionListener<Tuple<UserToken, String>>)ActionListener.wrap(tuple -> {
                String tokenStr = this.tokenService.getUserTokenString((UserToken)tuple.v1());
                String scope = TransportCreateTokenAction.getResponseScopeValue(request.getScope());
                CreateTokenResponse response = new CreateTokenResponse(tokenStr, this.tokenService.getExpirationDelay(), scope, (String)tuple.v2());
                listener.onResponse((Object)response);
            }, arg_0 -> listener.onFailure(arg_0)), Collections.emptyMap(), includeRefreshToken);
        }
        catch (IOException e) {
            listener.onFailure((Exception)e);
        }
    }

    static String getResponseScopeValue(String requestScope) {
        String scope = requestScope != null ? DEFAULT_SCOPE : null;
        return scope;
    }
}

