/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import java.util.List;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheRequest;
import org.elasticsearch.xpack.core.security.action.role.ClearRolesCacheResponse;
import org.elasticsearch.xpack.security.authz.store.CompositeRolesStore;

public class TransportClearRolesCacheAction
extends TransportNodesAction<ClearRolesCacheRequest, ClearRolesCacheResponse, ClearRolesCacheRequest.Node, ClearRolesCacheResponse.Node> {
    private final CompositeRolesStore rolesStore;

    @Inject
    public TransportClearRolesCacheAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, ActionFilters actionFilters, CompositeRolesStore rolesStore) {
        super("cluster:admin/xpack/security/roles/cache/clear", threadPool, clusterService, transportService, actionFilters, ClearRolesCacheRequest::new, ClearRolesCacheRequest.Node::new, "management", ClearRolesCacheResponse.Node.class);
        this.rolesStore = rolesStore;
    }

    protected ClearRolesCacheResponse newResponse(ClearRolesCacheRequest request, List<ClearRolesCacheResponse.Node> responses, List<FailedNodeException> failures) {
        return new ClearRolesCacheResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ClearRolesCacheRequest.Node newNodeRequest(String nodeId, ClearRolesCacheRequest request) {
        return new ClearRolesCacheRequest.Node(request, nodeId);
    }

    protected ClearRolesCacheResponse.Node newNodeResponse() {
        return new ClearRolesCacheResponse.Node();
    }

    protected ClearRolesCacheResponse.Node nodeOperation(ClearRolesCacheRequest.Node request) {
        if (request.getNames() == null || request.getNames().length == 0) {
            this.rolesStore.invalidateAll();
        } else {
            for (String role : request.getNames()) {
                this.rolesStore.invalidate(role);
            }
        }
        return new ClearRolesCacheResponse.Node(this.clusterService.localNode());
    }
}

