/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.InvalidateApiKeyResponse;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportInvalidateApiKeyAction
extends HandledTransportAction<InvalidateApiKeyRequest, InvalidateApiKeyResponse> {
    private final ApiKeyService apiKeyService;

    @Inject
    public TransportInvalidateApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService) {
        super("cluster:admin/xpack/security/api_key/invalidate", transportService, actionFilters, InvalidateApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
    }

    protected void doExecute(Task task, InvalidateApiKeyRequest request, ActionListener<InvalidateApiKeyResponse> listener) {
        if (Strings.hasText((String)request.getRealmName()) || Strings.hasText((String)request.getUserName())) {
            this.apiKeyService.invalidateApiKeysForRealmAndUser(request.getRealmName(), request.getUserName(), listener);
        } else if (Strings.hasText((String)request.getId())) {
            this.apiKeyService.invalidateApiKeyForApiKeyId(request.getId(), listener);
        } else {
            this.apiKeyService.invalidateApiKeyForApiKeyName(request.getName(), listener);
        }
    }
}

