/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.security.action.GetApiKeyRequest;
import org.elasticsearch.xpack.core.security.action.GetApiKeyResponse;
import org.elasticsearch.xpack.security.authc.ApiKeyService;

public final class TransportGetApiKeyAction
extends HandledTransportAction<GetApiKeyRequest, GetApiKeyResponse> {
    private final ApiKeyService apiKeyService;

    @Inject
    public TransportGetApiKeyAction(TransportService transportService, ActionFilters actionFilters, ApiKeyService apiKeyService) {
        super("cluster:admin/xpack/security/api_key/get", transportService, actionFilters, GetApiKeyRequest::new);
        this.apiKeyService = apiKeyService;
    }

    protected void doExecute(Task task, GetApiKeyRequest request, ActionListener<GetApiKeyResponse> listener) {
        if (Strings.hasText((String)request.getRealmName()) || Strings.hasText((String)request.getUserName())) {
            this.apiKeyService.getApiKeysForRealmAndUser(request.getRealmName(), request.getUserName(), listener);
        } else if (Strings.hasText((String)request.getApiKeyId())) {
            this.apiKeyService.getApiKeyForApiKeyId(request.getApiKeyId(), listener);
        } else if (Strings.hasText((String)request.getApiKeyName())) {
            this.apiKeyService.getApiKeyForApiKeyName(request.getApiKeyName(), listener);
        } else {
            listener.onFailure((Exception)new IllegalArgumentException("One of [api key id, api key name, username, realm name] must be specified"));
        }
    }
}

