/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.sql.SQLException;
import java.util.Collections;
import java.util.function.Function;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.internal.io.Streams;
import org.elasticsearch.xpack.sql.client.CheckedFunction;
import org.elasticsearch.xpack.sql.client.ClientException;
import org.elasticsearch.xpack.sql.client.ConnectionConfiguration;
import org.elasticsearch.xpack.sql.client.JreHttpUrlConnection;
import org.elasticsearch.xpack.sql.proto.AbstractSqlRequest;
import org.elasticsearch.xpack.sql.proto.MainResponse;
import org.elasticsearch.xpack.sql.proto.Mode;
import org.elasticsearch.xpack.sql.proto.Protocol;
import org.elasticsearch.xpack.sql.proto.RequestInfo;
import org.elasticsearch.xpack.sql.proto.SqlClearCursorRequest;
import org.elasticsearch.xpack.sql.proto.SqlClearCursorResponse;
import org.elasticsearch.xpack.sql.proto.SqlQueryRequest;
import org.elasticsearch.xpack.sql.proto.SqlQueryResponse;

public class HttpClient {
    private static final XContentType REQUEST_BODY_CONTENT_TYPE = XContentType.JSON;
    private final ConnectionConfiguration cfg;
    private NamedXContentRegistry registry = NamedXContentRegistry.EMPTY;

    public HttpClient(ConnectionConfiguration cfg) {
        this.cfg = cfg;
    }

    public boolean ping(long timeoutInMs) throws SQLException {
        return this.head("/", timeoutInMs);
    }

    public MainResponse serverInfo() throws SQLException {
        return this.get("/", MainResponse::fromXContent);
    }

    public SqlQueryResponse basicQuery(String query, int fetchSize) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(query, Collections.emptyList(), Protocol.TIME_ZONE, fetchSize, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), null, null, new RequestInfo(Mode.CLI), false);
        return this.query(sqlRequest);
    }

    public SqlQueryResponse query(SqlQueryRequest sqlRequest) throws SQLException {
        return this.post("/_sql", sqlRequest, SqlQueryResponse::fromXContent);
    }

    public SqlQueryResponse nextPage(String cursor) throws SQLException {
        SqlQueryRequest sqlRequest = new SqlQueryRequest(cursor, TimeValue.timeValueMillis(this.cfg.queryTimeout()), TimeValue.timeValueMillis(this.cfg.pageTimeout()), new RequestInfo(Mode.CLI));
        return this.post("/_sql", sqlRequest, SqlQueryResponse::fromXContent);
    }

    public boolean queryClose(String cursor, Mode mode) throws SQLException {
        SqlClearCursorResponse response = this.post("/_sql/close", new SqlClearCursorRequest(cursor, new RequestInfo(mode)), SqlClearCursorResponse::fromXContent);
        return response.isSucceeded();
    }

    private <Request extends AbstractSqlRequest, Response> Response post(String path, Request request, CheckedFunction<XContentParser, Response, IOException> responseParser) throws SQLException {
        byte[] requestBytes = HttpClient.toXContent(request);
        String query = "error_trace";
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, query, this.cfg, con -> con.request(out -> out.write(requestBytes), this::readFrom, "POST"))).getResponseOrThrowException();
        return this.fromXContent((XContentType)((Object)response.v1()), (byte[])response.v2(), responseParser);
    }

    private boolean head(String path, long timeoutInMs) throws SQLException {
        ConnectionConfiguration pingCfg = new ConnectionConfiguration(this.cfg.baseUri(), this.cfg.connectionString(), this.cfg.validateProperties(), this.cfg.connectTimeout(), timeoutInMs, this.cfg.queryTimeout(), this.cfg.pageTimeout(), this.cfg.pageSize(), this.cfg.authUser(), this.cfg.authPass(), this.cfg.sslConfig(), this.cfg.proxyConfig());
        try {
            return AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", pingCfg, JreHttpUrlConnection::head));
        }
        catch (ClientException ex) {
            throw new SQLException("Cannot ping server", ex);
        }
    }

    private <Response> Response get(String path, CheckedFunction<XContentParser, Response, IOException> responseParser) throws SQLException {
        Tuple response = (Tuple)AccessController.doPrivileged(() -> JreHttpUrlConnection.http(path, "error_trace", this.cfg, con -> con.request(null, this::readFrom, "GET"))).getResponseOrThrowException();
        return this.fromXContent((XContentType)((Object)response.v1()), (byte[])response.v2(), responseParser);
    }

    private static <Request extends ToXContent> byte[] toXContent(Request xContent) {
        byte[] byArray;
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            try (XContentBuilder xContentBuilder = new XContentBuilder(REQUEST_BODY_CONTENT_TYPE.xContent(), buffer);){
                if (xContent.isFragment()) {
                    xContentBuilder.startObject();
                }
                xContent.toXContent(xContentBuilder, ToXContent.EMPTY_PARAMS);
                if (xContent.isFragment()) {
                    xContentBuilder.endObject();
                }
            }
            byArray = buffer.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    buffer.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new ClientException("Cannot serialize request", ex);
            }
        }
        buffer.close();
        return byArray;
    }

    private Tuple<XContentType, byte[]> readFrom(InputStream inputStream, Function<String, String> headers) {
        String contentType = headers.apply("Content-Type");
        XContentType xContentType = XContentType.fromMediaTypeOrFormat(contentType);
        if (xContentType == null) {
            throw new IllegalStateException("Unsupported Content-Type: " + contentType);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            Streams.copy(inputStream, out);
        }
        catch (IOException ex) {
            throw new ClientException("Cannot deserialize response", ex);
        }
        return new Tuple<XContentType, byte[]>(xContentType, out.toByteArray());
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <Response> Response fromXContent(XContentType xContentType, byte[] bytesReference, CheckedFunction<XContentParser, Response, IOException> responseParser) {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(bytesReference);){
            Response Response2;
            block13: {
                XContentParser parser = xContentType.xContent().createParser(this.registry, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, stream);
                try {
                    Response2 = responseParser.apply(parser);
                    if (parser == null) break block13;
                }
                catch (Throwable throwable) {
                    if (parser != null) {
                        try {
                            parser.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                parser.close();
            }
            return Response2;
        }
        catch (IOException ex) {
            throw new ClientException("Cannot parse response", ex);
        }
    }
}

