/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.cli.command;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.elasticsearch.xpack.sql.cli.Cli;
import org.elasticsearch.xpack.sql.cli.CliTerminal;
import org.elasticsearch.xpack.sql.cli.FatalCliException;
import org.elasticsearch.xpack.sql.cli.command.AbstractCliCommand;
import org.elasticsearch.xpack.sql.cli.command.CliSession;
import org.elasticsearch.xpack.sql.client.Version;

public class PrintLogoCommand
extends AbstractCliCommand {
    public PrintLogoCommand() {
        super(Pattern.compile("logo", 2));
    }

    @Override
    protected boolean doHandle(CliTerminal terminal, CliSession cliSession, Matcher m, String line) {
        this.printLogo(terminal);
        return true;
    }

    public void printLogo(CliTerminal terminal) {
        terminal.clear();
        int lineLength = 0;
        try (InputStream in = Cli.class.getResourceAsStream("/logo.txt");){
            if (in == null) {
                throw new FatalCliException("Could not find logo!");
            }
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                String line;
                while ((line = reader.readLine()) != null) {
                    lineLength = Math.max(lineLength, line.length());
                    terminal.println(line);
                }
            }
        }
        catch (IOException e) {
            throw new FatalCliException("Could not load logo!", e);
        }
        char[] whitespaces = new char[(lineLength - Version.CURRENT.version.length()) / 2];
        Arrays.fill(whitespaces, ' ');
        terminal.println(whitespaces + Version.CURRENT.version);
        terminal.println();
    }
}

