/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.search.DocValueFormat;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.search.aggregations.AggregatorFactory;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceAggregatorFactory;
import org.elasticsearch.search.aggregations.support.MultiValuesSourceFieldConfig;
import org.elasticsearch.search.aggregations.support.ValueType;
import org.elasticsearch.search.aggregations.support.ValuesSource;
import org.elasticsearch.search.aggregations.support.ValuesSourceConfig;
import org.elasticsearch.search.internal.SearchContext;

public abstract class MultiValuesSourceAggregationBuilder<VS extends ValuesSource, AB extends MultiValuesSourceAggregationBuilder<VS, AB>>
extends AbstractAggregationBuilder<AB> {
    private Map<String, MultiValuesSourceFieldConfig> fields = new HashMap<String, MultiValuesSourceFieldConfig>();
    private final ValueType targetValueType;
    private ValueType valueType = null;
    private String format = null;

    protected MultiValuesSourceAggregationBuilder(String name, ValueType targetValueType) {
        super(name);
        this.targetValueType = targetValueType;
    }

    protected MultiValuesSourceAggregationBuilder(MultiValuesSourceAggregationBuilder<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
        super(clone, factoriesBuilder, metaData);
        this.fields = new HashMap<String, MultiValuesSourceFieldConfig>(clone.fields);
        this.targetValueType = clone.targetValueType;
        this.valueType = clone.valueType;
        this.format = clone.format;
    }

    protected MultiValuesSourceAggregationBuilder(StreamInput in, ValueType targetValueType) throws IOException {
        super(in);
        assert (!this.serializeTargetValueType()) : "Wrong read constructor called for subclass that provides its targetValueType";
        this.targetValueType = targetValueType;
        this.read(in);
    }

    private void read(StreamInput in) throws IOException {
        this.fields = in.readMap(StreamInput::readString, MultiValuesSourceFieldConfig::new);
        this.valueType = in.readOptionalWriteable(ValueType::readFromStream);
        this.format = in.readOptionalString();
    }

    @Override
    protected final void doWriteTo(StreamOutput out) throws IOException {
        if (this.serializeTargetValueType()) {
            out.writeOptionalWriteable(this.targetValueType);
        }
        out.writeMap(this.fields, StreamOutput::writeString, (o, value) -> value.writeTo(o));
        out.writeOptionalWriteable(this.valueType);
        out.writeOptionalString(this.format);
        this.innerWriteTo(out);
    }

    protected abstract void innerWriteTo(StreamOutput var1) throws IOException;

    protected AB field(String propertyName, MultiValuesSourceFieldConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("[config] must not be null: [" + this.name + "]");
        }
        this.fields.put(propertyName, config);
        return (AB)this;
    }

    public AB valueType(ValueType valueType) {
        if (valueType == null) {
            throw new IllegalArgumentException("[valueType] must not be null: [" + this.name + "]");
        }
        this.valueType = valueType;
        return (AB)this;
    }

    public AB format(String format) {
        if (format == null) {
            throw new IllegalArgumentException("[format] must not be null: [" + this.name + "]");
        }
        this.format = format;
        return (AB)this;
    }

    protected final MultiValuesSourceAggregatorFactory<VS, ?> doBuild(SearchContext context, AggregatorFactory<?> parent, AggregatorFactories.Builder subFactoriesBuilder) throws IOException {
        ValueType finalValueType = this.valueType != null ? this.valueType : this.targetValueType;
        HashMap<String, ValuesSourceConfig<VS>> configs = new HashMap<String, ValuesSourceConfig<VS>>(this.fields.size());
        this.fields.forEach((key, value) -> {
            ValuesSourceConfig config = ValuesSourceConfig.resolve(context.getQueryShardContext(), finalValueType, value.getFieldName(), value.getScript(), value.getMissing(), value.getTimeZone(), this.format);
            configs.put((String)key, config);
        });
        DocValueFormat docValueFormat = MultiValuesSourceAggregationBuilder.resolveFormat(this.format, finalValueType);
        return this.innerBuild(context, configs, docValueFormat, parent, subFactoriesBuilder);
    }

    private static DocValueFormat resolveFormat(@Nullable String format, @Nullable ValueType valueType) {
        if (valueType == null) {
            return DocValueFormat.RAW;
        }
        DocValueFormat valueFormat = valueType.defaultFormat;
        if (valueFormat instanceof DocValueFormat.Decimal && format != null) {
            valueFormat = new DocValueFormat.Decimal(format);
        }
        return valueFormat;
    }

    protected abstract MultiValuesSourceAggregatorFactory<VS, ?> innerBuild(SearchContext var1, Map<String, ValuesSourceConfig<VS>> var2, DocValueFormat var3, AggregatorFactory<?> var4, AggregatorFactories.Builder var5) throws IOException;

    protected boolean serializeTargetValueType() {
        return false;
    }

    @Override
    public final XContentBuilder internalXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.fields != null) {
            for (Map.Entry<String, MultiValuesSourceFieldConfig> fieldEntry : this.fields.entrySet()) {
                builder.field(fieldEntry.getKey(), fieldEntry.getValue());
            }
        }
        if (this.format != null) {
            builder.field(AggregationBuilder.CommonFields.FORMAT.getPreferredName(), this.format);
        }
        if (this.valueType != null) {
            builder.field(AggregationBuilder.CommonFields.VALUE_TYPE.getPreferredName(), this.valueType.getPreferredName());
        }
        this.doXContentBody(builder, params);
        builder.endObject();
        return builder;
    }

    protected abstract XContentBuilder doXContentBody(XContentBuilder var1, ToXContent.Params var2) throws IOException;

    @Override
    protected final int doHashCode() {
        return Objects.hash(this.fields, this.format, this.targetValueType, this.valueType, this.innerHashCode());
    }

    protected abstract int innerHashCode();

    @Override
    protected final boolean doEquals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        MultiValuesSourceAggregationBuilder that = (MultiValuesSourceAggregationBuilder)other;
        return Objects.equals(this.fields, that.fields) && Objects.equals(this.format, that.format) && Objects.equals(this.valueType, that.valueType);
    }

    protected abstract boolean innerEquals(Object var1);

    public static abstract class LeafOnly<VS extends ValuesSource, AB extends MultiValuesSourceAggregationBuilder<VS, AB>>
    extends MultiValuesSourceAggregationBuilder<VS, AB> {
        protected LeafOnly(String name, ValueType targetValueType) {
            super(name, targetValueType);
        }

        protected LeafOnly(LeafOnly<VS, AB> clone, AggregatorFactories.Builder factoriesBuilder, Map<String, Object> metaData) {
            super(clone, factoriesBuilder, metaData);
            if (factoriesBuilder.count() > 0) {
                throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
            }
        }

        protected LeafOnly(StreamInput in, ValueType targetValueType) throws IOException {
            super(in, targetValueType);
        }

        @Override
        public AB subAggregations(AggregatorFactories.Builder subFactories) {
            throw new AggregationInitializationException("Aggregator [" + this.name + "] of type [" + this.getType() + "] cannot accept sub-aggregations");
        }
    }
}

