/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.cat;

import java.time.Instant;
import java.time.ZoneOffset;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsRequest;
import org.elasticsearch.action.admin.cluster.snapshots.get.GetSnapshotsResponse;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Table;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.action.RestResponseListener;
import org.elasticsearch.rest.action.cat.AbstractCatAction;
import org.elasticsearch.rest.action.cat.RestTable;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;

public class RestSnapshotAction
extends AbstractCatAction {
    private static final DateFormatter FORMATTER = DateFormatter.forPattern("HH:mm:ss").withZone(ZoneOffset.UTC);

    public RestSnapshotAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/snapshots", this);
        controller.registerHandler(RestRequest.Method.GET, "/_cat/snapshots/{repository}", this);
    }

    @Override
    public String getName() {
        return "cat_snapshot_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doCatRequest(final RestRequest request, NodeClient client) {
        GetSnapshotsRequest getSnapshotsRequest = new GetSnapshotsRequest().repository(request.param("repository")).snapshots(new String[]{"_all"});
        getSnapshotsRequest.ignoreUnavailable(request.paramAsBoolean("ignore_unavailable", getSnapshotsRequest.ignoreUnavailable()));
        getSnapshotsRequest.masterNodeTimeout(request.paramAsTime("master_timeout", getSnapshotsRequest.masterNodeTimeout()));
        return channel -> client.admin().cluster().getSnapshots(getSnapshotsRequest, (ActionListener<GetSnapshotsResponse>)new RestResponseListener<GetSnapshotsResponse>(channel){

            @Override
            public RestResponse buildResponse(GetSnapshotsResponse getSnapshotsResponse) throws Exception {
                return RestTable.buildResponse(RestSnapshotAction.this.buildTable(request, getSnapshotsResponse), this.channel);
            }
        });
    }

    @Override
    protected void documentation(StringBuilder sb) {
        sb.append("/_cat/snapshots/{repository}\n");
    }

    @Override
    protected Table getTableWithHeader(RestRequest request) {
        return new Table().startHeaders().addCell("id", "alias:id,snapshot;desc:unique snapshot").addCell("status", "alias:s,status;text-align:right;desc:snapshot name").addCell("start_epoch", "alias:ste,startEpoch;desc:start time in seconds since 1970-01-01 00:00:00").addCell("start_time", "alias:sti,startTime;desc:start time in HH:MM:SS").addCell("end_epoch", "alias:ete,endEpoch;desc:end time in seconds since 1970-01-01 00:00:00").addCell("end_time", "alias:eti,endTime;desc:end time in HH:MM:SS").addCell("duration", "alias:dur,duration;text-align:right;desc:duration").addCell("indices", "alias:i,indices;text-align:right;desc:number of indices").addCell("successful_shards", "alias:ss,successful_shards;text-align:right;desc:number of successful shards").addCell("failed_shards", "alias:fs,failed_shards;text-align:right;desc:number of failed shards").addCell("total_shards", "alias:ts,total_shards;text-align:right;desc:number of total shards").addCell("reason", "default:false;alias:r,reason;desc:reason for failures").endHeaders();
    }

    private Table buildTable(RestRequest req, GetSnapshotsResponse getSnapshotsResponse) {
        Table table = this.getTableWithHeader(req);
        for (SnapshotInfo snapshotStatus : getSnapshotsResponse.getSnapshots()) {
            table.startRow();
            table.addCell(snapshotStatus.snapshotId().getName());
            table.addCell((Object)snapshotStatus.state());
            table.addCell(TimeUnit.SECONDS.convert(snapshotStatus.startTime(), TimeUnit.MILLISECONDS));
            table.addCell(FORMATTER.format(Instant.ofEpochMilli(snapshotStatus.startTime())));
            table.addCell(TimeUnit.SECONDS.convert(snapshotStatus.endTime(), TimeUnit.MILLISECONDS));
            table.addCell(FORMATTER.format(Instant.ofEpochMilli(snapshotStatus.endTime())));
            long durationMillis = snapshotStatus.state() == SnapshotState.IN_PROGRESS ? System.currentTimeMillis() - snapshotStatus.startTime() : snapshotStatus.endTime() - snapshotStatus.startTime();
            table.addCell(TimeValue.timeValueMillis(durationMillis));
            table.addCell(snapshotStatus.indices().size());
            table.addCell(snapshotStatus.successfulShards());
            table.addCell(snapshotStatus.failedShards());
            table.addCell(snapshotStatus.totalShards());
            table.addCell(snapshotStatus.reason());
            table.endRow();
        }
        return table;
    }
}

