/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.rest.action.admin.cluster;

import java.io.IOException;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsAction;
import org.elasticsearch.action.admin.cluster.configuration.AddVotingConfigExclusionsRequest;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;

public class RestAddVotingConfigExclusionAction
extends BaseRestHandler {
    private static final TimeValue DEFAULT_TIMEOUT = TimeValue.timeValueSeconds(30L);

    public RestAddVotingConfigExclusionAction(Settings settings, RestController controller) {
        super(settings);
        controller.registerHandler(RestRequest.Method.POST, "/_cluster/voting_config_exclusions/{node_name}", this);
    }

    @Override
    public String getName() {
        return "add_voting_config_exclusions_action";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        AddVotingConfigExclusionsRequest votingConfigExclusionsRequest = this.resolveVotingConfigExclusionsRequest(request);
        return channel -> client.execute(AddVotingConfigExclusionsAction.INSTANCE, votingConfigExclusionsRequest, new RestToXContentListener((RestChannel)channel));
    }

    AddVotingConfigExclusionsRequest resolveVotingConfigExclusionsRequest(RestRequest request) {
        String nodeName = request.param("node_name");
        return new AddVotingConfigExclusionsRequest(Strings.splitStringByCommaToArray(nodeName), TimeValue.parseTimeValue(request.param("timeout"), DEFAULT_TIMEOUT, this.getClass().getSimpleName() + ".timeout"));
    }
}

