/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.prefix.PrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.TermQueryPrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.prefix.tree.PackedQuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.QuadPrefixTree;
import org.apache.lucene.spatial.prefix.tree.SpatialPrefixTree;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.GeoUtils;
import org.elasticsearch.common.geo.ShapesAvailability;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.XShapeCollection;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.DistanceUnit;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.mapper.BaseGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

@Deprecated
public class LegacyGeoShapeFieldMapper
extends BaseGeoShapeFieldMapper {
    public static final String CONTENT_TYPE = "geo_shape";
    private static final Logger logger = LogManager.getLogger(LegacyGeoShapeFieldMapper.class);
    private static final DeprecationLogger DEPRECATION_LOGGER = new DeprecationLogger(logger);

    public LegacyGeoShapeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<ShapeBuilder.Orientation> orientation, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, ignoreZValue, indexSettings, multiFields, copyTo);
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        try {
            Object shape = context.parseExternalValue(Shape.class);
            if (shape == null) {
                ShapeBuilder shapeBuilder = ShapeParser.parse(context.parser(), this);
                if (shapeBuilder == null) {
                    return;
                }
                shape = shapeBuilder.buildS4J();
            }
            if (this.fieldType().pointsOnly()) {
                if (shape instanceof XShapeCollection && ((XShapeCollection)((Object)XShapeCollection.class.cast(shape))).pointsOnly()) {
                    List shapes = ((XShapeCollection)((Object)shape)).getShapes();
                    for (Shape s : shapes) {
                        this.indexShape(context, s);
                    }
                    return;
                }
                if (!(shape instanceof Point)) {
                    throw new MapperParsingException("[{" + this.fieldType().name() + "}] is configured for points only but a " + (shape instanceof JtsGeometry ? ((JtsGeometry)shape).getGeom().getGeometryType() : shape.getClass()) + " was found");
                }
            }
            this.indexShape(context, (Shape)shape);
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(this.fieldType.name());
        }
    }

    private void indexShape(ParseContext context, Shape shape) {
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(Arrays.asList(this.fieldType().defaultPrefixTreeStrategy().createIndexableFields(shape)));
        this.createFieldNamesField(context, fields);
        for (IndexableField field : fields) {
            context.doc().add(field);
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || !this.fieldType().tree().equals(this.indexCreatedVersion.onOrAfter(Version.V_6_6_0) ? "quadtree" : "geohash")) {
            builder.field(DeprecatedParameters.Names.TREE.getPreferredName(), this.fieldType().tree());
        }
        if (this.fieldType().treeLevels() != 0) {
            builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), this.fieldType().treeLevels());
        } else if (includeDefaults && this.fieldType().precisionInMeters() == -1.0) {
            if ("geohash".equals(this.fieldType().tree())) {
                builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), DeprecatedParameters.Defaults.GEOHASH_TREE_LEVELS);
            } else if ("legacyquadtree".equals(this.fieldType().tree())) {
                builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), DeprecatedParameters.Defaults.QUADTREE_LEVELS);
            } else if ("quadtree".equals(this.fieldType().tree())) {
                builder.field(DeprecatedParameters.Names.TREE_LEVELS.getPreferredName(), DeprecatedParameters.Defaults.QUADTREE_LEVELS);
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + this.fieldType().tree() + "]");
            }
        }
        if (this.fieldType().precisionInMeters() != -1.0) {
            builder.field(DeprecatedParameters.Names.PRECISION.getPreferredName(), DistanceUnit.METERS.toString(this.fieldType().precisionInMeters()));
        } else if (includeDefaults && this.fieldType().treeLevels() == 0) {
            builder.field(DeprecatedParameters.Names.PRECISION.getPreferredName(), DistanceUnit.METERS.toString(50.0));
        }
        if (this.indexCreatedVersion.onOrAfter(Version.V_7_0_0)) {
            builder.field(DeprecatedParameters.Names.STRATEGY.getPreferredName(), this.fieldType().strategy().getStrategyName());
        }
        if (includeDefaults || this.fieldType().distanceErrorPct() != this.fieldType().defaultDistanceErrorPct) {
            builder.field(DeprecatedParameters.Names.DISTANCE_ERROR_PCT.getPreferredName(), this.fieldType().distanceErrorPct());
        }
        if (this.fieldType().strategy() == SpatialStrategy.TERM) {
            if (includeDefaults || !this.fieldType().pointsOnly()) {
                builder.field(DeprecatedParameters.Names.POINTS_ONLY.getPreferredName(), this.fieldType().pointsOnly());
            }
        } else if (includeDefaults || this.fieldType().pointsOnly()) {
            builder.field(DeprecatedParameters.Names.POINTS_ONLY.getPreferredName(), this.fieldType().pointsOnly());
        }
    }

    public static final class GeoShapeFieldType
    extends BaseGeoShapeFieldMapper.BaseGeoShapeFieldType {
        private String tree = "quadtree";
        private SpatialStrategy strategy = DeprecatedParameters.Defaults.STRATEGY;
        private boolean pointsOnly = false;
        private int treeLevels = 0;
        private double precisionInMeters = -1.0;
        private Double distanceErrorPct;
        private double defaultDistanceErrorPct = 0.0;
        private PrefixTreeStrategy defaultPrefixTreeStrategy;
        private RecursivePrefixTreeStrategy recursiveStrategy;
        private TermQueryPrefixTreeStrategy termStrategy;

        public GeoShapeFieldType() {
            this.setIndexOptions(IndexOptions.DOCS);
            this.setTokenized(false);
            this.setStored(false);
            this.setStoreTermVectors(false);
            this.setOmitNorms(true);
        }

        protected GeoShapeFieldType(GeoShapeFieldType ref) {
            super(ref);
            this.tree = ref.tree;
            this.strategy = ref.strategy;
            this.pointsOnly = ref.pointsOnly;
            this.treeLevels = ref.treeLevels;
            this.precisionInMeters = ref.precisionInMeters;
            this.distanceErrorPct = ref.distanceErrorPct;
            this.defaultDistanceErrorPct = ref.defaultDistanceErrorPct;
        }

        @Override
        public GeoShapeFieldType clone() {
            return new GeoShapeFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            GeoShapeFieldType that = (GeoShapeFieldType)o;
            return this.treeLevels == that.treeLevels && this.precisionInMeters == that.precisionInMeters && this.defaultDistanceErrorPct == that.defaultDistanceErrorPct && Objects.equals(this.tree, that.tree) && Objects.equals(this.strategy, that.strategy) && this.pointsOnly == that.pointsOnly && Objects.equals(this.distanceErrorPct, that.distanceErrorPct);
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.tree, this.strategy, this.pointsOnly, this.treeLevels, this.precisionInMeters, this.distanceErrorPct, this.defaultDistanceErrorPct);
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts) {
            super.checkCompatibility(fieldType, conflicts);
            GeoShapeFieldType other = (GeoShapeFieldType)fieldType;
            if (this.strategy() != other.strategy()) {
                conflicts.add("mapper [" + this.name() + "] has different [strategy]");
            }
            if (!this.tree().equals(other.tree())) {
                conflicts.add("mapper [" + this.name() + "] has different [tree]");
            }
            if (this.pointsOnly() != other.pointsOnly()) {
                conflicts.add("mapper [" + this.name() + "] has different points_only");
            }
            if (this.treeLevels() != other.treeLevels()) {
                conflicts.add("mapper [" + this.name() + "] has different [tree_levels]");
            }
            if (this.precisionInMeters() != other.precisionInMeters()) {
                conflicts.add("mapper [" + this.name() + "] has different [precision]");
            }
        }

        public String tree() {
            return this.tree;
        }

        public void setTree(String tree) {
            this.checkIfFrozen();
            this.tree = tree;
        }

        public SpatialStrategy strategy() {
            return this.strategy;
        }

        public void setStrategy(SpatialStrategy strategy) {
            this.checkIfFrozen();
            this.strategy = strategy;
            if (this.strategy.equals(SpatialStrategy.TERM)) {
                this.pointsOnly = true;
            }
        }

        public boolean pointsOnly() {
            return this.pointsOnly;
        }

        public void setPointsOnly(boolean pointsOnly) {
            this.checkIfFrozen();
            this.pointsOnly = pointsOnly;
        }

        public int treeLevels() {
            return this.treeLevels;
        }

        public void setTreeLevels(int treeLevels) {
            this.checkIfFrozen();
            this.treeLevels = treeLevels;
        }

        public double precisionInMeters() {
            return this.precisionInMeters;
        }

        public void setPrecisionInMeters(double precisionInMeters) {
            this.checkIfFrozen();
            this.precisionInMeters = precisionInMeters;
        }

        public double distanceErrorPct() {
            return this.distanceErrorPct == null ? this.defaultDistanceErrorPct : this.distanceErrorPct;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.checkIfFrozen();
            this.distanceErrorPct = distanceErrorPct;
        }

        public void setDefaultDistanceErrorPct(double defaultDistanceErrorPct) {
            this.checkIfFrozen();
            this.defaultDistanceErrorPct = defaultDistanceErrorPct;
        }

        public PrefixTreeStrategy defaultPrefixTreeStrategy() {
            return this.defaultPrefixTreeStrategy;
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(SpatialStrategy strategy) {
            return this.resolvePrefixTreeStrategy(strategy.getStrategyName());
        }

        public PrefixTreeStrategy resolvePrefixTreeStrategy(String strategyName) {
            if (SpatialStrategy.RECURSIVE.getStrategyName().equals(strategyName)) {
                return this.recursiveStrategy;
            }
            if (SpatialStrategy.TERM.getStrategyName().equals(strategyName)) {
                return this.termStrategy;
            }
            throw new IllegalArgumentException("Unknown prefix tree strategy [" + strategyName + "]");
        }
    }

    public static class Builder
    extends BaseGeoShapeFieldMapper.Builder<BaseGeoShapeFieldMapper.Builder, LegacyGeoShapeFieldMapper> {
        DeprecatedParameters deprecatedParameters;

        public Builder(String name) {
            this(name, new DeprecatedParameters());
        }

        public Builder(String name, DeprecatedParameters deprecatedParameters) {
            super(name, new GeoShapeFieldType(), new GeoShapeFieldType());
            this.deprecatedParameters = deprecatedParameters;
        }

        @Override
        public GeoShapeFieldType fieldType() {
            return (GeoShapeFieldType)this.fieldType;
        }

        private void setupFieldTypeDeprecatedParameters(Mapper.BuilderContext context) {
            GeoShapeFieldType geoShapeFieldType;
            GeoShapeFieldType ft = this.fieldType();
            if (this.deprecatedParameters.strategy != null) {
                ft.setStrategy(this.deprecatedParameters.strategy);
            }
            if (this.deprecatedParameters.tree != null) {
                ft.setTree(this.deprecatedParameters.tree);
            } else if (context.indexCreatedVersion().before(Version.V_6_6_0)) {
                ft.setTree("geohash");
            }
            if (this.deprecatedParameters.treeLevels != null) {
                ft.setTreeLevels(this.deprecatedParameters.treeLevels);
            }
            if (this.deprecatedParameters.precision != null) {
                ft.setPrecisionInMeters(DistanceUnit.parse(this.deprecatedParameters.precision, DistanceUnit.DEFAULT, DistanceUnit.DEFAULT));
            }
            if (this.deprecatedParameters.distanceErrorPct != null) {
                ft.setDistanceErrorPct(this.deprecatedParameters.distanceErrorPct);
            }
            if (this.deprecatedParameters.pointsOnly != null) {
                ft.setPointsOnly(this.deprecatedParameters.pointsOnly);
            }
            if ((geoShapeFieldType = (GeoShapeFieldType)this.fieldType).treeLevels() == 0 && geoShapeFieldType.precisionInMeters() < 0.0) {
                geoShapeFieldType.setDefaultDistanceErrorPct(0.025);
            }
        }

        private void setupPrefixTrees() {
            GeohashPrefixTree prefixTree;
            GeoShapeFieldType ft = this.fieldType();
            if (ft.tree().equals("geohash")) {
                prefixTree = new GeohashPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), DeprecatedParameters.Defaults.GEOHASH_TREE_LEVELS, true));
            } else if (ft.tree().equals("legacyquadtree")) {
                prefixTree = new QuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), DeprecatedParameters.Defaults.QUADTREE_LEVELS, false));
            } else if (ft.tree().equals("quadtree")) {
                prefixTree = new PackedQuadPrefixTree((SpatialContext)ShapeBuilder.SPATIAL_CONTEXT, Builder.getLevels(ft.treeLevels(), ft.precisionInMeters(), DeprecatedParameters.Defaults.QUADTREE_LEVELS, false));
            } else {
                throw new IllegalArgumentException("Unknown prefix tree type [" + ft.tree() + "]");
            }
            RecursivePrefixTreeStrategy rpts = new RecursivePrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            rpts.setDistErrPct(ft.distanceErrorPct());
            rpts.setPruneLeafyBranches(false);
            ft.recursiveStrategy = rpts;
            TermQueryPrefixTreeStrategy termStrategy = new TermQueryPrefixTreeStrategy((SpatialPrefixTree)prefixTree, ft.name());
            termStrategy.setDistErrPct(ft.distanceErrorPct());
            ft.termStrategy = termStrategy;
            ft.defaultPrefixTreeStrategy = ft.resolvePrefixTreeStrategy(ft.strategy());
            ft.defaultPrefixTreeStrategy.setPointsOnly(ft.pointsOnly());
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            if (this.fieldType().name().isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            this.setupFieldTypeDeprecatedParameters(context);
            this.setupPrefixTrees();
        }

        private static int getLevels(int treeLevels, double precisionInMeters, int defaultLevels, boolean geoHash) {
            if (treeLevels > 0 || precisionInMeters >= 0.0) {
                return Math.max(treeLevels, precisionInMeters >= 0.0 ? (geoHash ? GeoUtils.geoHashLevelsForPrecision(precisionInMeters) : GeoUtils.quadTreeLevelsForPrecision(precisionInMeters)) : 0);
            }
            return defaultLevels;
        }

        @Override
        public LegacyGeoShapeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new LegacyGeoShapeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.orientation(), this.ignoreZValue(), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    @Deprecated
    public static class DeprecatedParameters {
        public SpatialStrategy strategy = null;
        public String tree = null;
        public Integer treeLevels = null;
        public String precision = null;
        public Boolean pointsOnly = null;
        public Double distanceErrorPct = null;

        public void setSpatialStrategy(SpatialStrategy strategy) {
            this.strategy = strategy;
        }

        public void setTree(String prefixTree) {
            this.tree = prefixTree;
        }

        public void setTreeLevels(int treeLevels) {
            this.treeLevels = treeLevels;
        }

        public void setPrecision(String precision) {
            this.precision = precision;
        }

        public void setPointsOnly(boolean pointsOnly) {
            if (this.strategy == SpatialStrategy.TERM && !pointsOnly) {
                throw new ElasticsearchParseException("points_only cannot be set to false for term strategy", new Object[0]);
            }
            this.pointsOnly = pointsOnly;
        }

        public void setDistanceErrorPct(double distanceErrorPct) {
            this.distanceErrorPct = distanceErrorPct;
        }

        public static boolean parse(String name, String fieldName, Object fieldNode, DeprecatedParameters deprecatedParameters) {
            if (Names.STRATEGY.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setSpatialStrategy(SpatialStrategy.fromString(fieldNode.toString()));
            } else if (Names.TREE.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setTree(fieldNode.toString());
            } else if (Names.TREE_LEVELS.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setTreeLevels(Integer.parseInt(fieldNode.toString()));
            } else if (Names.PRECISION.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setPrecision(fieldNode.toString());
            } else if (Names.DISTANCE_ERROR_PCT.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setDistanceErrorPct(Double.parseDouble(fieldNode.toString()));
            } else if (Names.POINTS_ONLY.match(fieldName, LoggingDeprecationHandler.INSTANCE)) {
                DeprecatedParameters.checkPrefixTreeSupport(fieldName);
                deprecatedParameters.setPointsOnly(XContentMapValues.nodeBooleanValue(fieldNode, name + "." + Names.POINTS_ONLY));
            } else {
                return false;
            }
            return true;
        }

        private static void checkPrefixTreeSupport(String fieldName) {
            if (!ShapesAvailability.JTS_AVAILABLE || !ShapesAvailability.SPATIAL4J_AVAILABLE) {
                throw new ElasticsearchParseException("Field parameter [{}] is not supported for [{}] field type", fieldName, LegacyGeoShapeFieldMapper.CONTENT_TYPE);
            }
            DEPRECATION_LOGGER.deprecated("Field parameter [{}] is deprecated and will be removed in a future version.", fieldName);
        }

        public static class Defaults {
            public static final SpatialStrategy STRATEGY = SpatialStrategy.RECURSIVE;
            public static final String TREE = "quadtree";
            public static final String PRECISION = "50m";
            public static final int QUADTREE_LEVELS = GeoUtils.quadTreeLevelsForPrecision("50m");
            public static final int GEOHASH_TREE_LEVELS = GeoUtils.geoHashLevelsForPrecision("50m");
            public static final boolean POINTS_ONLY = false;
            public static final double DISTANCE_ERROR_PCT = 0.025;
        }

        public static class PrefixTrees {
            public static final String LEGACY_QUADTREE = "legacyquadtree";
            public static final String QUADTREE = "quadtree";
            public static final String GEOHASH = "geohash";
        }

        public static class Names {
            public static final ParseField STRATEGY = new ParseField("strategy", new String[0]);
            public static final ParseField TREE = new ParseField("tree", new String[0]);
            public static final ParseField TREE_LEVELS = new ParseField("tree_levels", new String[0]);
            public static final ParseField PRECISION = new ParseField("precision", new String[0]);
            public static final ParseField DISTANCE_ERROR_PCT = new ParseField("distance_error_pct", new String[0]);
            public static final ParseField POINTS_ONLY = new ParseField("points_only", new String[0]);
        }
    }
}

