/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LatLonShape;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.index.IndexableField;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.geo.parsers.ShapeParser;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.geo.geometry.Circle;
import org.elasticsearch.geo.geometry.Geometry;
import org.elasticsearch.geo.geometry.GeometryCollection;
import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.LinearRing;
import org.elasticsearch.geo.geometry.MultiLine;
import org.elasticsearch.geo.geometry.MultiPoint;
import org.elasticsearch.geo.geometry.MultiPolygon;
import org.elasticsearch.geo.geometry.Point;
import org.elasticsearch.geo.geometry.Rectangle;
import org.elasticsearch.index.mapper.BaseGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;

public class GeoShapeFieldMapper
extends BaseGeoShapeFieldMapper {
    public GeoShapeFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, ignoreMalformed, coerce, ignoreZValue, indexSettings, multiFields, copyTo);
    }

    @Override
    public GeoShapeFieldType fieldType() {
        return (GeoShapeFieldType)super.fieldType();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        try {
            Object shape = context.parseExternalValue(Object.class);
            if (shape == null) {
                ShapeBuilder shapeBuilder = ShapeParser.parse(context.parser(), this);
                if (shapeBuilder == null) {
                    return;
                }
                shape = shapeBuilder.buildGeometry();
            }
            this.indexShape(context, shape);
        }
        catch (Exception e) {
            if (!((Boolean)this.ignoreMalformed.value()).booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(this.fieldType().name());
        }
    }

    private void indexShape(ParseContext context, Object luceneShape) {
        if (!(luceneShape instanceof Geometry)) {
            throw new IllegalArgumentException("invalid shape type found [" + luceneShape.getClass() + "] while indexing shape");
        }
        ((Geometry)luceneShape).visit((GeometryVisitor)new LuceneGeometryIndexer(context));
    }

    public static Polygon toLucenePolygon(org.elasticsearch.geo.geometry.Polygon polygon) {
        Polygon[] holes = new Polygon[polygon.getNumberOfHoles()];
        for (int i = 0; i < holes.length; ++i) {
            holes[i] = new Polygon(polygon.getHole(i).getLats(), polygon.getHole(i).getLons(), new Polygon[0]);
        }
        return new Polygon(polygon.getPolygon().getLats(), polygon.getPolygon().getLons(), holes);
    }

    private void indexFields(ParseContext context, Field[] fields) {
        ArrayList<IndexableField> flist = new ArrayList<IndexableField>(Arrays.asList(fields));
        this.createFieldNamesField(context, flist);
        for (IndexableField f : flist) {
            context.doc().add(f);
        }
    }

    private class LuceneGeometryIndexer
    implements GeometryVisitor<Void> {
        private ParseContext context;

        private LuceneGeometryIndexer(ParseContext context) {
            this.context = context;
        }

        public Void visit(Circle circle) {
            throw new IllegalArgumentException("invalid shape type found [Circle] while indexing shape");
        }

        public Void visit(GeometryCollection<?> collection) {
            for (Geometry geometry : collection) {
                geometry.visit((GeometryVisitor)this);
            }
            return null;
        }

        public Void visit(Line line) {
            GeoShapeFieldMapper.this.indexFields(this.context, LatLonShape.createIndexableFields((String)GeoShapeFieldMapper.this.name(), (org.apache.lucene.geo.Line)new org.apache.lucene.geo.Line(line.getLats(), line.getLons())));
            return null;
        }

        public Void visit(LinearRing ring) {
            throw new IllegalArgumentException("invalid shape type found [LinearRing] while indexing shape");
        }

        public Void visit(MultiLine multiLine) {
            for (Line line : multiLine) {
                this.visit(line);
            }
            return null;
        }

        public Void visit(MultiPoint multiPoint) {
            for (Point point : multiPoint) {
                this.visit(point);
            }
            return null;
        }

        public Void visit(MultiPolygon multiPolygon) {
            for (org.elasticsearch.geo.geometry.Polygon polygon : multiPolygon) {
                this.visit(polygon);
            }
            return null;
        }

        public Void visit(Point point) {
            GeoShapeFieldMapper.this.indexFields(this.context, LatLonShape.createIndexableFields((String)GeoShapeFieldMapper.this.name(), (double)point.getLat(), (double)point.getLon()));
            return null;
        }

        public Void visit(org.elasticsearch.geo.geometry.Polygon polygon) {
            GeoShapeFieldMapper.this.indexFields(this.context, LatLonShape.createIndexableFields((String)GeoShapeFieldMapper.this.name(), (Polygon)GeoShapeFieldMapper.toLucenePolygon(polygon)));
            return null;
        }

        public Void visit(Rectangle r) {
            Polygon p = new Polygon(new double[]{r.getMinLat(), r.getMinLat(), r.getMaxLat(), r.getMaxLat(), r.getMinLat()}, new double[]{r.getMinLon(), r.getMaxLon(), r.getMaxLon(), r.getMinLon(), r.getMinLon()}, new Polygon[0]);
            GeoShapeFieldMapper.this.indexFields(this.context, LatLonShape.createIndexableFields((String)GeoShapeFieldMapper.this.name(), (Polygon)p));
            return null;
        }
    }

    public static final class GeoShapeFieldType
    extends BaseGeoShapeFieldMapper.BaseGeoShapeFieldType {
        public GeoShapeFieldType() {
        }

        protected GeoShapeFieldType(GeoShapeFieldType ref) {
            super(ref);
        }

        @Override
        public GeoShapeFieldType clone() {
            return new GeoShapeFieldType(this);
        }
    }

    public static class Builder
    extends BaseGeoShapeFieldMapper.Builder<BaseGeoShapeFieldMapper.Builder, GeoShapeFieldMapper> {
        public Builder(String name) {
            super(name, new GeoShapeFieldType(), new GeoShapeFieldType());
        }

        @Override
        public GeoShapeFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new GeoShapeFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), this.coerce(context), this.ignoreZValue(), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }
}

