/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.PointValues;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BoostQuery;
import org.apache.lucene.search.DocValuesFieldExistsQuery;
import org.apache.lucene.search.IndexOrDocValuesQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.time.DateFormatter;
import org.elasticsearch.common.time.DateFormatters;
import org.elasticsearch.common.time.DateMathParser;
import org.elasticsearch.common.time.DateUtils;
import org.elasticsearch.common.util.LocaleUtils;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexNumericFieldData;
import org.elasticsearch.index.fielddata.plain.DocValuesIndexFieldData;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.TypeParsers;
import org.elasticsearch.index.query.QueryRewriteContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.search.DocValueFormat;

public final class DateFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "date";
    public static final DateFormatter DEFAULT_DATE_TIME_FORMATTER = DateFormatter.forPattern("strict_date_optional_time||epoch_millis");
    private Explicit<Boolean> ignoreMalformed;

    private DateFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.ignoreMalformed = ignoreMalformed;
    }

    @Override
    public DateFieldType fieldType() {
        return (DateFieldType)super.fieldType();
    }

    @Override
    protected String contentType() {
        return this.fieldType.typeName();
    }

    @Override
    protected DateFieldMapper clone() {
        return (DateFieldMapper)super.clone();
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        long timestamp;
        Object dateAsObject;
        Object dateAsString = context.externalValueSet() ? ((dateAsObject = context.externalValue()) == null ? null : dateAsObject.toString()) : context.parser().textOrNull();
        if (dateAsString == null) {
            dateAsString = this.fieldType().nullValueAsString();
        }
        if (dateAsString == null) {
            return;
        }
        try {
            timestamp = this.fieldType().parse((String)dateAsString);
        }
        catch (IllegalArgumentException | ElasticsearchParseException e) {
            if (this.ignoreMalformed.value().booleanValue()) {
                context.addIgnoredField(this.fieldType.name());
                return;
            }
            throw e;
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE) {
            fields.add(new LongPoint(this.fieldType().name(), timestamp));
        }
        if (this.fieldType().hasDocValues()) {
            fields.add(new SortedNumericDocValuesField(this.fieldType().name(), timestamp));
        } else if (this.fieldType().stored() || this.fieldType().indexOptions() != IndexOptions.NONE) {
            this.createFieldNamesField(context, fields);
        }
        if (this.fieldType().stored()) {
            fields.add(new StoredField(this.fieldType().name(), timestamp));
        }
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        DateFieldMapper other = (DateFieldMapper)mergeWith;
        if (other.ignoreMalformed.explicit()) {
            this.ignoreMalformed = other.ignoreMalformed;
        }
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.fieldType().nullValue() != null) {
            builder.field("null_value", this.fieldType().nullValueAsString());
        }
        if (includeDefaults || !this.fieldType().dateTimeFormatter().pattern().equals(DEFAULT_DATE_TIME_FORMATTER.pattern())) {
            builder.field("format", this.fieldType().dateTimeFormatter().pattern());
        }
        if (includeDefaults || !this.fieldType().dateTimeFormatter().locale().equals(DEFAULT_DATE_TIME_FORMATTER.locale())) {
            builder.field("locale", this.fieldType().dateTimeFormatter().locale());
        }
    }

    public static final class DateFieldType
    extends MappedFieldType {
        protected DateFormatter dateTimeFormatter;
        protected DateMathParser dateMathParser;
        protected Resolution resolution;

        DateFieldType() {
            this.setTokenized(false);
            this.setHasDocValues(true);
            this.setOmitNorms(true);
            this.setDateTimeFormatter(DEFAULT_DATE_TIME_FORMATTER);
            this.setResolution(Resolution.MILLISECONDS);
        }

        DateFieldType(DateFieldType other) {
            super(other);
            this.setDateTimeFormatter(other.dateTimeFormatter);
            this.setResolution(other.resolution);
        }

        @Override
        public MappedFieldType clone() {
            return new DateFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            DateFieldType that = (DateFieldType)o;
            return Objects.equals(this.dateTimeFormatter, that.dateTimeFormatter) && Objects.equals((Object)this.resolution, (Object)that.resolution);
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.dateTimeFormatter, this.resolution});
        }

        @Override
        public String typeName() {
            return this.resolution.type();
        }

        @Override
        public void checkCompatibility(MappedFieldType fieldType, List<String> conflicts) {
            super.checkCompatibility(fieldType, conflicts);
            DateFieldType other = (DateFieldType)fieldType;
            if (!Objects.equals(this.dateTimeFormatter.pattern(), other.dateTimeFormatter.pattern())) {
                conflicts.add("mapper [" + this.name() + "] has different [format] values");
            }
            if (!Objects.equals(this.dateTimeFormatter.locale(), other.dateTimeFormatter.locale())) {
                conflicts.add("mapper [" + this.name() + "] has different [locale] values");
            }
            if (!Objects.equals(this.resolution.type(), other.resolution.type())) {
                conflicts.add("mapper [" + this.name() + "] cannot change between milliseconds and nanoseconds");
            }
        }

        public DateFormatter dateTimeFormatter() {
            return this.dateTimeFormatter;
        }

        void setDateTimeFormatter(DateFormatter formatter) {
            this.checkIfFrozen();
            this.dateTimeFormatter = formatter;
            this.dateMathParser = this.dateTimeFormatter.toDateMathParser();
        }

        void setResolution(Resolution resolution) {
            this.checkIfFrozen();
            this.resolution = resolution;
        }

        protected DateMathParser dateMathParser() {
            return this.dateMathParser;
        }

        long parse(String value) {
            return this.resolution.convert(DateFormatters.from(this.dateTimeFormatter().parse(value)).toInstant());
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            if (this.hasDocValues()) {
                return new DocValuesFieldExistsQuery(this.name());
            }
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, @Nullable QueryShardContext context) {
            Query query = this.rangeQuery(value, value, true, true, ShapeRelation.INTERSECTS, null, null, context);
            if (this.boost() != 1.0f) {
                query = new BoostQuery(query, this.boost());
            }
            return query;
        }

        @Override
        public Query rangeQuery(Object lowerTerm, Object upperTerm, boolean includeLower, boolean includeUpper, ShapeRelation relation, @Nullable ZoneId timeZone, @Nullable DateMathParser forcedDateParser, QueryShardContext context) {
            long u;
            long l;
            DateMathParser parser;
            this.failIfNotIndexed();
            if (relation == ShapeRelation.DISJOINT) {
                throw new IllegalArgumentException("Field [" + this.name() + "] of type [" + this.typeName() + "] does not support DISJOINT ranges");
            }
            DateMathParser dateMathParser = parser = forcedDateParser == null ? this.dateMathParser : forcedDateParser;
            if (lowerTerm == null) {
                l = Long.MIN_VALUE;
            } else {
                l = this.parseToLong(lowerTerm, !includeLower, timeZone, parser, context);
                if (!includeLower) {
                    ++l;
                }
            }
            if (upperTerm == null) {
                u = Long.MAX_VALUE;
            } else {
                u = this.parseToLong(upperTerm, includeUpper, timeZone, parser, context);
                if (!includeUpper) {
                    --u;
                }
            }
            Query query = LongPoint.newRangeQuery(this.name(), l, u);
            if (this.hasDocValues()) {
                Query dvQuery = SortedNumericDocValuesField.newSlowRangeQuery(this.name(), l, u);
                query = new IndexOrDocValuesQuery(query, dvQuery);
            }
            return query;
        }

        public long parseToLong(Object value, boolean roundUp, @Nullable ZoneId zone, @Nullable DateMathParser forcedDateParser, QueryRewriteContext context) {
            DateMathParser dateParser = this.dateMathParser();
            if (forcedDateParser != null) {
                dateParser = forcedDateParser;
            }
            String strValue = value instanceof BytesRef ? ((BytesRef)value).utf8ToString() : value.toString();
            Instant instant = dateParser.parse(strValue, context::nowInMillis, roundUp, zone);
            return this.resolution.convert(instant);
        }

        @Override
        public MappedFieldType.Relation isFieldWithinQuery(IndexReader reader, Object from, Object to, boolean includeLower, boolean includeUpper, ZoneId timeZone, DateMathParser dateParser, QueryRewriteContext context) throws IOException {
            if (dateParser == null) {
                dateParser = this.dateMathParser;
            }
            long fromInclusive = Long.MIN_VALUE;
            if (from != null) {
                fromInclusive = this.parseToLong(from, !includeLower, timeZone, dateParser, context);
                if (!includeLower) {
                    if (fromInclusive == Long.MAX_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    ++fromInclusive;
                }
            }
            long toInclusive = Long.MAX_VALUE;
            if (to != null) {
                toInclusive = this.parseToLong(to, includeUpper, timeZone, dateParser, context);
                if (!includeUpper) {
                    if (toInclusive == Long.MIN_VALUE) {
                        return MappedFieldType.Relation.DISJOINT;
                    }
                    --toInclusive;
                }
            }
            if (PointValues.size(reader, this.name()) == 0L) {
                return MappedFieldType.Relation.DISJOINT;
            }
            long minValue = LongPoint.decodeDimension(PointValues.getMinPackedValue(reader, this.name()), 0);
            long maxValue = LongPoint.decodeDimension(PointValues.getMaxPackedValue(reader, this.name()), 0);
            if (minValue >= fromInclusive && maxValue <= toInclusive) {
                return MappedFieldType.Relation.WITHIN;
            }
            if (maxValue < fromInclusive || minValue > toInclusive) {
                return MappedFieldType.Relation.DISJOINT;
            }
            return MappedFieldType.Relation.INTERSECTS;
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder(String fullyQualifiedIndexName) {
            this.failIfNoDocValues();
            return new DocValuesIndexFieldData.Builder().numericType(this.resolution.numericType());
        }

        @Override
        public Object valueForDisplay(Object value) {
            Long val = (Long)value;
            if (val == null) {
                return null;
            }
            return this.dateTimeFormatter().format(this.resolution.toInstant(val).atZone(ZoneOffset.UTC));
        }

        @Override
        public DocValueFormat docValueFormat(@Nullable String format, ZoneId timeZone) {
            DateFormatter dateTimeFormatter = this.dateTimeFormatter;
            if (format != null) {
                dateTimeFormatter = DateFormatter.forPattern(format).withLocale(dateTimeFormatter.locale());
            }
            if (timeZone == null) {
                timeZone = ZoneOffset.UTC;
            }
            return new DocValueFormat.DateTime(dateTimeFormatter, timeZone, Resolution.MILLISECONDS);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        private final Resolution resolution;

        public TypeParser(Resolution resolution) {
            this.resolution = resolution;
        }

        @Override
        public Mapper.Builder<?, ?> parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            Builder builder = new Builder(name);
            builder.withResolution(this.resolution);
            TypeParsers.parseField(builder, name, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("null_value")) {
                    if (propNode == null) {
                        throw new MapperParsingException("Property [null_value] cannot be null.");
                    }
                    builder.nullValue(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (propName.equals("ignore_malformed")) {
                    builder.ignoreMalformed(XContentMapValues.nodeBooleanValue(propNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("locale")) {
                    builder.locale(LocaleUtils.parse(propNode.toString()));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("format")) {
                    builder.format(propNode.toString());
                    iterator.remove();
                    continue;
                }
                if (!TypeParsers.parseMultiField(builder, name, parserContext, propName, propNode)) continue;
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, DateFieldMapper> {
        private Boolean ignoreMalformed;
        private Explicit<String> format = new Explicit<String>(DEFAULT_DATE_TIME_FORMATTER.pattern(), false);
        private Locale locale;
        private Resolution resolution = Resolution.MILLISECONDS;

        public Builder(String name) {
            super(name, new DateFieldType(), new DateFieldType());
            this.builder = this;
            this.locale = Locale.ROOT;
        }

        @Override
        public DateFieldType fieldType() {
            return (DateFieldType)this.fieldType;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return (Builder)this.builder;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        public Builder locale(Locale locale) {
            this.locale = locale;
            return this;
        }

        public Locale locale() {
            return this.locale;
        }

        public String format() {
            return this.format.value();
        }

        public Builder format(String format) {
            this.format = new Explicit<String>(format, true);
            return this;
        }

        Builder withResolution(Resolution resolution) {
            this.resolution = resolution;
            return this;
        }

        public boolean isFormatterSet() {
            return this.format.explicit();
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            boolean hasPatternChanged;
            super.setupFieldType(context);
            String pattern = this.format.value();
            DateFormatter dateTimeFormatter = this.fieldType().dateTimeFormatter;
            boolean bl = hasPatternChanged = Strings.hasLength(pattern) && !Objects.equals(pattern, dateTimeFormatter.pattern());
            if (hasPatternChanged || !Objects.equals(((Builder)this.builder).locale, dateTimeFormatter.locale())) {
                this.fieldType().setDateTimeFormatter(DateFormatter.forPattern(pattern).withLocale(this.locale));
            }
            this.fieldType().setResolution(this.resolution);
        }

        @Override
        public DateFieldMapper build(Mapper.BuilderContext context) {
            this.setupFieldType(context);
            return new DateFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.ignoreMalformed(context), context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static enum Resolution {
        MILLISECONDS("date", IndexNumericFieldData.NumericType.DATE){

            @Override
            public long convert(Instant instant) {
                return instant.toEpochMilli();
            }

            @Override
            public Instant toInstant(long value) {
                return Instant.ofEpochMilli(value);
            }
        }
        ,
        NANOSECONDS("date_nanos", IndexNumericFieldData.NumericType.DATE_NANOSECONDS){

            @Override
            public long convert(Instant instant) {
                return DateUtils.toLong(instant);
            }

            @Override
            public Instant toInstant(long value) {
                return DateUtils.toInstant(value);
            }
        };

        private final String type;
        private final IndexNumericFieldData.NumericType numericType;

        private Resolution(String type, IndexNumericFieldData.NumericType numericType) {
            this.type = type;
            this.numericType = numericType;
        }

        public String type() {
            return this.type;
        }

        IndexNumericFieldData.NumericType numericType() {
            return this.numericType;
        }

        public abstract long convert(Instant var1);

        public abstract Instant toInstant(long var1);

        public static Resolution ofOrdinal(int ord) {
            for (Resolution resolution : Resolution.values()) {
                if (ord != resolution.ordinal()) continue;
                return resolution;
            }
            throw new IllegalArgumentException("unknown resolution ordinal [" + ord + "]");
        }
    }

    public static class Defaults {
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
    }
}

